// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package fft

import (
	"bytes"
	"reflect"
	"testing"
)

func TestDomainSerialization(t *testing.T) {

	domain := NewDomain(1 << 6)
	var reconstructed Domain

	var buf bytes.Buffer
	written, err := domain.WriteTo(&buf)
	if err != nil {
		t.Fatal(err)
	}
	var read int64
	read, err = reconstructed.ReadFrom(&buf)
	if err != nil {
		t.Fatal(err)
	}

	if written != read {
		t.Fatal("didn't read as many bytes as we wrote")
	}
	if !reflect.DeepEqual(domain, &reconstructed) {
		t.Fatal("Domain.SetBytes(Bytes()) failed")
	}
}
