#ifndef IPC_H
# define IPC_H

#include "bool.h"
#include "main.h"
#include "auth.h"

#define IPC_SEND_TIMEOUT_SECS 10

#define USER_LEN 16
/* Maximum username length. (Not including null terminator).
 * Must be at least 8  [strlen("%unknown")]
 *
 * If this is too large to send all in one go over a pipe, the server will 
 * complain and you should reduce it. 
 *
 * If you change this value also change USER_LEN at the top of makeauth.c.
 */

/* xxx.xxx.xxx.xxx
 * 123456789012345 */
#define PEER_LEN 15 /* for LIST command */

/* command types for child=>parent. parent uses "command" differently */
enum {
	cSTATUS,
	cCONNECT,
	cDISCONNECT,
	cAUTH,
	cDEAUTH,
	cLIST,		/* send me info about clients */
	cRESTART,	/* the server */
	cUPTIME		/* the time we #Connected */
};

/* XXX: should be in item.h */
struct clients {
	pid_t pid;
	pid_t onconnect;
	pid_t ondisconnect;
	int sok;
	int pwrite;	/* Pipe parent writes to for IPC */
	bool connected;
	char *peername;
	struct clients *next;
	char username[USER_LEN+1];
};

/* For child.h. e.g. LIST command */
struct clientlist {
	pid_t pid;
	bool connected;
	char username[USER_LEN+1];
	char peername[PEER_LEN+1];
};

struct pipe_msg_buf {
	pid_t from;
	int command;
	char username[USER_LEN+1];
};

extern bool make_pipes(int filedes[2]);
extern bool map_authfile(mmap_area *authfile);
extern bool unmap_authfile(mmap_area authfile);
extern bool writeable_authfile(bool writeable, mmap_area authfile);
extern bool send_clients_list(int pwrite, int sokcount, struct clients *first);
extern bool smallpipe(int filedes);

#endif /* IPC_H */
