typedef enum {
    DISPLAY_LIVE,  /* live display (default) */
    DISPLAY_CONTINUOUS_PREVIEW,  /* continuously playback the last 2
                                  * or so seconds of animation */
} DisplayMode;

enum {
    COLUMN_LABEL,
    COLUMN_THUMB,
    N_COLUMNS,
};

struct Interface {
    GString *gladexml_filename;
    GladeXML *xml;
    GtkWidget *window;
    GtkWidget *drawingarea;
    GtkWidget *guides_checkbutton;
    GtkTreeViewColumn *column_label;
    GtkTreeViewColumn *column_thumb;
    GtkListStore *liststore;

    GThread *display_thread;
    GThread *put_thread;

    GdkPixbuf *display;  /* frame to display on drawingarea (main
                          * display) */
    GdkPixbuf *guides;  /* pixbuf, possibly with alpha, representing
                         * guides */

    /* old pixbufs (currently in use) */
    GdkPixbuf *frame;

    GdkGC *gc_frame;
    GdkGC *gc_overlays;
    GdkGC *gc_guides;
    GdkPixbuf *pixbuf_averaged;
    GMutex *pixbufs_mutex;
    GMutex *grab_mutex;
    GTimer *fps_timer;
    glong total_frames;  /* for fps calculation */
    GArray *elapsed_time;  /* holds the last several elapsed times (fps counter) */

    gint current_frame;  /* for various displays of current_frame */

    /* display mode */
    DisplayMode display_mode;
    /* live */
    gboolean limit_fps;  /* should we limit live video fps? */
    gfloat max_fps;  /* limit live video */
    /* continuous preview */
    gfloat speed;  /* speed of preview, fps */
    gfloat hold;  /* hold live frame for this long, seconds */
    gfloat duration;  /* duration of the preview, seconds */

    struct Camera *camera;
    struct Animation *animation;
};

/* remove me */
gpointer test_average(struct Interface *interface, gint num);

struct Interface *frameworks_interface_run(struct Camera *camera);
gpointer frameworks_interface_quit(struct Interface *interface);

void frameworks_interface_sync_sliders(struct Interface *interface);

void frameworks_interface_resize_drawing_area(struct Interface *interface);
void frameworks_interface_connect_signals(struct Interface *interface);
void frameworks_interface_render(struct Interface *interface);
gboolean frameworks_interface_draw_frame(GtkWidget * widget,
					 GdkEventExpose * event,
					 struct Interface *interface);
void frameworks_interface_update_progressbar(struct Interface *interface,
                                             const gchar *text,
                                             gdouble fraction);
void frameworks_interface_change_brightness(GtkRange * range,
					    struct Interface *interface);
void frameworks_interface_change_whitebalance(GtkRange * range,
                                              struct Interface *interface);
void frameworks_interface_change_contrast(GtkRange * range,
                                              struct Interface *interface);
void frameworks_interface_change_hue(GtkRange * range,
                                              struct Interface *interface);
void frameworks_interface_change_color(GtkRange * range,
                                              struct Interface *interface);
void frameworks_interface_set_current_frame(struct Interface *interface, gint current_frame, gboolean scroll);
int frameworks_interface_put(GtkButton *button, struct Interface *interface);
gpointer frameworks_interface_put_thread(gpointer data);
void frameworks_interface_update_display_mode(struct Interface *interface);
void frameworks_interface_prefs_update_display_mode(struct Interface *interface);
