// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/sql/v1/cloud_sql_backup_runs.proto

package sql

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The status of a backup run.
type SqlBackupRunStatus int32

const (
	// The status of the run is unknown.
	SqlBackupRunStatus_SQL_BACKUP_RUN_STATUS_UNSPECIFIED SqlBackupRunStatus = 0
	// The backup operation was enqueued.
	SqlBackupRunStatus_ENQUEUED SqlBackupRunStatus = 1
	// The backup is overdue across a given backup window. Indicates a
	// problem. Example: Long-running operation in progress during
	// the whole window.
	SqlBackupRunStatus_OVERDUE SqlBackupRunStatus = 2
	// The backup is in progress.
	SqlBackupRunStatus_RUNNING SqlBackupRunStatus = 3
	// The backup failed.
	SqlBackupRunStatus_FAILED SqlBackupRunStatus = 4
	// The backup was successful.
	SqlBackupRunStatus_SUCCESSFUL SqlBackupRunStatus = 5
	// The backup was skipped (without problems) for a given backup
	// window. Example: Instance was idle.
	SqlBackupRunStatus_SKIPPED SqlBackupRunStatus = 6
	// The backup is about to be deleted.
	SqlBackupRunStatus_DELETION_PENDING SqlBackupRunStatus = 7
	// The backup deletion failed.
	SqlBackupRunStatus_DELETION_FAILED SqlBackupRunStatus = 8
	// The backup has been deleted.
	SqlBackupRunStatus_DELETED SqlBackupRunStatus = 9
)

// Enum value maps for SqlBackupRunStatus.
var (
	SqlBackupRunStatus_name = map[int32]string{
		0: "SQL_BACKUP_RUN_STATUS_UNSPECIFIED",
		1: "ENQUEUED",
		2: "OVERDUE",
		3: "RUNNING",
		4: "FAILED",
		5: "SUCCESSFUL",
		6: "SKIPPED",
		7: "DELETION_PENDING",
		8: "DELETION_FAILED",
		9: "DELETED",
	}
	SqlBackupRunStatus_value = map[string]int32{
		"SQL_BACKUP_RUN_STATUS_UNSPECIFIED": 0,
		"ENQUEUED":                          1,
		"OVERDUE":                           2,
		"RUNNING":                           3,
		"FAILED":                            4,
		"SUCCESSFUL":                        5,
		"SKIPPED":                           6,
		"DELETION_PENDING":                  7,
		"DELETION_FAILED":                   8,
		"DELETED":                           9,
	}
)

func (x SqlBackupRunStatus) Enum() *SqlBackupRunStatus {
	p := new(SqlBackupRunStatus)
	*p = x
	return p
}

func (x SqlBackupRunStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlBackupRunStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_enumTypes[0].Descriptor()
}

func (SqlBackupRunStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_enumTypes[0]
}

func (x SqlBackupRunStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlBackupRunStatus.Descriptor instead.
func (SqlBackupRunStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescGZIP(), []int{0}
}

// Defines the supported backup kinds.
type SqlBackupKind int32

const (
	// This is an unknown BackupKind.
	SqlBackupKind_SQL_BACKUP_KIND_UNSPECIFIED SqlBackupKind = 0
	// The snapshot based backups
	SqlBackupKind_SNAPSHOT SqlBackupKind = 1
	// Physical backups
	SqlBackupKind_PHYSICAL SqlBackupKind = 2
)

// Enum value maps for SqlBackupKind.
var (
	SqlBackupKind_name = map[int32]string{
		0: "SQL_BACKUP_KIND_UNSPECIFIED",
		1: "SNAPSHOT",
		2: "PHYSICAL",
	}
	SqlBackupKind_value = map[string]int32{
		"SQL_BACKUP_KIND_UNSPECIFIED": 0,
		"SNAPSHOT":                    1,
		"PHYSICAL":                    2,
	}
)

func (x SqlBackupKind) Enum() *SqlBackupKind {
	p := new(SqlBackupKind)
	*p = x
	return p
}

func (x SqlBackupKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlBackupKind) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_enumTypes[1].Descriptor()
}

func (SqlBackupKind) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_enumTypes[1]
}

func (x SqlBackupKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlBackupKind.Descriptor instead.
func (SqlBackupKind) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescGZIP(), []int{1}
}

// Type of backup (i.e. automated, on demand, etc).
type SqlBackupRunType int32

const (
	// This is an unknown BackupRun type.
	SqlBackupRunType_SQL_BACKUP_RUN_TYPE_UNSPECIFIED SqlBackupRunType = 0
	// The backup schedule automatically triggers a backup.
	SqlBackupRunType_AUTOMATED SqlBackupRunType = 1
	// The user manually triggers a backup.
	SqlBackupRunType_ON_DEMAND SqlBackupRunType = 2
)

// Enum value maps for SqlBackupRunType.
var (
	SqlBackupRunType_name = map[int32]string{
		0: "SQL_BACKUP_RUN_TYPE_UNSPECIFIED",
		1: "AUTOMATED",
		2: "ON_DEMAND",
	}
	SqlBackupRunType_value = map[string]int32{
		"SQL_BACKUP_RUN_TYPE_UNSPECIFIED": 0,
		"AUTOMATED":                       1,
		"ON_DEMAND":                       2,
	}
)

func (x SqlBackupRunType) Enum() *SqlBackupRunType {
	p := new(SqlBackupRunType)
	*p = x
	return p
}

func (x SqlBackupRunType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlBackupRunType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_enumTypes[2].Descriptor()
}

func (SqlBackupRunType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_enumTypes[2]
}

func (x SqlBackupRunType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlBackupRunType.Descriptor instead.
func (SqlBackupRunType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescGZIP(), []int{2}
}

// Backup runs delete request.
type SqlBackupRunsDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the backup run to delete. To find a backup run ID, use the
	// [list](https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1/backupRuns/list)
	// method.
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlBackupRunsDeleteRequest) Reset() {
	*x = SqlBackupRunsDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlBackupRunsDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlBackupRunsDeleteRequest) ProtoMessage() {}

func (x *SqlBackupRunsDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlBackupRunsDeleteRequest.ProtoReflect.Descriptor instead.
func (*SqlBackupRunsDeleteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescGZIP(), []int{0}
}

func (x *SqlBackupRunsDeleteRequest) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *SqlBackupRunsDeleteRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlBackupRunsDeleteRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Backup runs get request.
type SqlBackupRunsGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of this backup run.
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlBackupRunsGetRequest) Reset() {
	*x = SqlBackupRunsGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlBackupRunsGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlBackupRunsGetRequest) ProtoMessage() {}

func (x *SqlBackupRunsGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlBackupRunsGetRequest.ProtoReflect.Descriptor instead.
func (*SqlBackupRunsGetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescGZIP(), []int{1}
}

func (x *SqlBackupRunsGetRequest) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *SqlBackupRunsGetRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlBackupRunsGetRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Backup runs insert request.
type SqlBackupRunsInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string     `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *BackupRun `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlBackupRunsInsertRequest) Reset() {
	*x = SqlBackupRunsInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlBackupRunsInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlBackupRunsInsertRequest) ProtoMessage() {}

func (x *SqlBackupRunsInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlBackupRunsInsertRequest.ProtoReflect.Descriptor instead.
func (*SqlBackupRunsInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescGZIP(), []int{2}
}

func (x *SqlBackupRunsInsertRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlBackupRunsInsertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlBackupRunsInsertRequest) GetBody() *BackupRun {
	if x != nil {
		return x.Body
	}
	return nil
}

// Backup runs list request.
type SqlBackupRunsListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID, or "-" for all instances. This does not include
	// the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Maximum number of backup runs per response.
	MaxResults int32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlBackupRunsListRequest) Reset() {
	*x = SqlBackupRunsListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlBackupRunsListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlBackupRunsListRequest) ProtoMessage() {}

func (x *SqlBackupRunsListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlBackupRunsListRequest.ProtoReflect.Descriptor instead.
func (*SqlBackupRunsListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescGZIP(), []int{3}
}

func (x *SqlBackupRunsListRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlBackupRunsListRequest) GetMaxResults() int32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *SqlBackupRunsListRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SqlBackupRunsListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// A BackupRun resource.
type BackupRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#backupRun**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The status of this run.
	Status SqlBackupRunStatus `protobuf:"varint,2,opt,name=status,proto3,enum=google.cloud.sql.v1.SqlBackupRunStatus" json:"status,omitempty"`
	// The time the run was enqueued in UTC timezone in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**.
	EnqueuedTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=enqueued_time,json=enqueuedTime,proto3" json:"enqueued_time,omitempty"`
	// The identifier for this backup run. Unique only for a specific Cloud SQL
	// instance.
	Id int64 `protobuf:"varint,4,opt,name=id,proto3" json:"id,omitempty"`
	// The time the backup operation actually started in UTC timezone in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the backup operation completed in UTC timezone in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Information about why the backup operation failed. This is only present if
	// the run has the FAILED status.
	Error *OperationError `protobuf:"bytes,7,opt,name=error,proto3" json:"error,omitempty"`
	// The type of this run; can be either "AUTOMATED" or "ON_DEMAND". This field
	// defaults to "ON_DEMAND" and is ignored, when specified for insert requests.
	Type SqlBackupRunType `protobuf:"varint,8,opt,name=type,proto3,enum=google.cloud.sql.v1.SqlBackupRunType" json:"type,omitempty"`
	// The description of this run, only applicable to on-demand backups.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// The start time of the backup window during which this the backup was
	// attempted in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for
	// example **2012-11-15T16:19:00.094Z**.
	WindowStartTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=window_start_time,json=windowStartTime,proto3" json:"window_start_time,omitempty"`
	// Name of the database instance.
	Instance string `protobuf:"bytes,11,opt,name=instance,proto3" json:"instance,omitempty"`
	// The URI of this resource.
	SelfLink string `protobuf:"bytes,12,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Location of the backups.
	Location string `protobuf:"bytes,13,opt,name=location,proto3" json:"location,omitempty"`
	// Encryption configuration specific to a backup.
	DiskEncryptionConfiguration *DiskEncryptionConfiguration `protobuf:"bytes,16,opt,name=disk_encryption_configuration,json=diskEncryptionConfiguration,proto3" json:"disk_encryption_configuration,omitempty"`
	// Encryption status specific to a backup.
	DiskEncryptionStatus *DiskEncryptionStatus `protobuf:"bytes,17,opt,name=disk_encryption_status,json=diskEncryptionStatus,proto3" json:"disk_encryption_status,omitempty"`
	// Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
	BackupKind SqlBackupKind `protobuf:"varint,19,opt,name=backup_kind,json=backupKind,proto3,enum=google.cloud.sql.v1.SqlBackupKind" json:"backup_kind,omitempty"`
}

func (x *BackupRun) Reset() {
	*x = BackupRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupRun) ProtoMessage() {}

func (x *BackupRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupRun.ProtoReflect.Descriptor instead.
func (*BackupRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescGZIP(), []int{4}
}

func (x *BackupRun) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *BackupRun) GetStatus() SqlBackupRunStatus {
	if x != nil {
		return x.Status
	}
	return SqlBackupRunStatus_SQL_BACKUP_RUN_STATUS_UNSPECIFIED
}

func (x *BackupRun) GetEnqueuedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EnqueuedTime
	}
	return nil
}

func (x *BackupRun) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *BackupRun) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *BackupRun) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *BackupRun) GetError() *OperationError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *BackupRun) GetType() SqlBackupRunType {
	if x != nil {
		return x.Type
	}
	return SqlBackupRunType_SQL_BACKUP_RUN_TYPE_UNSPECIFIED
}

func (x *BackupRun) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *BackupRun) GetWindowStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.WindowStartTime
	}
	return nil
}

func (x *BackupRun) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *BackupRun) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *BackupRun) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *BackupRun) GetDiskEncryptionConfiguration() *DiskEncryptionConfiguration {
	if x != nil {
		return x.DiskEncryptionConfiguration
	}
	return nil
}

func (x *BackupRun) GetDiskEncryptionStatus() *DiskEncryptionStatus {
	if x != nil {
		return x.DiskEncryptionStatus
	}
	return nil
}

func (x *BackupRun) GetBackupKind() SqlBackupKind {
	if x != nil {
		return x.BackupKind
	}
	return SqlBackupKind_SQL_BACKUP_KIND_UNSPECIFIED
}

// Backup run list results.
type BackupRunsListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#backupRunsList**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// A list of backup runs in reverse chronological order of the enqueued time.
	Items []*BackupRun `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *BackupRunsListResponse) Reset() {
	*x = BackupRunsListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupRunsListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupRunsListResponse) ProtoMessage() {}

func (x *BackupRunsListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupRunsListResponse.ProtoReflect.Descriptor instead.
func (*BackupRunsListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescGZIP(), []int{5}
}

func (x *BackupRunsListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *BackupRunsListResponse) GetItems() []*BackupRun {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *BackupRunsListResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_sql_v1_cloud_sql_backup_runs_proto protoreflect.FileDescriptor

var file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x75, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f,
	0x73, 0x71, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x62, 0x0a,
	0x1a, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x22, 0x5f, 0x0a, 0x17, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75,
	0x6e, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x22, 0x86, 0x01, 0x0a, 0x1a, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x75, 0x6e, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x32, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18,
	0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x90, 0x01, 0x0a, 0x18,
	0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xf4,
	0x06, 0x0a, 0x09, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x3f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x75, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x3f, 0x0a, 0x0d, 0x65, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x65, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x39, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x11,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x1a, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x74, 0x0a, 0x1d, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x1b, 0x64, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5f, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x14, 0x64, 0x69, 0x73, 0x6b,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x43, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x4b, 0x69, 0x6e, 0x64, 0x22, 0x8a, 0x01, 0x0a, 0x16, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x75, 0x6e, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x12, 0x34, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x75, 0x6e, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x2a, 0xc4, 0x01, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x75, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x51, 0x4c,
	0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x51, 0x55, 0x45, 0x55, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x4f, 0x56, 0x45, 0x52, 0x44, 0x55, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x46,
	0x55, 0x4c, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10,
	0x06, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x09, 0x2a, 0x4c, 0x0a, 0x0d, 0x53, 0x71, 0x6c,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x51,
	0x4c, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53,
	0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x48, 0x59,
	0x53, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x02, 0x2a, 0x55, 0x0a, 0x10, 0x53, 0x71, 0x6c, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x53,
	0x51, 0x4c, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x02, 0x32, 0x97,
	0x06, 0x0a, 0x14, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x9e, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a, 0x3b, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x75, 0x6e, 0x73, 0x2f, 0x7b, 0x69, 0x64, 0x7d, 0x12, 0x98, 0x01, 0x0a, 0x03, 0x47, 0x65, 0x74,
	0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x75, 0x6e, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x22, 0x43,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x2f, 0x7b,
	0x69, 0x64, 0x7d, 0x12, 0x9f, 0x01, 0x0a, 0x06, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75,
	0x6e, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x3a,
	0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xa2, 0x01, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75,
	0x6e, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x1a, 0x7c, 0xca, 0x41, 0x17, 0x73,
	0x71, 0x6c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x42, 0x6c, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x42, 0x17, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f,
	0x76, 0x31, 0x3b, 0x73, 0x71, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescOnce sync.Once
	file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescData = file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDesc
)

func file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescGZIP() []byte {
	file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescOnce.Do(func() {
		file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescData)
	})
	return file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDescData
}

var file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_goTypes = []interface{}{
	(SqlBackupRunStatus)(0),             // 0: google.cloud.sql.v1.SqlBackupRunStatus
	(SqlBackupKind)(0),                  // 1: google.cloud.sql.v1.SqlBackupKind
	(SqlBackupRunType)(0),               // 2: google.cloud.sql.v1.SqlBackupRunType
	(*SqlBackupRunsDeleteRequest)(nil),  // 3: google.cloud.sql.v1.SqlBackupRunsDeleteRequest
	(*SqlBackupRunsGetRequest)(nil),     // 4: google.cloud.sql.v1.SqlBackupRunsGetRequest
	(*SqlBackupRunsInsertRequest)(nil),  // 5: google.cloud.sql.v1.SqlBackupRunsInsertRequest
	(*SqlBackupRunsListRequest)(nil),    // 6: google.cloud.sql.v1.SqlBackupRunsListRequest
	(*BackupRun)(nil),                   // 7: google.cloud.sql.v1.BackupRun
	(*BackupRunsListResponse)(nil),      // 8: google.cloud.sql.v1.BackupRunsListResponse
	(*timestamppb.Timestamp)(nil),       // 9: google.protobuf.Timestamp
	(*OperationError)(nil),              // 10: google.cloud.sql.v1.OperationError
	(*DiskEncryptionConfiguration)(nil), // 11: google.cloud.sql.v1.DiskEncryptionConfiguration
	(*DiskEncryptionStatus)(nil),        // 12: google.cloud.sql.v1.DiskEncryptionStatus
	(*Operation)(nil),                   // 13: google.cloud.sql.v1.Operation
}
var file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_depIdxs = []int32{
	7,  // 0: google.cloud.sql.v1.SqlBackupRunsInsertRequest.body:type_name -> google.cloud.sql.v1.BackupRun
	0,  // 1: google.cloud.sql.v1.BackupRun.status:type_name -> google.cloud.sql.v1.SqlBackupRunStatus
	9,  // 2: google.cloud.sql.v1.BackupRun.enqueued_time:type_name -> google.protobuf.Timestamp
	9,  // 3: google.cloud.sql.v1.BackupRun.start_time:type_name -> google.protobuf.Timestamp
	9,  // 4: google.cloud.sql.v1.BackupRun.end_time:type_name -> google.protobuf.Timestamp
	10, // 5: google.cloud.sql.v1.BackupRun.error:type_name -> google.cloud.sql.v1.OperationError
	2,  // 6: google.cloud.sql.v1.BackupRun.type:type_name -> google.cloud.sql.v1.SqlBackupRunType
	9,  // 7: google.cloud.sql.v1.BackupRun.window_start_time:type_name -> google.protobuf.Timestamp
	11, // 8: google.cloud.sql.v1.BackupRun.disk_encryption_configuration:type_name -> google.cloud.sql.v1.DiskEncryptionConfiguration
	12, // 9: google.cloud.sql.v1.BackupRun.disk_encryption_status:type_name -> google.cloud.sql.v1.DiskEncryptionStatus
	1,  // 10: google.cloud.sql.v1.BackupRun.backup_kind:type_name -> google.cloud.sql.v1.SqlBackupKind
	7,  // 11: google.cloud.sql.v1.BackupRunsListResponse.items:type_name -> google.cloud.sql.v1.BackupRun
	3,  // 12: google.cloud.sql.v1.SqlBackupRunsService.Delete:input_type -> google.cloud.sql.v1.SqlBackupRunsDeleteRequest
	4,  // 13: google.cloud.sql.v1.SqlBackupRunsService.Get:input_type -> google.cloud.sql.v1.SqlBackupRunsGetRequest
	5,  // 14: google.cloud.sql.v1.SqlBackupRunsService.Insert:input_type -> google.cloud.sql.v1.SqlBackupRunsInsertRequest
	6,  // 15: google.cloud.sql.v1.SqlBackupRunsService.List:input_type -> google.cloud.sql.v1.SqlBackupRunsListRequest
	13, // 16: google.cloud.sql.v1.SqlBackupRunsService.Delete:output_type -> google.cloud.sql.v1.Operation
	7,  // 17: google.cloud.sql.v1.SqlBackupRunsService.Get:output_type -> google.cloud.sql.v1.BackupRun
	13, // 18: google.cloud.sql.v1.SqlBackupRunsService.Insert:output_type -> google.cloud.sql.v1.Operation
	8,  // 19: google.cloud.sql.v1.SqlBackupRunsService.List:output_type -> google.cloud.sql.v1.BackupRunsListResponse
	16, // [16:20] is the sub-list for method output_type
	12, // [12:16] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_init() }
func file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_init() {
	if File_google_cloud_sql_v1_cloud_sql_backup_runs_proto != nil {
		return
	}
	file_google_cloud_sql_v1_cloud_sql_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlBackupRunsDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlBackupRunsGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlBackupRunsInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlBackupRunsListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupRunsListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_goTypes,
		DependencyIndexes: file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_depIdxs,
		EnumInfos:         file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_enumTypes,
		MessageInfos:      file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_msgTypes,
	}.Build()
	File_google_cloud_sql_v1_cloud_sql_backup_runs_proto = out.File
	file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_rawDesc = nil
	file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_goTypes = nil
	file_google_cloud_sql_v1_cloud_sql_backup_runs_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SqlBackupRunsServiceClient is the client API for SqlBackupRunsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlBackupRunsServiceClient interface {
	// Deletes the backup taken by a backup run.
	Delete(ctx context.Context, in *SqlBackupRunsDeleteRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a resource containing information about a backup run.
	Get(ctx context.Context, in *SqlBackupRunsGetRequest, opts ...grpc.CallOption) (*BackupRun, error)
	// Creates a new backup run on demand.
	Insert(ctx context.Context, in *SqlBackupRunsInsertRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all backup runs associated with the project or a given instance
	// and configuration in the reverse chronological order of the backup
	// initiation time.
	List(ctx context.Context, in *SqlBackupRunsListRequest, opts ...grpc.CallOption) (*BackupRunsListResponse, error)
}

type sqlBackupRunsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlBackupRunsServiceClient(cc grpc.ClientConnInterface) SqlBackupRunsServiceClient {
	return &sqlBackupRunsServiceClient{cc}
}

func (c *sqlBackupRunsServiceClient) Delete(ctx context.Context, in *SqlBackupRunsDeleteRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlBackupRunsService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlBackupRunsServiceClient) Get(ctx context.Context, in *SqlBackupRunsGetRequest, opts ...grpc.CallOption) (*BackupRun, error) {
	out := new(BackupRun)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlBackupRunsService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlBackupRunsServiceClient) Insert(ctx context.Context, in *SqlBackupRunsInsertRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlBackupRunsService/Insert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlBackupRunsServiceClient) List(ctx context.Context, in *SqlBackupRunsListRequest, opts ...grpc.CallOption) (*BackupRunsListResponse, error) {
	out := new(BackupRunsListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlBackupRunsService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlBackupRunsServiceServer is the server API for SqlBackupRunsService service.
type SqlBackupRunsServiceServer interface {
	// Deletes the backup taken by a backup run.
	Delete(context.Context, *SqlBackupRunsDeleteRequest) (*Operation, error)
	// Retrieves a resource containing information about a backup run.
	Get(context.Context, *SqlBackupRunsGetRequest) (*BackupRun, error)
	// Creates a new backup run on demand.
	Insert(context.Context, *SqlBackupRunsInsertRequest) (*Operation, error)
	// Lists all backup runs associated with the project or a given instance
	// and configuration in the reverse chronological order of the backup
	// initiation time.
	List(context.Context, *SqlBackupRunsListRequest) (*BackupRunsListResponse, error)
}

// UnimplementedSqlBackupRunsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlBackupRunsServiceServer struct {
}

func (*UnimplementedSqlBackupRunsServiceServer) Delete(context.Context, *SqlBackupRunsDeleteRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSqlBackupRunsServiceServer) Get(context.Context, *SqlBackupRunsGetRequest) (*BackupRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSqlBackupRunsServiceServer) Insert(context.Context, *SqlBackupRunsInsertRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (*UnimplementedSqlBackupRunsServiceServer) List(context.Context, *SqlBackupRunsListRequest) (*BackupRunsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

func RegisterSqlBackupRunsServiceServer(s *grpc.Server, srv SqlBackupRunsServiceServer) {
	s.RegisterService(&_SqlBackupRunsService_serviceDesc, srv)
}

func _SqlBackupRunsService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlBackupRunsDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlBackupRunsServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlBackupRunsService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlBackupRunsServiceServer).Delete(ctx, req.(*SqlBackupRunsDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlBackupRunsService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlBackupRunsGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlBackupRunsServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlBackupRunsService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlBackupRunsServiceServer).Get(ctx, req.(*SqlBackupRunsGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlBackupRunsService_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlBackupRunsInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlBackupRunsServiceServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlBackupRunsService/Insert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlBackupRunsServiceServer).Insert(ctx, req.(*SqlBackupRunsInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlBackupRunsService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlBackupRunsListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlBackupRunsServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlBackupRunsService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlBackupRunsServiceServer).List(ctx, req.(*SqlBackupRunsListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlBackupRunsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1.SqlBackupRunsService",
	HandlerType: (*SqlBackupRunsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _SqlBackupRunsService_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SqlBackupRunsService_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _SqlBackupRunsService_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SqlBackupRunsService_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1/cloud_sql_backup_runs.proto",
}
