// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package checks provides access to the Checks API.
//
// For product documentation, see: https://developers.google.com/checks
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/checks/v1alpha"
//	...
//	ctx := context.Background()
//	checksService, err := checks.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	checksService, err := checks.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	checksService, err := checks.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package checks // import "google.golang.org/api/checks/v1alpha"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "checks:v1alpha"
const apiName = "checks"
const apiVersion = "v1alpha"
const basePath = "https://checks.googleapis.com/"
const mtlsBasePath = "https://checks.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Test scope for access to the Zoo service
	XapiZooScope = "https://www.googleapis.com/auth/xapi.zoo"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/xapi.zoo",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Accounts = NewAccountsService(s)
	s.Privacypolicy = NewPrivacypolicyService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Accounts *AccountsService

	Privacypolicy *PrivacypolicyService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	rs.Apps = NewAccountsAppsService(s)
	return rs
}

type AccountsService struct {
	s *Service

	Apps *AccountsAppsService
}

func NewAccountsAppsService(s *Service) *AccountsAppsService {
	rs := &AccountsAppsService{s: s}
	rs.Operations = NewAccountsAppsOperationsService(s)
	return rs
}

type AccountsAppsService struct {
	s *Service

	Operations *AccountsAppsOperationsService
}

func NewAccountsAppsOperationsService(s *Service) *AccountsAppsOperationsService {
	rs := &AccountsAppsOperationsService{s: s}
	return rs
}

type AccountsAppsOperationsService struct {
	s *Service
}

func NewPrivacypolicyService(s *Service) *PrivacypolicyService {
	rs := &PrivacypolicyService{s: s}
	return rs
}

type PrivacypolicyService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Privacypolicy = NewProjectsPrivacypolicyService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Privacypolicy *ProjectsPrivacypolicyService
}

func NewProjectsPrivacypolicyService(s *Service) *ProjectsPrivacypolicyService {
	rs := &ProjectsPrivacypolicyService{s: s}
	rs.Operations = NewProjectsPrivacypolicyOperationsService(s)
	return rs
}

type ProjectsPrivacypolicyService struct {
	s *Service

	Operations *ProjectsPrivacypolicyOperationsService
}

func NewProjectsPrivacypolicyOperationsService(s *Service) *ProjectsPrivacypolicyOperationsService {
	rs := &ProjectsPrivacypolicyOperationsService{s: s}
	return rs
}

type ProjectsPrivacypolicyOperationsService struct {
	s *Service
}

// AnalyzePrivacyPolicyRequest: The request proto for
// AnalyzePrivacyPolicy method.
type AnalyzePrivacyPolicyRequest struct {
	// PrivacyPolicyPageContent: Web page raw HTML content for the privacy
	// policy page to be analyzed. Useful when the client wants to analyze a
	// privacy policy already fetched.
	PrivacyPolicyPageContent string `json:"privacyPolicyPageContent,omitempty"`

	// PrivacyPolicyUri: URL for the privacy policy page to be analyzed.
	// https://linter.aip.dev/140/uri (Use `uri` instead of `url` in field
	// name)
	PrivacyPolicyUri string `json:"privacyPolicyUri,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "PrivacyPolicyPageContent") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PrivacyPolicyPageContent")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AnalyzePrivacyPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzePrivacyPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AnalyzePrivacyPolicyResponse: The response proto for
// AnalyzePrivacyPolicy method.
type AnalyzePrivacyPolicyResponse struct {
	// DataPurposeAnnotations: List of all data types in the privacy policy.
	DataPurposeAnnotations []*PolicyPurposeOfUseAnnotation `json:"dataPurposeAnnotations,omitempty"`

	// DataTypeAnnotations: List of all data types in the privacy policy.
	DataTypeAnnotations []*PolicyDataTypeAnnotation `json:"dataTypeAnnotations,omitempty"`

	// HtmlContent: HTML content for the privacy policy page.
	HtmlContent string `json:"htmlContent,omitempty"`

	// LastUpdatedDateInfo: Information about the date when the privacy
	// policy was last updated.
	LastUpdatedDateInfo *LastUpdatedDate `json:"lastUpdatedDateInfo,omitempty"`

	// SectionAnnotations: List of all sections in the privacy policy.
	SectionAnnotations []*PolicySectionAnnotation `json:"sectionAnnotations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "DataPurposeAnnotations") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataPurposeAnnotations")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AnalyzePrivacyPolicyResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzePrivacyPolicyResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values. * A month and day, with a
// zero year (for example, an anniversary). * A year on its own, with a
// zero month and a zero day. * A year and month, with a zero day (for
// example, a credit card expiration date). Related types: *
// google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LastUpdatedDate: Information about the date when the privacy policy
// was last updated.
type LastUpdatedDate struct {
	// EndOffset: Byte offsets for the end of the date text inside the full
	// text.
	EndOffset int64 `json:"endOffset,omitempty,string"`

	// LastUpdatedDate: Date when the privacy policy was last updated.
	LastUpdatedDate *Date `json:"lastUpdatedDate,omitempty"`

	// StartOffset: Byte offsets for the start of the date text inside the
	// full text.
	StartOffset int64 `json:"startOffset,omitempty,string"`

	// TextContent: The bytes of actual text content in the section. NOTE: -
	// This will correspond to the whole sentence that includes the date. -
	// This field might contain HTML and it is not sanitized.
	TextContent string `json:"textContent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndOffset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LastUpdatedDate) MarshalJSON() ([]byte, error) {
	type NoMethod LastUpdatedDate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is
// the result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type PolicyDataTypeAnnotation struct {
	// DataType: Type of the data mentioned in the policy.
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Default value.
	//   "CONTACT_INFO_NAME" - Data type on the privacy policy describing
	// Contact Info name.
	//   "CONTACT_INFO_EMAIL_ADDRESS" - Data type on the privacy policy
	// describing Contact Info email address.
	//   "CONTACT_INFO_PHONE_NUMBER" - Data type on the privacy policy
	// describing Contact Info phone number.
	//   "CONTACT_INFO_MAILING_ADDRESS" - Data type on the privacy policy
	// describing Contact Info mailing address.
	//   "CONTACT_INFO_OTHER" - Data type on the privacy policy describing
	// Contact Info other.
	//   "IDENTITY_INFO_OTHER" - Data type on the privacy policy describing
	// Identity Info other.
	//   "USER_CONTENT_EMAIL_MESSAGES" - Data type on the privacy policy
	// describing User Content email messages.
	//   "USER_CONTENT_TEXT_MESSAGES" - Data type on the privacy policy
	// describing User Content text messages.
	//   "USER_CONTENT_OTHER_IN_APP_MESSAGES" - Data type on the privacy
	// policy describing User Content other in-app messages.
	//   "USER_CONTENT_PHOTOS" - Data type on the privacy policy describing
	// User Content photos.
	//   "USER_CONTENT_VIDEOS" - Data type on the privacy policy describing
	// User Content videos.
	//   "USER_CONTENT_MUSIC_FILES" - Data type on the privacy policy
	// describing User Content music files.
	//   "USER_CONTENT_VOICE_OR_SOUND_RECORDINGS" - Data type on the privacy
	// policy describing User Content voice or sound recordings.
	//   "USER_CONTENT_OTHER_AUDIO_FILES" - Data type on the privacy policy
	// describing User Content other audio files.
	//   "USER_CONTENT_FILES_AND_DOCS" - Data type on the privacy policy
	// describing User Content files or documents.
	//   "USER_CONTENT_GAMEPLAY_DATA" - Data type on the privacy policy
	// describing User Content gameplay data.
	//   "USER_CONTENT_CUSTOMER_SUPPORT" - Data type on the privacy policy
	// describing User Content customer support.
	//   "COOKIES_AND_TRACKING_ELEMENTS" - Data type on the privacy policy
	// describing Cookies and other tracking elements, e.g. web beacons.
	//   "BROWSING_HISTORY" - Data type on the privacy policy describing
	// Browsing History.
	//   "SEARCH_HISTORY" - Data type on the privacy policy describing
	// Search History.
	//   "PURCHASE_HISTORY" - Data type on the privacy policy describing
	// Purchase History.
	//   "PRODUCT_INTERACTION" - Data type on the privacy policy describing
	// Product Interaction data.
	//   "USER_GENERATED_CONTENT_OTHER" - Data type on the privacy policy
	// describing other User Generated Content.
	//   "IN_APP_ACTIONS_OTHER" - Data type on the privacy policy describing
	// other User Generated Content.
	//   "ADVERTISING" - Data type on the privacy policy describing
	// Advertising data.
	//   "APP_CRASH_LOGS" - Data type on the privacy policy describing Crash
	// Logs data.
	//   "APP_DIAGNOSTICS" - Data type on the privacy policy describing App
	// Diagnostics data.
	//   "APP_PERFORMANCE_OTHER" - Data type on the privacy policy
	// describing other App Performance data.
	//   "USER_IDENTIFIERS" - Data type on the privacy policy describing
	// User or account-level IDs.
	//   "DEVICE_IDENTIFIERS" - Data type on the privacy policy describing
	// device-level IDs.
	//   "IP_ADDRESS" - Data type on the privacy policy describing IP
	// Addresses.
	//   "CONTACTS" - Data type on the privacy policy describing Contacts
	// data.
	//   "AUTHENTICATION_DATA" - Data type on the privacy policy describing
	// Authentication data, e.g. passwords.
	//   "CALENDAR_EVENTS_OR_NOTES" - Data type on the privacy policy
	// describing Calendar events or notes.
	//   "HEALTH" - Data type on the privacy policy describing Health data.
	//   "FITNESS" - Data type on the privacy policy describing Fitness
	// data.
	//   "LOCATION_PRECISE" - Data type on the privacy policy describing
	// Precise Location data.
	//   "LOCATION_COARSE" - Data type on the privacy policy describing
	// Coarse Location data.
	//   "LOCATION_GENERAL" - Data type on the privacy policy describing
	// general Location data, without specifying precise or coarse.
	//   "APPS_ON_DEVICE" - Data type on the privacy policy describing Apps
	// on Device.
	//   "FINANCIAL_PAYMENT_INFO" - Data type on the privacy policy
	// describing Financial Payment info.
	//   "FINANCIAL_CREDIT_INFO" - Data type on the privacy policy
	// describing Financial Credit info.
	//   "FINANCIAL_OTHER" - Data type on the privacy policy describing
	// Financial other data.
	//   "PERSONAL_INFO_RACE_AND_ETHNICITY" - Data type on the privacy
	// policy describing a user’s race or ethnicity.
	//   "PERSONAL_INFO_POLITICAL_OR_RELIGIOUS_BELIEFS" - Data type on the
	// privacy policy describing a user’s political or religious beliefs.
	//   "PERSONAL_INFO_SEXUAL_ORIENTATION" - Data type on the privacy
	// policy describing a user’s sexual orientation.
	//   "PERSONAL_INFO_OTHER" - Data type on the privacy policy describing
	// Personal Info other.
	//   "GENERIC_PERSONAL_INFORMATION" - Data type on the privacy policy
	// describing generic personal information, e.g. "we collection your
	// personal information."
	//   "UNSPECIFIED_INFORMATION" - Data type on the privacy policy
	// describing information in general with no speicific type, e.g. "we
	// collect information you voluntarily provide."
	//   "OTHER_DATA" - Data type on the privacy policy describing specific
	// types of data that are not covered by others labels, or ambiguous
	// cases where no clear type exists, e.g. "we collect your movement
	// data," which could be location, fitness, or even product interaction,
	// depending on the context.
	DataType string `json:"dataType,omitempty"`

	// EndOffset: Byte offsets for the end of the data type sentence inside
	// the full text.
	EndOffset int64 `json:"endOffset,omitempty,string"`

	// Score: Score given by the model representing how confident it was
	// regarding this `text_content` being of `data_type`.
	Score float64 `json:"score,omitempty"`

	// StartOffset: Byte offsets for the start of the data type sentence
	// inside the full text.
	StartOffset int64 `json:"startOffset,omitempty,string"`

	// TextContent: Actual text content in the section. This makes it much
	// easier to consume the information. NOTE: This field might contain
	// HTML and does not guarantee a SafeHtml security contract
	// go/safehtmltypecontracts#safehtml.
	TextContent string `json:"textContent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PolicyDataTypeAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyDataTypeAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *PolicyDataTypeAnnotation) UnmarshalJSON(data []byte) error {
	type NoMethod PolicyDataTypeAnnotation
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

type PolicyPurposeOfUseAnnotation struct {
	// EndOffset: Byte offsets for the end of the purpose of use sentence
	// inside the full text.
	EndOffset int64 `json:"endOffset,omitempty,string"`

	// PurposeOfUse: Purpose of use mentioned in the policy.
	//
	// Possible values:
	//   "PURPOSE_OF_USE_UNSPECIFIED" - Default value.
	//   "APP_FUNCTIONALITY" - Data is used for general app functions, or
	// interface with the user, e.g. customer support.
	//   "APP_DIAGNOSTICS_AND_PERFORMANCE" - Data is used for minimizing app
	// crashes, enabling scalability and performance, etc.
	//   "FRAUD_PREVENTION_AND_SECURITY" - Data is used for fraud
	// prevention, protecting user accounts, or other security purposes.
	//   "PRODUCT_PERSONALIZATION" - Data is used for
	// personalizing/customizing what the user sees.
	//   "ANALYTICS" - Data is used for evaluating user behavior, measuring
	// audience size, etc.
	//   "DEVELOPERS_COMMUNICATION_AND_MARKETING" - Data is used for sending
	// marketing communications directly to your users, notifications,
	// reminders, or update notices.
	//   "THIRD_PARTY_ADVERTISING" - Data is used by a third-party to
	// display ads in the app (or elsewhere).
	//   "GENERAL_ADVERTISING" - Data is used for displaying ads in the app,
	// or sharing data with entities who display ads.
	//   "LEGAL_COMPLIANCE" - Data is used for compliance with legal
	// obligations, e.g., regulations, government data requests, law
	// enforcement requests in general, etc.
	//   "MERGERS_AND_ACQUISITIONS" - If a company/organization merges or is
	// acquired it transfers users' information to another
	// company/organization.
	//   "OTHER_SPECIFIED_PURPOSE" - Any other specific purposes that are
	// not listed above.
	//   "NO_PURPOSE_MENTIONED" - The purpose of use is not explicitly
	// stated or unclear.
	PurposeOfUse string `json:"purposeOfUse,omitempty"`

	// Score: Score given by the model representing how confident it was
	// regarding this `text_content` being of `purpose_of_use`.
	Score float64 `json:"score,omitempty"`

	// StartOffset: Byte offsets for the start of the purpose of use
	// sentence inside the full text.
	StartOffset int64 `json:"startOffset,omitempty,string"`

	// TextContent: The bytes of actual text content in the sentence that
	// mentions the purpose of use. This makes it much easier to consume the
	// information. NOTE: This field might contain HTML and does not
	// guarantee a SafeHtml security contract
	// go/safehtmltypecontracts#safehtml.
	TextContent string `json:"textContent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndOffset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PolicyPurposeOfUseAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod PolicyPurposeOfUseAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *PolicyPurposeOfUseAnnotation) UnmarshalJSON(data []byte) error {
	type NoMethod PolicyPurposeOfUseAnnotation
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

type PolicySectionAnnotation struct {
	// EndOffset: Byte offsets for the end of the section inside the full
	// text.
	EndOffset int64 `json:"endOffset,omitempty,string"`

	// Score: Score given by the model representing how confident it was
	// regarding this `text_content` being of `section_type`.
	Score float64 `json:"score,omitempty"`

	// SectionType: Type of the high-level category in the policy.
	//
	// Possible values:
	//   "SECTION_TYPE_UNSPECIFIED" - Default value.
	//   "FIRST_PARTY_COLLECTION" - Section of the privacy policy describes
	// 1st party collection practices.
	//   "FIRST_PARTY_USE" - Section of the privacy policy describes 1st
	// party use practices.
	//   "THIRD_PARTY_SHARING" - Section of the privacy policy describes 3rd
	// party sharing practices.
	//   "CHILDREN_RELATED" - Section of the privacy policy describes
	// Children related content.
	//   "DATA_RETENTION" - Section of the privacy policy describes data
	// retention practices.
	//   "PRIVACY_CONTACT" - Section of the privacy policy references
	// privacy contact information.
	//   "RIGHT_TO_DELETE" - Section of the privacy policy describes users'
	// right of data deletion.
	//   "RIGHT_TO_RESTRICT_PROCESSING" - Section of the privacy policy
	// about users' right to restrict processing.
	//   "RIGHT_TO_ACCESS" - Section of the privacy policy about users'
	// right to access their data.
	//   "RIGHT_TO_RECTIFICATION" - Section of the privacy policy about
	// users' right to correct inaccuracies.
	//   "RIGHT_TO_KNOW_ABOUT_SELLING" - Section of the privacy policy about
	// users' right to know about information selling.
	//   "RIGHT_TO_KNOW_ABOUT_SHARING" - Section of the privacy policy about
	// users' right to know about information sharing.
	//   "RIGHT_TO_OPT_OUT_FROM_SELLING" - Section of the privacy policy
	// about users' right to opt out from information selling.
	//   "RIGHT_TO_OPT_OUT_FROM_SHARING" - Section of the privacy policy
	// about users' right to opt out from information sharing.
	//   "METHOD_TO_OPT_OUT_FROM_SELLING_OR_SHARING" - Section of the
	// privacy policy about the method to opt out from selling or sharing.
	//   "AUTHORIZED_AGENT" - Section of the privacy policy about the
	// authorized agent designated by user.
	//   "CCPA_CPRA_REFERENCE" - Section of the privacy policy about the
	// mentions of the CCPA or CPRA.
	//   "DATA_PROTECTION_OFFICER" - Section of the privacy policy about the
	// mentions of data protection officer (DPO).
	//   "DATA_CONTROLLER" - Section of the privacy policy about the
	// mentions of a data controller.
	//   "DO_NOT_SELL" - Section of the privacy policy stating that the
	// company does not sell data in general (or as defined by the CCPA),
	// without exceptions.
	//   "GDPR_REFERENCE" - Section of the privacy policy about the mentions
	// of the GDPR (General Data Protection Regulation).
	//   "LAWFUL_LEGAL_BASIS" - Section of the privacy policy about
	// lawful/legal basis for data processing.
	//   "PRIVACY_SHIELD" - Section of the privacy policy about the Privacy
	// Shielf framework.
	//   "RIGHT_TO_LODGE_A_COMPLAINT" - Section of the privacy policy about
	// the right to lodge a complaint with a supervisory authority.
	//   "TRANSFER_MECHANISMS" - Section of the privacy policy about
	// transfer mechanisms of data from the EU to third countries
	//   "NO_CHILDREN_DATA_COLLECTION" - Section of the privacy policy
	// stating that the company does not collect data from children.
	//   "NO_CHILDREN_DATA_SHARING" - Section of the privacy policy stating
	// that the company does not share data from children.
	//   "CHILDREN_INFORMATION_PUBLICITY" - Section of the privacy policy
	// stating whether the app allows children to make their personal
	// information publicly available.
	//   "PARENTS_METHOD_OF_INFORMATION_DELETION" - Section of the privacy
	// policy stating to parents/caregivers/guardians how they can request
	// the deletion of their child's personal information.
	//   "PARENTS_METHOD_TO_INFORMATION_REVIEW" - Section of the privacy
	// policy stating to parents/guardians/caregivers how they can review
	// their child's personal information.
	//   "PARENTS_METHOD_TO_STOP_FURTHER_INFORMATION_COLLECTION_USE" -
	// Section of the privacy policy stating to parents/caregivers/guardians
	// how they can stop the further collection or use of their child's
	// personal information.
	//   "PARENTS_RIGHT_TO_INFORMATION_DELETION" - Section of the privacy
	// policy stating that a parent/caregiver/guardian has the right to
	// request the deletion of their child's personal. information.
	//   "PARENTS_RIGHT_TO_INFORMATION_REVIEW" - Section of the privacy
	// policy stating to parents/guardians/caregivers that they have a right
	// to review their child's personal information.
	//   "PARENTS_RIGHT_TO_STOP_FURTHER_INFORMATION_COLLECTION_USE" -
	// Section of the privacy policy stating to parents/caregivers/guardians
	// that they have the right to stop the further collection or use of
	// their child's personal information.
	SectionType string `json:"sectionType,omitempty"`

	// StartOffset: Byte offsets for the start of the section inside the
	// full text.
	StartOffset int64 `json:"startOffset,omitempty,string"`

	// TextContent: Actual text content in the section. This makes it much
	// easier to consume the information. NOTE: This field might contain
	// HTML and does not guarantee a SafeHtml security contract
	// go/safehtmltypecontracts#safehtml.
	TextContent string `json:"textContent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndOffset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndOffset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PolicySectionAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod PolicySectionAnnotation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *PolicySectionAnnotation) UnmarshalJSON(data []byte) error {
	type NoMethod PolicySectionAnnotation
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "checks.accounts.apps.operations.get":

type AccountsAppsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *AccountsAppsOperationsService) Get(name string) *AccountsAppsOperationsGetCall {
	c := &AccountsAppsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAppsOperationsGetCall) Fields(s ...googleapi.Field) *AccountsAppsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAppsOperationsGetCall) IfNoneMatch(entityTag string) *AccountsAppsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAppsOperationsGetCall) Context(ctx context.Context) *AccountsAppsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAppsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAppsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "checks.accounts.apps.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsAppsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/apps/{appsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "checks.accounts.apps.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/apps/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/xapi.zoo"
	//   ]
	// }

}

// method id "checks.privacypolicy.analyze":

type PrivacypolicyAnalyzeCall struct {
	s                           *Service
	analyzeprivacypolicyrequest *AnalyzePrivacyPolicyRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Analyze: Analyzes the privacy policy of the given policy URL or
// content.
func (r *PrivacypolicyService) Analyze(analyzeprivacypolicyrequest *AnalyzePrivacyPolicyRequest) *PrivacypolicyAnalyzeCall {
	c := &PrivacypolicyAnalyzeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.analyzeprivacypolicyrequest = analyzeprivacypolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PrivacypolicyAnalyzeCall) Fields(s ...googleapi.Field) *PrivacypolicyAnalyzeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PrivacypolicyAnalyzeCall) Context(ctx context.Context) *PrivacypolicyAnalyzeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PrivacypolicyAnalyzeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PrivacypolicyAnalyzeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.analyzeprivacypolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/privacypolicy:analyze")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "checks.privacypolicy.analyze" call.
// Exactly one of *AnalyzePrivacyPolicyResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *AnalyzePrivacyPolicyResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PrivacypolicyAnalyzeCall) Do(opts ...googleapi.CallOption) (*AnalyzePrivacyPolicyResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AnalyzePrivacyPolicyResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Analyzes the privacy policy of the given policy URL or content.",
	//   "flatPath": "v1alpha/privacypolicy:analyze",
	//   "httpMethod": "POST",
	//   "id": "checks.privacypolicy.analyze",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1alpha/privacypolicy:analyze",
	//   "request": {
	//     "$ref": "AnalyzePrivacyPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "AnalyzePrivacyPolicyResponse"
	//   }
	// }

}

// method id "checks.projects.privacypolicy.operations.get":

type ProjectsPrivacypolicyOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsPrivacypolicyOperationsService) Get(name string) *ProjectsPrivacypolicyOperationsGetCall {
	c := &ProjectsPrivacypolicyOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsPrivacypolicyOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsPrivacypolicyOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsPrivacypolicyOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsPrivacypolicyOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsPrivacypolicyOperationsGetCall) Context(ctx context.Context) *ProjectsPrivacypolicyOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsPrivacypolicyOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPrivacypolicyOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "checks.projects.privacypolicy.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPrivacypolicyOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1alpha/projects/{projectsId}/privacypolicy/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "checks.projects.privacypolicy.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/privacypolicy/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/xapi.zoo"
	//   ]
	// }

}
