/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Entry;
import com.android.zipflinger.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class FreeStore {
    static final long DEFAULT_ALIGNMENT = 4L;
    static final long PAGE_ALIGNMENT = 4096L;
    private Zone head = new Zone();

    FreeStore(Map<String, Entry> zipEntries) {
        this.head.loc = new Location(-1L, 1L);
        ArrayList<Location> usedLocations = new ArrayList<Location>();
        for (Entry entry : zipEntries.values()) {
            usedLocations.add(entry.getLocation());
        }
        Collections.sort(usedLocations);
        Zone prevFreeZone = this.head;
        Location prevUsedLoc = prevFreeZone.loc;
        for (Location usedLoc : usedLocations) {
            long gap = usedLoc.first - prevUsedLoc.last - 1L;
            if (gap > 0L) {
                Zone free;
                prevFreeZone.next = free = new Zone();
                free.prev = prevFreeZone;
                free.loc = new Location(prevUsedLoc.last + 1L, gap);
                prevFreeZone = free;
            }
            prevUsedLoc = usedLoc;
        }
        Zone remainingZone = new Zone();
        remainingZone.prev = prevFreeZone;
        remainingZone.next = null;
        prevFreeZone.next = remainingZone;
        remainingZone.loc = new Location(prevUsedLoc.last + 1L, 0x7FFFFFFFFFFFFFFEL - prevUsedLoc.last);
    }

    Location ualloc(long requestedSize) {
        Zone cursor = this.head.next;
        while (cursor != null && cursor.loc.size() < requestedSize + 30L) {
            cursor = cursor.next;
        }
        if (cursor == null) {
            throw new IllegalStateException("Out of file address space.");
        }
        Location allocated = new Location(cursor.loc.first, requestedSize);
        cursor.shrinkBy(requestedSize);
        return allocated;
    }

    Location alloc(long requestedSize, long payloadOffset, long alignment) {
        Zone cursor = this.head.next;
        while (cursor != null) {
            long padding = FreeStore.padFor(cursor.loc.first, payloadOffset, alignment);
            if (cursor.loc.size() >= requestedSize + padding + 30L) {
                requestedSize += padding;
                break;
            }
            cursor = cursor.next;
        }
        if (cursor == null) {
            throw new IllegalStateException("Out of file address space.");
        }
        Location allocated = new Location(cursor.loc.first, requestedSize);
        cursor.shrinkBy(requestedSize);
        return allocated;
    }

    void free(Location loc) {
        Zone cursor = this.head.next;
        while (cursor != null && (loc.first <= cursor.prev.loc.last || loc.last >= cursor.loc.first)) {
            cursor = cursor.next;
        }
        if (cursor == null) {
            throw new IllegalStateException("Double free");
        }
        Zone newFreeZone = new Zone();
        newFreeZone.loc = loc;
        newFreeZone.prev = cursor.prev;
        newFreeZone.next = cursor;
        cursor.prev.next = newFreeZone;
        cursor.prev = newFreeZone;
        cursor = newFreeZone;
        if (cursor.prev.loc.last + 1L == cursor.loc.first && cursor.prev != this.head) {
            Zone prev = cursor.prev;
            prev.next = cursor.next;
            cursor.next.prev = prev;
            prev.loc = new Location(prev.loc.first, prev.loc.size() + cursor.loc.size());
            cursor = prev;
        }
        if (cursor.next != null && cursor.next.loc.first - 1L == cursor.loc.last) {
            Zone next = cursor.next;
            next.prev = cursor.prev;
            cursor.prev.next = next;
            next.loc = new Location(cursor.loc.first, cursor.loc.size() + next.loc.size());
        }
    }

    Location getLastFreeLocation() {
        Zone zone = this.head.next;
        while (zone.next != null) {
            zone = zone.next;
        }
        return zone.loc;
    }

    List<Location> getFreeLocations() {
        ArrayList<Location> locs = new ArrayList<Location>();
        Zone cursor = this.head.next;
        while (cursor != null) {
            locs.add(cursor.loc);
            cursor = cursor.next;
        }
        return locs;
    }

    static long padFor(long address, long offset, long alignment) {
        long pointer = address + offset;
        if (pointer % alignment == 0L) {
            return 0L;
        }
        return alignment - pointer % alignment;
    }

    protected static class Zone {
        public Zone next = null;
        public Zone prev = null;
        public Location loc;

        public void shrinkBy(long amount) {
            assert (this.loc.size() > amount);
            this.loc = new Location(this.loc.first + amount, this.loc.size() - amount);
            if (this.loc.size() == 0L) {
                this.prev.next = this.next;
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
            }
        }
    }
}

