/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.targeting;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.AutoValue_TargetedDirectorySegment;
import com.android.tools.build.bundletool.model.targeting.DimensionKeyValue;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.utils.DeviceTargetingUtils;
import com.android.tools.build.bundletool.model.utils.TextureCompressionUtils;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Int32Value;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class TargetedDirectorySegment {
    public static final String COUNTRY_SET_KEY = "countries";
    private static final String COUNTRY_SET_NAME_REGEX_STRING = "^[a-zA-Z][a-zA-Z0-9_]*$";
    private static final String SEGMENT_SPLIT_CHARACTER = "#";
    private static final Pattern LANGUAGE_CODE_PATTERN = Pattern.compile("^[a-zA-Z]{2,3}$");
    private static final Pattern COUNTRY_SET_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
    private static final String LANG_KEY = "lang";
    private static final String TCF_KEY = "tcf";
    private static final String DEVICE_TIER_KEY = "tier";
    private static final ImmutableSet<TargetingDimension> ALLOWED_NESTING_DIMENSIONS = ImmutableSet.of(TargetingDimension.COUNTRY_SET, TargetingDimension.DEVICE_TIER, TargetingDimension.TEXTURE_COMPRESSION_FORMAT);
    private static final int MAXIMUM_NESTING_DEPTH_ALLOWED = 2;
    private static final ImmutableMap<String, TargetingDimension> KEY_TO_DIMENSION = ImmutableMap.builder().put("countries", TargetingDimension.COUNTRY_SET).put("tier", TargetingDimension.DEVICE_TIER).put("lang", TargetingDimension.LANGUAGE).put("tcf", TargetingDimension.TEXTURE_COMPRESSION_FORMAT).build();
    private static final ImmutableSetMultimap<TargetingDimension, String> DIMENSION_TO_KEY = KEY_TO_DIMENSION.asMultimap().inverse();

    public abstract String getName();

    public abstract Targeting.AssetsDirectoryTargeting getTargeting();

    public abstract ImmutableList<TargetingDimension> getTargetingDimensionOrder();

    ImmutableList<TargetingDimension> getTargetingDimensions() {
        return TargetingUtils.getTargetingDimensions(this.getTargeting());
    }

    @CheckReturnValue
    public TargetedDirectorySegment removeTargeting(TargetingDimension dimension) {
        Targeting.AssetsDirectoryTargeting.Builder newTargeting = this.getTargeting().toBuilder();
        if (dimension.equals((Object)TargetingDimension.ABI) && this.getTargeting().hasAbi()) {
            newTargeting.clearAbi();
        } else if (dimension.equals((Object)TargetingDimension.LANGUAGE) && this.getTargeting().hasLanguage()) {
            newTargeting.clearLanguage();
        } else if (dimension.equals((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT) && this.getTargeting().hasTextureCompressionFormat()) {
            newTargeting.clearTextureCompressionFormat();
        } else if (dimension.equals((Object)TargetingDimension.DEVICE_TIER) && this.getTargeting().hasDeviceTier()) {
            newTargeting.clearDeviceTier();
        } else if (dimension.equals((Object)TargetingDimension.COUNTRY_SET) && this.getTargeting().hasCountrySet()) {
            newTargeting.clearCountrySet();
        } else {
            return this;
        }
        ImmutableList<TargetingDimension> updatedTargetingDimensionOrder = this.getTargetingDimensionOrder().stream().filter(targetingDimension -> !targetingDimension.equals((Object)dimension)).collect(ImmutableList.toImmutableList());
        return new AutoValue_TargetedDirectorySegment(this.getName(), newTargeting.build(), updatedTargetingDimensionOrder);
    }

    public static TargetedDirectorySegment parse(String directorySegment) {
        if (!directorySegment.contains(SEGMENT_SPLIT_CHARACTER)) {
            return TargetedDirectorySegment.create(directorySegment);
        }
        if (directorySegment.startsWith(SEGMENT_SPLIT_CHARACTER) || directorySegment.endsWith(SEGMENT_SPLIT_CHARACTER)) {
            throw InvalidBundleException.builder().withUserMessage("Cannot tokenize targeted directory '%s'. Expecting either '<name>' or '<name>#<key>_<value>' format.", directorySegment).build();
        }
        ImmutableList<String> pathFragments = ImmutableList.copyOf(directorySegment.split(SEGMENT_SPLIT_CHARACTER));
        String baseName = (String)pathFragments.get(0);
        ImmutableMap<String, String> targetingKeyValues = pathFragments.stream().skip(1L).map(DimensionKeyValue::parse).collect(ImmutableMap.toImmutableMap(DimensionKeyValue::getDimensionKey, DimensionKeyValue::getDimensionValue, (v12, v22) -> {
            throw InvalidBundleException.builder().withUserMessage("No directory should be targeted more than once on the same dimension. Found directory '%s' targeted multiple times on same dimension.", directorySegment).build();
        }));
        TargetedDirectorySegment.validateNestedTargetingDimensions(targetingKeyValues, directorySegment);
        return TargetedDirectorySegment.create(baseName, targetingKeyValues);
    }

    public String toPathSegment() {
        ImmutableList.Builder pathFragmentsBuilder = ImmutableList.builder();
        pathFragmentsBuilder.add(this.getName());
        pathFragmentsBuilder.addAll((Iterable)this.getTargetingDimensionOrder().stream().map(this::convertTargetingToPathSegment).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList()));
        return String.join((CharSequence)"", pathFragmentsBuilder.build());
    }

    public static boolean pathMayContain(String path, TargetingDimension dimension) {
        ImmutableCollection keys2 = DIMENSION_TO_KEY.get((Object)dimension);
        return keys2.stream().anyMatch(key -> path.contains(SEGMENT_SPLIT_CHARACTER + key + "_"));
    }

    public static String constructTargetingSegmentPath(Targeting.AssetsDirectoryTargeting targeting, ImmutableList<TargetingDimension> targetingOrder) {
        return targetingOrder.stream().filter(dimension -> TargetedDirectorySegment.getTargetingValue(targeting, dimension).isPresent()).map(dimension -> String.format("#%s_%s", TargetedDirectorySegment.getTargetingKey(dimension).get(), TargetedDirectorySegment.getTargetingValue(targeting, dimension).get())).collect(Collectors.joining(""));
    }

    private Optional<String> convertTargetingToPathSegment(TargetingDimension dimension) {
        Optional<String> key = TargetedDirectorySegment.getTargetingKey(dimension);
        Optional<String> value = TargetedDirectorySegment.getTargetingValue(this.getTargeting(), dimension);
        if (key.isPresent() && value.isPresent()) {
            return Optional.of(String.format("#%s_%s", key.get(), value.get()));
        }
        return Optional.empty();
    }

    private static Optional<String> getTargetingValue(Targeting.AssetsDirectoryTargeting targeting, TargetingDimension dimension) {
        switch (dimension) {
            case COUNTRY_SET: {
                return targeting.getCountrySet().getValueList().stream().findFirst();
            }
            case DEVICE_TIER: {
                return targeting.getDeviceTier().getValueList().stream().map(tier -> Integer.toString(tier.getValue())).findFirst();
            }
            case LANGUAGE: {
                return targeting.getLanguage().getValueList().stream().findFirst();
            }
            case TEXTURE_COMPRESSION_FORMAT: {
                return targeting.getTextureCompressionFormat().getValueList().stream().map(tcfAlias -> TextureCompressionUtils.TARGETING_TO_TEXTURE.getOrDefault(tcfAlias.getAlias(), null)).filter(Objects::nonNull).findFirst();
            }
        }
        return Optional.empty();
    }

    private static void validateNestedTargetingDimensions(ImmutableMap<String, String> keyValues, String directorySegment) {
        if (keyValues.size() == 1) {
            return;
        }
        if (keyValues.size() > 2) {
            throw InvalidBundleException.builder().withUserMessage("No directory should target more than two dimension. Found directory '%s' targeting more than two dimension.", directorySegment).build();
        }
        keyValues.keySet().forEach(key -> {
            if (!KEY_TO_DIMENSION.containsKey(key)) {
                throw InvalidBundleException.builder().withUserMessage("Unrecognized key: '%s' used in targeting of directory '%s'.", key, directorySegment).build();
            }
            if (!ALLOWED_NESTING_DIMENSIONS.contains((Object)KEY_TO_DIMENSION.get(key))) {
                throw InvalidBundleException.builder().withUserMessage("Targeting dimension '%s' should not be nested with other dimensions. Found directory '%s' which nests the dimension with other dimensions.", new Object[]{KEY_TO_DIMENSION.get(key), directorySegment}).build();
            }
        });
    }

    private static TargetedDirectorySegment create(String name) {
        return new AutoValue_TargetedDirectorySegment(name, Targeting.AssetsDirectoryTargeting.getDefaultInstance(), ImmutableList.of());
    }

    private static TargetedDirectorySegment create(String name, ImmutableMap<String, String> dimensionKeyValues) {
        Targeting.AssetsDirectoryTargeting directoryTargeting = dimensionKeyValues.entrySet().stream().map(keyValue -> TargetedDirectorySegment.toAssetsDirectoryTargeting(name, (String)keyValue.getKey(), (String)keyValue.getValue())).reduce(Targeting.AssetsDirectoryTargeting.newBuilder(), Targeting.AssetsDirectoryTargeting.Builder::mergeFrom, (builderA, builderB) -> builderA.mergeFrom(builderB.build())).build();
        ImmutableList<TargetingDimension> targetingDimensionOrder = dimensionKeyValues.keySet().stream().map(KEY_TO_DIMENSION::get).collect(ImmutableList.toImmutableList());
        return new AutoValue_TargetedDirectorySegment(name, directoryTargeting, targetingDimensionOrder);
    }

    private static Optional<String> getTargetingKey(TargetingDimension dimension) {
        return DIMENSION_TO_KEY.get((Object)dimension).stream().findFirst();
    }

    private static Targeting.AssetsDirectoryTargeting toAssetsDirectoryTargeting(String name, String key, String value) {
        if (!KEY_TO_DIMENSION.containsKey(key)) {
            throw InvalidBundleException.builder().withUserMessage("Directory '%s' contains unsupported key '%s'.", name, key).build();
        }
        switch (KEY_TO_DIMENSION.get(key)) {
            case COUNTRY_SET: {
                return TargetedDirectorySegment.parseCountrySet(name, value);
            }
            case DEVICE_TIER: {
                return TargetedDirectorySegment.parseDeviceTier(name, value);
            }
            case LANGUAGE: {
                return TargetedDirectorySegment.parseLanguage(name, value);
            }
            case TEXTURE_COMPRESSION_FORMAT: {
                return TargetedDirectorySegment.parseTextureCompressionFormat(name, value);
            }
        }
        throw InvalidBundleException.builder().withUserMessage("Unrecognized key: '%s'.", key).build();
    }

    private static Targeting.AssetsDirectoryTargeting parseTextureCompressionFormat(String name, String value) {
        if (!TextureCompressionUtils.TEXTURE_TO_TARGETING.containsKey(value)) {
            throw InvalidBundleException.builder().withUserMessage("Unrecognized value of the texture compression format targeting '%s' for directory '%s'.", value, name).build();
        }
        return Targeting.AssetsDirectoryTargeting.newBuilder().setTextureCompressionFormat(TextureCompressionUtils.TEXTURE_TO_TARGETING.get(value)).build();
    }

    private static Targeting.AssetsDirectoryTargeting parseLanguage(String name, String value) {
        Matcher matcher = LANGUAGE_CODE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw InvalidBundleException.builder().withUserMessage("Expected 2- or 3-character language directory but got '%s' for directory '%s'.", value, name).build();
        }
        return Targeting.AssetsDirectoryTargeting.newBuilder().setLanguage(Targeting.LanguageTargeting.newBuilder().addValue(value.toLowerCase())).build();
    }

    private static Targeting.AssetsDirectoryTargeting parseDeviceTier(String name, String value) {
        DeviceTargetingUtils.validateDeviceTierForAssetsDirectory(name, value);
        return Targeting.AssetsDirectoryTargeting.newBuilder().setDeviceTier(Targeting.DeviceTierTargeting.newBuilder().addValue(Int32Value.of(Integer.parseInt(value)))).build();
    }

    private static Targeting.AssetsDirectoryTargeting parseCountrySet(String name, String value) {
        Matcher matcher = COUNTRY_SET_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw InvalidBundleException.builder().withUserMessage("Country set name should match the regex '%s' but got '%s' for directory '%s'.", COUNTRY_SET_NAME_REGEX_STRING, value, name).build();
        }
        return Targeting.AssetsDirectoryTargeting.newBuilder().setCountrySet(Targeting.CountrySetTargeting.newBuilder().addValue(value)).build();
    }
}

