/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.providers.selection;

import com.intellij.notebooks.visualization.CaretBasedCellSelectionModelKt;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellEventListener;
import com.intellij.notebooks.visualization.ui.providers.selection.EditorCellSelectionModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/selection/NotebookEditorCellSelectionDetector;", "Lcom/intellij/openapi/Disposable$Default;", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;)V", "editorImpl", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "selectionUpdateScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "selectionModel", "Lcom/intellij/notebooks/visualization/ui/providers/selection/EditorCellSelectionModel;", "scheduleSelectionUpdate", "", "updateSelectionByCarets", "getCellsByCaretSelection", "", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "caret", "Lcom/intellij/openapi/editor/Caret;", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookEditorCellSelectionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookEditorCellSelectionDetector.kt\ncom/intellij/notebooks/visualization/ui/providers/selection/NotebookEditorCellSelectionDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1374#2:81\n1460#2,5:82\n774#2:87\n865#2,2:88\n*S KotlinDebug\n*F\n+ 1 NotebookEditorCellSelectionDetector.kt\ncom/intellij/notebooks/visualization/ui/providers/selection/NotebookEditorCellSelectionDetector\n*L\n63#1:81\n63#1:82,5\n69#1:87\n69#1:88,2\n*E\n"})
public final class NotebookEditorCellSelectionDetector
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotebookCellInlayManager manager;
    @NotNull
    private final EditorImpl editorImpl;
    @NotNull
    private AtomicBoolean selectionUpdateScheduled;
    @NotNull
    private final EditorCellSelectionModel selectionModel;

    /*
     * WARNING - void declaration
     */
    public NotebookEditorCellSelectionDetector(@NotNull NotebookCellInlayManager manager) {
        void it;
        EditorCellSelectionModel editorCellSelectionModel;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.editorImpl = this.manager.getEditor();
        this.selectionUpdateScheduled = new AtomicBoolean(false);
        EditorCellSelectionModel editorCellSelectionModel2 = editorCellSelectionModel = new EditorCellSelectionModel();
        NotebookEditorCellSelectionDetector notebookEditorCellSelectionDetector = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it));
        notebookEditorCellSelectionDetector.selectionModel = editorCellSelectionModel;
        this.manager.addCellEventsListener(new EditorCellEventListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void onEditorCellEvents(List<? extends EditorCellEventListener.EditorCellEvent> events) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Iterable $this$filterIsInstance$iv = events;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof EditorCellEventListener.CellRemoved)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List removedCells = (List)destination$iv$iv;
                for (EditorCellEventListener.CellRemoved event : removedCells) {
                    selectionModel.removeCell(event.getCell());
                }
            }
        }, (Disposable)this);
        this.editorImpl.getCaretModel().addCaretListener(new CaretListener(){

            public void caretAdded(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.scheduleSelectionUpdate();
            }

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.scheduleSelectionUpdate();
            }

            public void caretRemoved(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.scheduleSelectionUpdate();
            }
        });
        this.updateSelectionByCarets();
    }

    private final void scheduleSelectionUpdate() {
        if (this.selectionUpdateScheduled.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> NotebookEditorCellSelectionDetector.scheduleSelectionUpdate$lambda$1(this));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectionByCarets() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        List list = this.editorImpl.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable iterable = list;
        EditorCellSelectionModel editorCellSelectionModel = this.selectionModel;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Caret it = (Caret)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = this.getCellsByCaretSelection(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        editorCellSelectionModel.replaceSelection((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorCell> getCellsByCaretSelection(Caret caret) {
        void $this$filterTo$iv$iv;
        DocumentEx documentEx = this.editorImpl.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        IntRange lines = CaretBasedCellSelectionModelKt.getSelectionLines((Document)documentEx, caret);
        Iterable $this$filter$iv = this.manager.getCells();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorCell it = (EditorCell)element$iv$iv;
            boolean bl = false;
            if (!NotebookVisualizationUiUtilKt.hasIntersectionWith(it.getInterval().getLines(), lines)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void scheduleSelectionUpdate$lambda$1(NotebookEditorCellSelectionDetector this$0) {
        try {
            if (!this$0.editorImpl.isDisposed()) {
                this$0.updateSelectionByCarets();
            }
        }
        finally {
            this$0.selectionUpdateScheduled.set(false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/selection/NotebookEditorCellSelectionDetector$Companion;", "", "<init>", "()V", "install", "", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull NotebookCellInlayManager manager) {
            NotebookEditorCellSelectionDetector notebookEditorCellSelectionDetector;
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            NotebookEditorCellSelectionDetector it = notebookEditorCellSelectionDetector = new NotebookEditorCellSelectionDetector(manager);
            boolean bl = false;
            Disposer.register((Disposable)manager, (Disposable)((Disposable)it));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

