// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeletePeeringConnectionParams creates a new DeletePeeringConnectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeletePeeringConnectionParams() *DeletePeeringConnectionParams {
	return &DeletePeeringConnectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeletePeeringConnectionParamsWithTimeout creates a new DeletePeeringConnectionParams object
// with the ability to set a timeout on a request.
func NewDeletePeeringConnectionParamsWithTimeout(timeout time.Duration) *DeletePeeringConnectionParams {
	return &DeletePeeringConnectionParams{
		timeout: timeout,
	}
}

// NewDeletePeeringConnectionParamsWithContext creates a new DeletePeeringConnectionParams object
// with the ability to set a context for a request.
func NewDeletePeeringConnectionParamsWithContext(ctx context.Context) *DeletePeeringConnectionParams {
	return &DeletePeeringConnectionParams{
		Context: ctx,
	}
}

// NewDeletePeeringConnectionParamsWithHTTPClient creates a new DeletePeeringConnectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeletePeeringConnectionParamsWithHTTPClient(client *http.Client) *DeletePeeringConnectionParams {
	return &DeletePeeringConnectionParams{
		HTTPClient: client,
	}
}

/*
DeletePeeringConnectionParams contains all the parameters to send to the API endpoint

	for the delete peering connection operation.

	Typically these are written to a http.Request.
*/
type DeletePeeringConnectionParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	/* PeeringConnectionID.

	   peering_connection_id is the slug ID of the peering connection
	*/
	PeeringConnectionID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete peering connection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePeeringConnectionParams) WithDefaults() *DeletePeeringConnectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete peering connection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeletePeeringConnectionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete peering connection params
func (o *DeletePeeringConnectionParams) WithTimeout(timeout time.Duration) *DeletePeeringConnectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete peering connection params
func (o *DeletePeeringConnectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete peering connection params
func (o *DeletePeeringConnectionParams) WithContext(ctx context.Context) *DeletePeeringConnectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete peering connection params
func (o *DeletePeeringConnectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete peering connection params
func (o *DeletePeeringConnectionParams) WithHTTPClient(client *http.Client) *DeletePeeringConnectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete peering connection params
func (o *DeletePeeringConnectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the delete peering connection params
func (o *DeletePeeringConnectionParams) WithLocationOrganizationID(locationOrganizationID string) *DeletePeeringConnectionParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the delete peering connection params
func (o *DeletePeeringConnectionParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the delete peering connection params
func (o *DeletePeeringConnectionParams) WithLocationProjectID(locationProjectID string) *DeletePeeringConnectionParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the delete peering connection params
func (o *DeletePeeringConnectionParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the delete peering connection params
func (o *DeletePeeringConnectionParams) WithLocationRegionProvider(locationRegionProvider *string) *DeletePeeringConnectionParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the delete peering connection params
func (o *DeletePeeringConnectionParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the delete peering connection params
func (o *DeletePeeringConnectionParams) WithLocationRegionRegion(locationRegionRegion *string) *DeletePeeringConnectionParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the delete peering connection params
func (o *DeletePeeringConnectionParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithPeeringConnectionID adds the peeringConnectionID to the delete peering connection params
func (o *DeletePeeringConnectionParams) WithPeeringConnectionID(peeringConnectionID string) *DeletePeeringConnectionParams {
	o.SetPeeringConnectionID(peeringConnectionID)
	return o
}

// SetPeeringConnectionID adds the peeringConnectionId to the delete peering connection params
func (o *DeletePeeringConnectionParams) SetPeeringConnectionID(peeringConnectionID string) {
	o.PeeringConnectionID = peeringConnectionID
}

// WriteToRequest writes these params to a swagger request
func (o *DeletePeeringConnectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param peering_connection_id
	if err := r.SetPathParam("peering_connection_id", o.PeeringConnectionID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
