// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// CreatePeeringConnectionsReader is a Reader for the CreatePeeringConnections structure.
type CreatePeeringConnectionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreatePeeringConnectionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreatePeeringConnectionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreatePeeringConnectionsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreatePeeringConnectionsOK creates a CreatePeeringConnectionsOK with default headers values
func NewCreatePeeringConnectionsOK() *CreatePeeringConnectionsOK {
	return &CreatePeeringConnectionsOK{}
}

/*
CreatePeeringConnectionsOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreatePeeringConnectionsOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215CreatePeeringConnectionsResponse
}

// IsSuccess returns true when this create peering connections o k response has a 2xx status code
func (o *CreatePeeringConnectionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create peering connections o k response has a 3xx status code
func (o *CreatePeeringConnectionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create peering connections o k response has a 4xx status code
func (o *CreatePeeringConnectionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create peering connections o k response has a 5xx status code
func (o *CreatePeeringConnectionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create peering connections o k response a status code equal to that given
func (o *CreatePeeringConnectionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create peering connections o k response
func (o *CreatePeeringConnectionsOK) Code() int {
	return 200
}

func (o *CreatePeeringConnectionsOK) Error() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peering_connections][%d] createPeeringConnectionsOK  %+v", 200, o.Payload)
}

func (o *CreatePeeringConnectionsOK) String() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peering_connections][%d] createPeeringConnectionsOK  %+v", 200, o.Payload)
}

func (o *CreatePeeringConnectionsOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215CreatePeeringConnectionsResponse {
	return o.Payload
}

func (o *CreatePeeringConnectionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215CreatePeeringConnectionsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePeeringConnectionsDefault creates a CreatePeeringConnectionsDefault with default headers values
func NewCreatePeeringConnectionsDefault(code int) *CreatePeeringConnectionsDefault {
	return &CreatePeeringConnectionsDefault{
		_statusCode: code,
	}
}

/*
CreatePeeringConnectionsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreatePeeringConnectionsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this create peering connections default response has a 2xx status code
func (o *CreatePeeringConnectionsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create peering connections default response has a 3xx status code
func (o *CreatePeeringConnectionsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create peering connections default response has a 4xx status code
func (o *CreatePeeringConnectionsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create peering connections default response has a 5xx status code
func (o *CreatePeeringConnectionsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create peering connections default response a status code equal to that given
func (o *CreatePeeringConnectionsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create peering connections default response
func (o *CreatePeeringConnectionsDefault) Code() int {
	return o._statusCode
}

func (o *CreatePeeringConnectionsDefault) Error() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peering_connections][%d] CreatePeeringConnections default  %+v", o._statusCode, o.Payload)
}

func (o *CreatePeeringConnectionsDefault) String() string {
	return fmt.Sprintf("[POST /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peering_connections][%d] CreatePeeringConnections default  %+v", o._statusCode, o.Payload)
}

func (o *CreatePeeringConnectionsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *CreatePeeringConnectionsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CreatePeeringConnectionsBody create peering connections body
swagger:model CreatePeeringConnectionsBody
*/
type CreatePeeringConnectionsBody struct {

	// acceptor is the token generator for the peering start process. The peer_name and peer_meta
	// of this peer will be used by all the dialers to identify the connection to the acceptor. In the
	// future we may provide a field/fields on the Peer to allow overrides of the peer_name so that they can
	// overide each individual dialer to have a different peer_name or peer_meta.
	Acceptor *models.HashicorpCloudGlobalNetworkManager20220215Peer `json:"acceptor,omitempty"`

	// dialers will take the token generated by the acceptor and dial back to the acceptor to establish
	// the peering. The acceptor will use each dialer's peer_name and peer_meta when generating a token.
	// Likewise the dialer will take the acceptor's peer_name and peer_meta when dialing back to the cluster.
	Dialers []*models.HashicorpCloudGlobalNetworkManager20220215PeerDialer `json:"dialers"`

	// location
	Location *CreatePeeringConnectionsParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this create peering connections body
func (o *CreatePeeringConnectionsBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAcceptor(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDialers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreatePeeringConnectionsBody) validateAcceptor(formats strfmt.Registry) error {
	if swag.IsZero(o.Acceptor) { // not required
		return nil
	}

	if o.Acceptor != nil {
		if err := o.Acceptor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "acceptor")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "acceptor")
			}
			return err
		}
	}

	return nil
}

func (o *CreatePeeringConnectionsBody) validateDialers(formats strfmt.Registry) error {
	if swag.IsZero(o.Dialers) { // not required
		return nil
	}

	for i := 0; i < len(o.Dialers); i++ {
		if swag.IsZero(o.Dialers[i]) { // not required
			continue
		}

		if o.Dialers[i] != nil {
			if err := o.Dialers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("body" + "." + "dialers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("body" + "." + "dialers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CreatePeeringConnectionsBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create peering connections body based on the context it is used
func (o *CreatePeeringConnectionsBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAcceptor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDialers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreatePeeringConnectionsBody) contextValidateAcceptor(ctx context.Context, formats strfmt.Registry) error {

	if o.Acceptor != nil {

		if swag.IsZero(o.Acceptor) { // not required
			return nil
		}

		if err := o.Acceptor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "acceptor")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "acceptor")
			}
			return err
		}
	}

	return nil
}

func (o *CreatePeeringConnectionsBody) contextValidateDialers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Dialers); i++ {

		if o.Dialers[i] != nil {

			if swag.IsZero(o.Dialers[i]) { // not required
				return nil
			}

			if err := o.Dialers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("body" + "." + "dialers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("body" + "." + "dialers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CreatePeeringConnectionsBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreatePeeringConnectionsBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreatePeeringConnectionsBody) UnmarshalBinary(b []byte) error {
	var res CreatePeeringConnectionsBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CreatePeeringConnectionsParamsBodyLocation location is the location where the peering connection should be created
swagger:model CreatePeeringConnectionsParamsBodyLocation
*/
type CreatePeeringConnectionsParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this create peering connections params body location
func (o *CreatePeeringConnectionsParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreatePeeringConnectionsParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create peering connections params body location based on the context it is used
func (o *CreatePeeringConnectionsParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreatePeeringConnectionsParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreatePeeringConnectionsParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreatePeeringConnectionsParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res CreatePeeringConnectionsParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
