#!/bin/sh
# Generate previews from cursors.

if ! command -v xcur2png > /dev/null; then
    echo "You need to install xcur2png." >&2
    exit 1
fi

if ! command -v montage > /dev/null; then
    echo "You need to install montage from imagemagick." >&2
    exit 1
fi

for theme in gentoo gentoo-blue gentoo-silver; do
    mkdir -p _create_preview.sh_tmp/png/
    mkdir _create_preview.sh_tmp/unique/

    find cursors/${theme}/cursors/* -type f -exec \
         xcur2png -d _create_preview.sh_tmp/png/ -c - {} \;

    for png in $(file _create_preview.sh_tmp/png/* | grep 48 | cut -d: -f1); do
        cp "${png}" _create_preview.sh_tmp/unique/
    done

    rm -f _create_preview.sh_tmp/unique/left_ptr_watch_02[012356789]*
    rm -f _create_preview.sh_tmp/unique/left_ptr_watch_03*
    rm -f _create_preview.sh_tmp/unique/left_ptr_watch_1*

    rm -f _create_preview.sh_tmp/unique/znurt_03[012345679]*
    rm -f _create_preview.sh_tmp/unique/znurt_04*
    rm -f _create_preview.sh_tmp/unique/znurt_1_*

    montage _create_preview.sh_tmp/unique/* \
            -geometry 48x48+4+4 -background 'transparent' preview_${theme}.png

    rm -rf _create_preview.sh_tmp/
done
