// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/tenant_service.proto

#include "google/cloud/talent/v4/tenant_connection.h"
#include "google/cloud/talent/v4/internal/tenant_connection_impl.h"
#include "google/cloud/talent/v4/internal/tenant_option_defaults.h"
#include "google/cloud/talent/v4/internal/tenant_stub_factory.h"
#include "google/cloud/talent/v4/internal/tenant_tracing_connection.h"
#include "google/cloud/talent/v4/tenant_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace talent_v4 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TenantServiceConnection::~TenantServiceConnection() = default;

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceConnection::CreateTenant(
    google::cloud::talent::v4::CreateTenantRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::talent::v4::Tenant> TenantServiceConnection::GetTenant(
    google::cloud::talent::v4::GetTenantRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceConnection::UpdateTenant(
    google::cloud::talent::v4::UpdateTenantRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status TenantServiceConnection::DeleteTenant(
    google::cloud::talent::v4::DeleteTenantRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::talent::v4::Tenant>
TenantServiceConnection::ListTenants(
    google::cloud::talent::v4::
        ListTenantsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::talent::v4::Tenant>>();
}

std::shared_ptr<TenantServiceConnection> MakeTenantServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 TenantServicePolicyOptionList>(options,
                                                                __func__);
  options = talent_v4_internal::TenantServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = talent_v4_internal::CreateDefaultTenantServiceStub(
      std::move(auth), options);
  return talent_v4_internal::MakeTenantServiceTracingConnection(
      std::make_shared<talent_v4_internal::TenantServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4
}  // namespace cloud
}  // namespace google
