// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#include "google/cloud/pubsub/internal/publisher_round_robin_decorator.h"
#include <memory>
#include <mutex>
#include <vector>

namespace google {
namespace cloud {
namespace pubsub_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PublisherRoundRobin::PublisherRoundRobin(
    std::vector<std::shared_ptr<PublisherStub>> children)
    : children_(std::move(children)) {}

StatusOr<google::pubsub::v1::Topic> PublisherRoundRobin::CreateTopic(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::Topic const& request) {
  return Child()->CreateTopic(context, options, request);
}

StatusOr<google::pubsub::v1::Topic> PublisherRoundRobin::UpdateTopic(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::UpdateTopicRequest const& request) {
  return Child()->UpdateTopic(context, options, request);
}

StatusOr<google::pubsub::v1::PublishResponse> PublisherRoundRobin::Publish(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::PublishRequest const& request) {
  return Child()->Publish(context, options, request);
}

StatusOr<google::pubsub::v1::Topic> PublisherRoundRobin::GetTopic(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::GetTopicRequest const& request) {
  return Child()->GetTopic(context, options, request);
}

StatusOr<google::pubsub::v1::ListTopicsResponse>
PublisherRoundRobin::ListTopics(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::ListTopicsRequest const& request) {
  return Child()->ListTopics(context, options, request);
}

StatusOr<google::pubsub::v1::ListTopicSubscriptionsResponse>
PublisherRoundRobin::ListTopicSubscriptions(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::ListTopicSubscriptionsRequest const& request) {
  return Child()->ListTopicSubscriptions(context, options, request);
}

StatusOr<google::pubsub::v1::ListTopicSnapshotsResponse>
PublisherRoundRobin::ListTopicSnapshots(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::ListTopicSnapshotsRequest const& request) {
  return Child()->ListTopicSnapshots(context, options, request);
}

Status PublisherRoundRobin::DeleteTopic(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::DeleteTopicRequest const& request) {
  return Child()->DeleteTopic(context, options, request);
}

StatusOr<google::pubsub::v1::DetachSubscriptionResponse>
PublisherRoundRobin::DetachSubscription(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::DetachSubscriptionRequest const& request) {
  return Child()->DetachSubscription(context, options, request);
}

StatusOr<google::iam::v1::Policy> PublisherRoundRobin::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return Child()->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> PublisherRoundRobin::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return Child()->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PublisherRoundRobin::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return Child()->TestIamPermissions(context, options, request);
}

future<StatusOr<google::pubsub::v1::PublishResponse>>
PublisherRoundRobin::AsyncPublish(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::pubsub::v1::PublishRequest const& request) {
  return Child()->AsyncPublish(cq, std::move(context), std::move(options),
                               request);
}

std::shared_ptr<PublisherStub> PublisherRoundRobin::Child() {
  std::unique_lock<std::mutex> lk(mu_);
  auto const current = current_;
  if (++current_ == children_.size()) current_ = 0;
  lk.unlock();
  return children_[current];
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_internal
}  // namespace cloud
}  // namespace google
