// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/snooze_service.proto

#include "google/cloud/monitoring/v3/internal/snooze_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SnoozeServiceTracingConnection::SnoozeServiceTracingConnection(
    std::shared_ptr<monitoring_v3::SnoozeServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::monitoring::v3::Snooze>
SnoozeServiceTracingConnection::CreateSnooze(
    google::monitoring::v3::CreateSnoozeRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::SnoozeServiceConnection::CreateSnooze");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateSnooze(request));
}

StreamRange<google::monitoring::v3::Snooze>
SnoozeServiceTracingConnection::ListSnoozes(
    google::monitoring::v3::ListSnoozesRequest request) {
  auto span =
      internal::MakeSpan("monitoring_v3::SnoozeServiceConnection::ListSnoozes");
  internal::OTelScope scope(span);
  auto sr = child_->ListSnoozes(std::move(request));
  return internal::MakeTracedStreamRange<google::monitoring::v3::Snooze>(
      std::move(span), std::move(sr));
}

StatusOr<google::monitoring::v3::Snooze>
SnoozeServiceTracingConnection::GetSnooze(
    google::monitoring::v3::GetSnoozeRequest const& request) {
  auto span =
      internal::MakeSpan("monitoring_v3::SnoozeServiceConnection::GetSnooze");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSnooze(request));
}

StatusOr<google::monitoring::v3::Snooze>
SnoozeServiceTracingConnection::UpdateSnooze(
    google::monitoring::v3::UpdateSnoozeRequest const& request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::SnoozeServiceConnection::UpdateSnooze");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateSnooze(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<monitoring_v3::SnoozeServiceConnection>
MakeSnoozeServiceTracingConnection(
    std::shared_ptr<monitoring_v3::SnoozeServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<SnoozeServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
