// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/conversational_search_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_CONVERSATIONAL_SEARCH_LOGGING_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_CONVERSATIONAL_SEARCH_LOGGING_DECORATOR_H

#include "google/cloud/discoveryengine/v1/internal/conversational_search_stub.h"
#include "google/cloud/tracing_options.h"
#include "google/cloud/version.h"
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ConversationalSearchServiceLogging
    : public ConversationalSearchServiceStub {
 public:
  ~ConversationalSearchServiceLogging() override = default;
  ConversationalSearchServiceLogging(
      std::shared_ptr<ConversationalSearchServiceStub> child,
      TracingOptions tracing_options, std::set<std::string> const& components);

  StatusOr<google::cloud::discoveryengine::v1::ConverseConversationResponse>
  ConverseConversation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::ConverseConversationRequest const&
          request) override;

  StatusOr<google::cloud::discoveryengine::v1::Conversation> CreateConversation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::CreateConversationRequest const&
          request) override;

  Status DeleteConversation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::DeleteConversationRequest const&
          request) override;

  StatusOr<google::cloud::discoveryengine::v1::Conversation> UpdateConversation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::UpdateConversationRequest const&
          request) override;

  StatusOr<google::cloud::discoveryengine::v1::Conversation> GetConversation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::GetConversationRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::ListConversationsResponse>
  ListConversations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::ListConversationsRequest const&
          request) override;

  StatusOr<google::cloud::discoveryengine::v1::AnswerQueryResponse> AnswerQuery(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::AnswerQueryRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::Answer> GetAnswer(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::GetAnswerRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::Session> CreateSession(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::CreateSessionRequest const& request)
      override;

  Status DeleteSession(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::DeleteSessionRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::Session> UpdateSession(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::UpdateSessionRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::Session> GetSession(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::GetSessionRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::ListSessionsResponse>
  ListSessions(grpc::ClientContext& context, Options const& options,
               google::cloud::discoveryengine::v1::ListSessionsRequest const&
                   request) override;

 private:
  std::shared_ptr<ConversationalSearchServiceStub> child_;
  TracingOptions tracing_options_;
};  // ConversationalSearchServiceLogging

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_CONVERSATIONAL_SEARCH_LOGGING_DECORATOR_H
