// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/node_types/v1/node_types.proto

#include "google/cloud/compute/node_types/v1/internal/node_types_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_node_types_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NodeTypesTracingConnection::NodeTypesTracingConnection(
    std::shared_ptr<compute_node_types_v1::NodeTypesConnection> child)
    : child_(std::move(child)) {}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::NodeTypesScopedList>>
NodeTypesTracingConnection::AggregatedListNodeTypes(
    google::cloud::cpp::compute::node_types::v1::AggregatedListNodeTypesRequest
        request) {
  auto span = internal::MakeSpan(
      "compute_node_types_v1::NodeTypesConnection::AggregatedListNodeTypes");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListNodeTypes(std::move(request));
  return internal::MakeTracedStreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::NodeTypesScopedList>>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::cpp::compute::v1::NodeType>
NodeTypesTracingConnection::GetNodeType(
    google::cloud::cpp::compute::node_types::v1::GetNodeTypeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_node_types_v1::NodeTypesConnection::GetNodeType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNodeType(request));
}

StreamRange<google::cloud::cpp::compute::v1::NodeType>
NodeTypesTracingConnection::ListNodeTypes(
    google::cloud::cpp::compute::node_types::v1::ListNodeTypesRequest request) {
  auto span = internal::MakeSpan(
      "compute_node_types_v1::NodeTypesConnection::ListNodeTypes");
  internal::OTelScope scope(span);
  auto sr = child_->ListNodeTypes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::NodeType>(std::move(span),
                                                 std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_node_types_v1::NodeTypesConnection>
MakeNodeTypesTracingConnection(
    std::shared_ptr<compute_node_types_v1::NodeTypesConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<NodeTypesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_node_types_v1_internal
}  // namespace cloud
}  // namespace google
