// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/commerce/consumer/procurement/v1/procurement_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMMERCE_CONSUMER_PROCUREMENT_V1_CONSUMER_PROCUREMENT_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMMERCE_CONSUMER_PROCUREMENT_V1_CONSUMER_PROCUREMENT_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/commerce/consumer/procurement/v1/procurement_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace commerce_consumer_procurement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ConsumerProcurementServiceConnectionIdempotencyPolicy {
 public:
  virtual ~ConsumerProcurementServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<ConsumerProcurementServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency PlaceOrder(
      google::cloud::commerce::consumer::procurement::v1::
          PlaceOrderRequest const& request);

  virtual google::cloud::Idempotency GetOrder(
      google::cloud::commerce::consumer::procurement::v1::GetOrderRequest const&
          request);

  virtual google::cloud::Idempotency ListOrders(
      google::cloud::commerce::consumer::procurement::v1::ListOrdersRequest
          request);
};

std::unique_ptr<ConsumerProcurementServiceConnectionIdempotencyPolicy>
MakeDefaultConsumerProcurementServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace commerce_consumer_procurement_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMMERCE_CONSUMER_PROCUREMENT_V1_CONSUMER_PROCUREMENT_CONNECTION_IDEMPOTENCY_POLICY_H
