// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securesourcemanager/v1/secure_source_manager.proto

#include "google/cloud/securesourcemanager/v1/secure_source_manager_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace securesourcemanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SecureSourceManagerConnectionIdempotencyPolicy::
    ~SecureSourceManagerConnectionIdempotencyPolicy() = default;

std::unique_ptr<SecureSourceManagerConnectionIdempotencyPolicy>
SecureSourceManagerConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SecureSourceManagerConnectionIdempotencyPolicy>(
      *this);
}

Idempotency SecureSourceManagerConnectionIdempotencyPolicy::ListInstances(
    google::cloud::securesourcemanager::v1::ListInstancesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecureSourceManagerConnectionIdempotencyPolicy::GetInstance(
    google::cloud::securesourcemanager::v1::GetInstanceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecureSourceManagerConnectionIdempotencyPolicy::CreateInstance(
    google::cloud::securesourcemanager::v1::CreateInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecureSourceManagerConnectionIdempotencyPolicy::DeleteInstance(
    google::cloud::securesourcemanager::v1::DeleteInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecureSourceManagerConnectionIdempotencyPolicy::ListRepositories(
    google::cloud::securesourcemanager::v1::
        ListRepositoriesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SecureSourceManagerConnectionIdempotencyPolicy::GetRepository(
    google::cloud::securesourcemanager::v1::GetRepositoryRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecureSourceManagerConnectionIdempotencyPolicy::CreateRepository(
    google::cloud::securesourcemanager::v1::CreateRepositoryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecureSourceManagerConnectionIdempotencyPolicy::DeleteRepository(
    google::cloud::securesourcemanager::v1::DeleteRepositoryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SecureSourceManagerConnectionIdempotencyPolicy::GetIamPolicyRepo(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SecureSourceManagerConnectionIdempotencyPolicy::SetIamPolicyRepo(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency
SecureSourceManagerConnectionIdempotencyPolicy::TestIamPermissionsRepo(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<SecureSourceManagerConnectionIdempotencyPolicy>
MakeDefaultSecureSourceManagerConnectionIdempotencyPolicy() {
  return std::make_unique<SecureSourceManagerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securesourcemanager_v1
}  // namespace cloud
}  // namespace google
