// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/encryption_spec.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_ENCRYPTION_SPEC_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_ENCRYPTION_SPEC_TRACING_CONNECTION_H

#include "google/cloud/dialogflow_es/encryption_spec_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class EncryptionSpecServiceTracingConnection
    : public dialogflow_es::EncryptionSpecServiceConnection {
 public:
  ~EncryptionSpecServiceTracingConnection() override = default;

  explicit EncryptionSpecServiceTracingConnection(
      std::shared_ptr<dialogflow_es::EncryptionSpecServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::dialogflow::v2::EncryptionSpec> GetEncryptionSpec(
      google::cloud::dialogflow::v2::GetEncryptionSpecRequest const& request)
      override;

  future<
      StatusOr<google::cloud::dialogflow::v2::InitializeEncryptionSpecResponse>>
  InitializeEncryptionSpec(
      google::cloud::dialogflow::v2::InitializeEncryptionSpecRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> InitializeEncryptionSpec(
      NoAwaitTag,
      google::cloud::dialogflow::v2::InitializeEncryptionSpecRequest const&
          request) override;

  future<
      StatusOr<google::cloud::dialogflow::v2::InitializeEncryptionSpecResponse>>
  InitializeEncryptionSpec(
      google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<dialogflow_es::EncryptionSpecServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dialogflow_es::EncryptionSpecServiceConnection>
MakeEncryptionSpecServiceTracingConnection(
    std::shared_ptr<dialogflow_es::EncryptionSpecServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_INTERNAL_ENCRYPTION_SPEC_TRACING_CONNECTION_H
