// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/job.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_JOB_REST_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_JOB_REST_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/internal/rest_client.h"
#include "google/cloud/internal/rest_context.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/bigquery/v2/job.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class JobServiceRestStub {
 public:
  virtual ~JobServiceRestStub() = default;

  virtual StatusOr<google::cloud::bigquery::v2::JobCancelResponse> CancelJob(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::CancelJobRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::Job> GetJob(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::GetJobRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::Job> InsertJob(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::InsertJobRequest const& request) = 0;

  virtual Status DeleteJob(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::DeleteJobRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::JobList> ListJobs(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::ListJobsRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::GetQueryResultsResponse>
  GetQueryResults(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::GetQueryResultsRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::QueryResponse> Query(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::PostQueryRequest const& request) = 0;
};

class DefaultJobServiceRestStub : public JobServiceRestStub {
 public:
  ~DefaultJobServiceRestStub() override = default;

  explicit DefaultJobServiceRestStub(Options options);
  DefaultJobServiceRestStub(std::shared_ptr<rest_internal::RestClient> service,
                            Options options);

  StatusOr<google::cloud::bigquery::v2::JobCancelResponse> CancelJob(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::CancelJobRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Job> GetJob(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::GetJobRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Job> InsertJob(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::InsertJobRequest const& request) override;

  Status DeleteJob(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::DeleteJobRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::JobList> ListJobs(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::ListJobsRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::GetQueryResultsResponse>
  GetQueryResults(google::cloud::rest_internal::RestContext& rest_context,
                  Options const& options,
                  google::cloud::bigquery::v2::GetQueryResultsRequest const&
                      request) override;

  StatusOr<google::cloud::bigquery::v2::QueryResponse> Query(
      google::cloud::rest_internal::RestContext& rest_context,
      Options const& options,
      google::cloud::bigquery::v2::PostQueryRequest const& request) override;

 private:
  std::shared_ptr<rest_internal::RestClient> service_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_JOB_REST_STUB_H
