_prefix=/usr
_libdir=/usr/lib
_bindir=/usr/bin

case `uname -m` in
	"x86_64")
		_machine_type="MACHINETYPE=x86_64"
		_cflags="CFLAGS=-m64 -march=x86-64"
		if [ -d "/etc/yum.repos.d" ]; then
			_libdir=/usr/lib64
		fi
	;;

	"i686")
		_machine_type="MACHINETYPE=i686"
		_cflags="CFLAGS=-m32 -march=i686"
	;;

	"aarch64"|"mips64")
		if [ -d "/etc/yum.repos.d" ]; then
			_libdir=/usr/lib64
		fi
	;;

	"aarch64"|"mips64"|"loongarch64")
		if [ -d "/etc/yum.repos.d" ]; then
			_libdir=/usr/lib64
		fi
	;;
esac

cd cpca
./autogen.sh "${_machine_type}" "${_cflags}" --prefix="${_prefix}" --libdir="${_libdir}"  --enable-progpath="${_bindir}"
make

cd ../cngplp
./autogen.sh "${_machine_type}" "${_cflags}" --prefix="${_prefix}" --libdir="${_libdir}"

cd files
./autogen.sh "${_machine_type}" "${_cflags}"
cd ..

cd ../pdftocpca
./autogen.sh "${_machine_type}" "${_cflags}" --libdir="${_libdir}"
cd ..

make

