/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * T>Dot Fold

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_dot_fold.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDotFoldIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL t;
	REAL4 n;

	if (!fractal->transformCommon.functionEnabledFalse)
	{
		t = fractal->transformCommon.cosA;
		n = (REAL4){t * fractal->transformCommon.sinB, fractal->transformCommon.sinA,
			t * fractal->transformCommon.cosB, 0.0f};
		n += fractal->transformCommon.offset000;
	}
	else
	{
		n = fractal->transformCommon.offset000;
	}
	t = length(n);
	if (t == 0.0f) t = 1e-21f;
	n /= t;

	if (fractal->transformCommon.functionEnabledAxFalse) z.x = fabs(z.x);
	if (fractal->transformCommon.functionEnabledAyFalse) z.y = fabs(z.y);
	if (fractal->transformCommon.functionEnabledAzFalse) z.z = fabs(z.z);
	t = dot(z, n);

	z = (z - (2.0f * max(t, 0.0f) * n));

	// scale
	z *= fractal->transformCommon.scale1;
	aux->DE = aux->DE * fractal->transformCommon.scale1 + fractal->analyticDE.offset0;

	z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
	return z;
}