## lab fork

Fork a remote repository on GitLab and add as remote

### Synopsis

Fork a remote repository on user's location of choice.
Both an already existent remote or a repository path can be specified.

```
lab fork [remote],[project name or ID] [flags]
```

### Examples

```
lab fork origin
lab fork coolGroup/coolProject
lab fork 1234567
lab fork upstream --remote-name origin
lab fork origin --name new-awesome-project
lab fork origin -g TheCoolestGroup -n InitialProject
lab fork origin -p 'the_dot_git_path'
lab fork origin -n 'new_fork' -r 'new_fork_remote'
lab fork origin -s
```

### Options

```
  -g, --group string         fork project in a different group (namespace)
  -h, --help                 help for fork
      --http                 fork using HTTP protocol instead of SSH
  -n, --name string          fork project with a different name
      --no-wait              don't wait for forking operation to finish
  -p, --path string          fork project with a different path
  -r, --remote-name string   use a custom remote name for the fork
  -s, --skip-clone           skip clone after remote fork
```

### Options inherited from parent commands

```
      --debug      Enable debug logging level
      --no-pager   Do not pipe output into a pager
      --quiet      Turn off any sort of logging. Only command output is printed
```

### SEE ALSO

* [lab](index.md)	 - lab: A GitLab Command Line Interface Utility

###### Auto generated by spf13/cobra on 27-Jun-2022
