#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <regex.h>

#include "qmrtg-utils.h"


int main(int argc, char *argv[]) {
    char line[MAX_LOGLINE_LEN];
    regex_t myre_in;
    regex_t myre_out;
    int ret;
    unsigned int countin = 0, countout = 0;


    /* checking the command line */
    if (argc < 2 || argc > 3) {
        fprintf(stderr, "Usage: qmrtg-regex reg_ex_in [reg_ex_out]\n");
        exit(1);
    }
    
    /* now expecting:
     *  - argv[1] to be a RE describing inbounds
     *  - possibly argv[2] to be a RE describing outbounds
     */

    /* compiling inbound RE */
    ret = regcomp(&myre_in, argv[1], REG_EXTENDED);
    if (ret != 0) {
        regerror(ret, &myre_in, line, MAX_LOGLINE_LEN); 
        fprintf(stderr, "Error parsing RE \" %s \": %s\n", argv[1], line);
        exit(2);
    }

    if (argc == 3) {    
        /* both inbound & outbound REs specified */
        
        /* also compiling the outbound RE */
        ret = regcomp(&myre_out, argv[2], REG_EXTENDED);
        if (ret != 0) {
            regerror(ret, &myre_out, line, MAX_LOGLINE_LEN); 
            fprintf(stderr, "Error parsing RE \" %s \": %s\n", argv[2], line);
            exit(2);
        }
        
        /* now REs ok */
    
        while ( fgets(line, MAX_LOGLINE_LEN, stdin) != NULL ) {
            /* does the _in re match? */
            ret = regexec(&myre_in, line, 0, NULL, 0);
            if (ret == 0) ++countin;
                
            /* does the _out? */
            ret = regexec(&myre_out, line, 0, NULL, 0);
            if (ret == 0) ++countout;
        }    
        regfree(&myre_in);
        regfree(&myre_out);
    } else {
        /* just "inbound" RE has been specified */
    
        while ( fgets(line, MAX_LOGLINE_LEN, stdin) != NULL ) {
            /* does the _in re match? */
            ret = regexec(&myre_in, line, 0, NULL, 0);
            if (ret == 0) ++countin;
        }
        regfree(&myre_in);
    }    
    
    printf("%u\n%u\n", countin, countout);
    
    
    return 0;
}
