/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_lo = "Láò";
        final String metaValue_ml = "Málàyálámù";
        final String metaValue_syr = "Èdè Siriaki";
        final Object[][] data = new Object[][] {
            { "001", "Agbáyé" },
            { "002", "Áfíríkà" },
            { "003", "Àríwá Amẹ́ríkà" },
            { "005", "Gúúṣù Amẹ́ríkà" },
            { "009", "Òsọ́ọ́níà" },
            { "011", "Ìwọ̀ oorùn Afíríkà" },
            { "013", "Ààrin Gbùgbùn Àmẹ́ríkà" },
            { "014", "Ìlà Oorùn Áfíríkà" },
            { "015", "Àríwá Afíríkà" },
            { "017", "Ààrín gbùngbùn Afíríkà" },
            { "018", "Apágúúsù Áfíríkà" },
            { "019", "Amẹ́ríkà" },
            { "021", "Apáàríwá Amẹ́ríkà" },
            { "029", "Káríbíànù" },
            { "030", "Ìlà Òòrùn Eṣíà" },
            { "034", "Gúúṣù Eṣíà" },
            { "035", "Gúúṣù ìlà òòrùn Éṣíà" },
            { "039", "Gúúṣù Yúróòpù" },
            { "053", "Ọṣirélaṣíà" },
            { "054", "Mẹlanéṣíà" },
            { "057", "Agbègbè Maikironéṣíà" },
            { "061", "Polineṣíà" },
            { "142", "Áṣíà" },
            { "143", "Ààrin Gbùngbùn Éṣíà" },
            { "145", "Ìwọ̀ Òòrùn Eṣíà" },
            { "150", "Yúróòpù" },
            { "151", "Ìlà Òrùn Yúrópù" },
            { "154", "Àríwá Yúróòpù" },
            { "155", "Ìwọ̀ Òòrùn Yúrópù" },
            { "202", "Apá Sàhárà Áfíríkà" },
            { "419", "Látín Amẹ́ríkà" },
            { "AC", "Erékùsù Ascension" },
            { "AD", "Ààndórà" },
            { "AE", "Ẹmirate ti Awọn Arabu" },
            { "AF", "Àfùgànístánì" },
            { "AG", "Ààntígúà àti Báríbúdà" },
            { "AI", "Ààngúlílà" },
            { "AL", "Àlùbàníánì" },
            { "AM", "Améníà" },
            { "AO", "Ààngólà" },
            { "AQ", "Antakítíkà" },
            { "AR", "Agentínà" },
            { "AS", "Sámóánì ti Orílẹ́ède Àméríkà" },
            { "AT", "Asítíríà" },
            { "AU", "Austrálíà" },
            { "AW", "Árúbà" },
            { "AX", "Àwọn Erékùsù ti Aland" },
            { "AZ", "Asẹ́bájánì" },
            { "BA", "Bọ̀síníà àti Ẹtisẹgófínà" },
            { "BB", "Bábádósì" },
            { "BD", "Bángáládésì" },
            { "BE", "Bégíọ́mù" },
            { "BF", "Bùùkíná Fasò" },
            { "BG", "Bùùgáríà" },
            { "BH", "Báránì" },
            { "BI", "Bùùrúndì" },
            { "BJ", "Bẹ̀nẹ̀" },
            { "BL", "Ìlú Bátílẹ́mì" },
            { "BM", "Bémúdà" },
            { "BN", "Búrúnẹ́lì" },
            { "BO", "Bọ̀lífíyà" },
            { "BQ", "Kàríbíánì ti Nẹ́dálándì" },
            { "BR", "Bàràsílì" },
            { "BS", "Bàhámásì" },
            { "BT", "Bútánì" },
            { "BV", "Erékùsù Bouvet" },
            { "BW", "Bọ̀tìsúwánà" },
            { "BY", "Bélárúsì" },
            { "BZ", "Bèlísẹ̀" },
            { "CA", "Kánádà" },
            { "CC", "Erékùsù Cocos (Keeling)" },
            { "CD", "Kóńgò – Kinshasa" },
            { "CF", "Àrin gùngun Áfíríkà" },
            { "CG", "Kóńgò – Brazaville" },
            { "CH", "Súwísìlanìdì" },
            { "CI", "Kóútè forà" },
            { "CK", "Etíokun Kùúkù" },
            { "CL", "Ṣílè" },
            { "CM", "Kamerúúnì" },
            { "CN", "Ṣáínà" },
            { "CO", "Kòlómíbìa" },
            { "CP", "Erékùsù Clipperston" },
            { "CQ", "Sáàkì" },
            { "CR", "Kuusita Ríkà" },
            { "CU", "Kúbà" },
            { "CV", "Etíokun Kápé féndè" },
            { "CW", "Curaçao" },
            { "CX", "Erékùsù Christmas" },
            { "CY", "Kúrúsì" },
            { "CZ", "Ṣẹ́ẹ́kì" },
            { "DE", "Jámánì" },
            { "DG", "Diego Gaṣia" },
            { "DJ", "Díbọ́ótì" },
            { "DK", "Dẹ́mákì" },
            { "DM", "Dòmíníkà" },
            { "DO", "Dòmíníkánì" },
            { "DZ", "Àlùgèríánì" },
            { "EA", "Seuta àti Melilla" },
            { "EC", "Ekuádò" },
            { "EE", "Esitonia" },
            { "EG", "Égípítì" },
            { "EH", "Ìwọ̀òòrùn Sàhárà" },
            { "ER", "Eritira" },
            { "ES", "Sípéìnì" },
            { "ET", "Etopia" },
            { "EU", "Àpapọ̀ Yúróòpù" },
            { "EZ", "Agbègbè Yúrò" },
            { "FI", "Filandi" },
            { "FJ", "Fíjì" },
            { "FK", "Etikun Fakalandi" },
            { "FM", "Makoronesia" },
            { "FO", "Àwọn Erékùsù ti Faroe" },
            { "FR", "Faranse" },
            { "GA", "Gabon" },
            { "GB", "Gẹ̀ẹ́sì" },
            { "GD", "Genada" },
            { "GE", "Gọgia" },
            { "GF", "Firenṣi Guana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibaratara" },
            { "GL", "Gerelandi" },
            { "GM", "Gambia" },
            { "GN", "Gene" },
            { "GP", "Gadelope" },
            { "GQ", "Ekutoria Gini" },
            { "GR", "Gíríìsì" },
            { "GS", "Gúúsù Georgia àti Gúúsù Àwọn Erékùsù Sandwich" },
            { "GT", "Guatemálà" },
            { "GU", "Guamu" },
            { "GW", "Gene-Busau" },
            { "GY", "Guyana" },
            { "HK", "Agbègbè Ìṣàkóso Ìṣúná Hong Kong Tí Ṣánà Ń Darí" },
            { "HM", "Erékùsù Heard àti Erékùsù McDonald" },
            { "HN", "Hondurasi" },
            { "HR", "Kòróátíà" },
            { "HT", "Haati" },
            { "HU", "Hungari" },
            { "IC", "Ẹrékùsù Kánárì" },
            { "ID", "Indonéṣíà" },
            { "IE", "Ailandi" },
            { "IL", "Iserẹli" },
            { "IM", "Erékùṣù ilẹ̀ Man" },
            { "IN", "Íńdíà" },
            { "IO", "Etíkun Índíánì ti Ìlú Bírítísì" },
            { "IQ", "Iraki" },
            { "IR", "Irani" },
            { "IS", "Aṣilandi" },
            { "IT", "Itáli" },
            { "JE", "Jẹsì" },
            { "JM", "Jamaika" },
            { "JO", "Jọdani" },
            { "JP", "Japani" },
            { "KE", "Kenya" },
            { "KG", "Kuriṣisitani" },
            { "KH", "Kàmùbódíà" },
            { "KI", "Kiribati" },
            { "KM", "Kòmòrósì" },
            { "KN", "Kiiti ati Neefi" },
            { "KP", "Guusu Kọria" },
            { "KR", "Ariwa Kọria" },
            { "KW", "Kuweti" },
            { "KY", "Etíokun Kámánì" },
            { "KZ", "Kaṣaṣatani" },
            { "LA", "Laosi" },
            { "LB", "Lebanoni" },
            { "LC", "Luṣia" },
            { "LI", "Lẹṣitẹnisiteni" },
            { "LK", "Siri Lanka" },
            { "LR", "Laberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituania" },
            { "LU", "Lusemogi" },
            { "LV", "Latifia" },
            { "LY", "Libiya" },
            { "MA", "Moroko" },
            { "MC", "Monako" },
            { "MD", "Modofia" },
            { "ME", "Montenégrò" },
            { "MF", "Ìlú Màtìnì" },
            { "MG", "Madasika" },
            { "MH", "Etikun Máṣali" },
            { "MK", "Àríwá Macedonia" },
            { "ML", "Mali" },
            { "MM", "Manamari" },
            { "MN", "Mogolia" },
            { "MO", "Agbègbè Ìṣàkóso Pàtàkì Macao" },
            { "MP", "Etikun Guusu Mariana" },
            { "MQ", "Matinikuwi" },
            { "MR", "Maritania" },
            { "MS", "Motserati" },
            { "MT", "Malata" },
            { "MU", "Maritiusi" },
            { "MV", "Maladifi" },
            { "MW", "Malawi" },
            { "MX", "Mesiko" },
            { "MY", "Malasia" },
            { "MZ", "Moṣamibiku" },
            { "NA", "Namibia" },
            { "NC", "Kaledonia Titun" },
            { "NE", "Nàìjá" },
            { "NF", "Erékùsù Nọ́úfókì" },
            { "NG", "Nàìjíríà" },
            { "NI", "Nikaragua" },
            { "NL", "Nedalandi" },
            { "NO", "Nọọwii" },
            { "NP", "Nepa" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Ṣilandi Titun" },
            { "OM", "Ọọma" },
            { "PA", "Paramá" },
            { "PE", "Pèérù" },
            { "PF", "Firenṣi Polinesia" },
            { "PG", "Paapu ti Giini" },
            { "PH", "Filipini" },
            { "PK", "Pakisitan" },
            { "PL", "Polandi" },
            { "PM", "Pẹẹri ati mikuloni" },
            { "PN", "Pikarini" },
            { "PR", "Pọto Riko" },
            { "PS", "Agbègbè ara Palẹsítínì" },
            { "PT", "Pọ́túgà" },
            { "PW", "Paalu" },
            { "PY", "Paraguye" },
            { "QA", "Kota" },
            { "QO", "Agbègbè Òṣọ́ọ́níà" },
            { "RE", "Riuniyan" },
            { "RO", "Romaniya" },
            { "RS", "Sẹ́bíà" },
            { "RU", "Rọṣia" },
            { "RW", "Ruwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Etikun Solomoni" },
            { "SC", "Ṣeṣẹlẹsi" },
            { "SD", "Sudani" },
            { "SE", "Swidini" },
            { "SG", "Singapo" },
            { "SH", "Hẹlena" },
            { "SI", "Silofania" },
            { "SJ", "Sífábáàdì àti Jánì Máyẹ̀nì" },
            { "SK", "Silofakia" },
            { "SL", "Siria looni" },
            { "SM", "Sani Marino" },
            { "SN", "Sẹnẹga" },
            { "SO", "Sòmálíà" },
            { "SR", "Surinami" },
            { "SS", "Gúúsù Sudan" },
            { "ST", "Sao tomi ati piriiṣipi" },
            { "SV", "Ẹẹsáfádò" },
            { "SX", "Síntì Mátẹ́ẹ̀nì" },
            { "SY", "Siria" },
            { "SZ", "Saṣiland" },
            { "TA", "Tristan da Kunha" },
            { "TC", "Tọọki ati Etikun Kakọsi" },
            { "TD", "Ṣààdì" },
            { "TF", "Agbègbè Gúúsù Faranṣé" },
            { "TG", "Togo" },
            { "TH", "Tailandi" },
            { "TJ", "Takisitani" },
            { "TK", "Tokelau" },
            { "TL", "Tímọ̀ Lẹsiti" },
            { "TM", "Tọ́kìmẹ́nísítànì" },
            { "TN", "Tuniṣia" },
            { "TO", "Tonga" },
            { "TR", "Tọọki" },
            { "TT", "Tirinida ati Tobaga" },
            { "TV", "Tufalu" },
            { "TW", "Taiwani" },
            { "TZ", "Tàǹsáníà" },
            { "UA", "Ukarini" },
            { "UG", "Uganda" },
            { "UM", "Àwọn Erékùsù Kékèké Agbègbè US" },
            { "UN", "Ìṣọ̀kan àgbáyé" },
            { "US", "Amẹrikà" },
            { "UY", "Úrúgúwè" },
            { "UZ", "Nṣibẹkisitani" },
            { "VA", "Ìlú Vatican" },
            { "VC", "Fisẹnnti ati Genadina" },
            { "VE", "Fẹnẹṣuẹla" },
            { "VG", "Etíkun Fágínì ti ìlú Bírítísì" },
            { "VI", "Etikun Fagini ti Amẹrika" },
            { "VN", "Fẹtinami" },
            { "VU", "Faniatu" },
            { "WF", "Wali ati futuna" },
            { "WS", "Samọ" },
            { "XA", "ìsọ̀rọ̀sí irọ́" },
            { "XB", "Agbègbè irọ́" },
            { "XK", "Kòsófò" },
            { "YE", "Yemeni" },
            { "YT", "Mayote" },
            { "ZA", "Gúúṣù Áfíríkà" },
            { "ZM", "Ṣamibia" },
            { "ZW", "Ṣimibabe" },
            { "ZZ", "Àgbègbè àìmọ̀" },
            { "ab", "Èdè Abasia" },
            { "af", "Èdè Afrikani" },
            { "ak", "Èdè Akani" },
            { "am", "Èdè Amariki" },
            { "an", "Èdè Aragoni" },
            { "ar", "Èdè Lárúbáwá" },
            { "as", "Èdè Assam" },
            { "av", "Èdè Afariki" },
            { "ay", "Èdè Amara" },
            { "az", "Èdè Asabaijani" },
            { "ba", "Èdè Bashiri" },
            { "be", "Èdè Belarusi" },
            { "bg", "Èdè Bugaria" },
            { "bi", "Èdè Bisilama" },
            { "bm", "Èdè Báḿbàrà" },
            { "bn", "Èdè Bengali" },
            { "bo", "Tibetán" },
            { "br", "Èdè Bretoni" },
            { "bs", "Èdè Bosnia" },
            { "ca", "Èdè Katala" },
            { "ce", "Èdè Chechen" },
            { "ch", "Èdè S̩amoro" },
            { "co", "Èdè Corsican" },
            { "cs", "Èdè Seeki" },
            { "cu", "Èdè Síláfííkì Ilé Ìjọ́sìn" },
            { "cv", "Èdè Ṣufasi" },
            { "cy", "Èdè Welshi" },
            { "da", "Èdè Denmaki" },
            { "de", "Èdè Jámánì" },
            { "dv", "Èdè Difehi" },
            { "dz", "Èdè Dzongkha" },
            { "ee", "Èdè Ewè" },
            { "el", "Èdè Giriki" },
            { "en", "Èdè Gẹ̀ẹ́sì" },
            { "eo", "Èdè Esperanto" },
            { "es", "Èdè Sípáníìṣì" },
            { "et", "Èdè Estonia" },
            { "eu", "Èdè Baski" },
            { "fa", "Èdè Pasia" },
            { "ff", "Èdè Fúlàní" },
            { "fi", "Èdè Finisi" },
            { "fj", "Èdè Fiji" },
            { "fo", "Èdè Faroesi" },
            { "fr", "Èdè Faransé" },
            { "fy", "Èdè Frisia" },
            { "ga", "Èdè Ireland" },
            { "gd", "Èdè Gaelik ti Ilu Scotland" },
            { "gl", "Èdè Galicia" },
            { "gn", "Èdè Guarani" },
            { "gu", "Èdè Gujarati" },
            { "gv", "Máǹkì" },
            { "ha", "Èdè Hausa" },
            { "he", "Èdè Heberu" },
            { "hi", "Èdè Híńdì" },
            { "hr", "Èdè Kroatia" },
            { "ht", "Haitian Creole" },
            { "hu", "Èdè Hungaria" },
            { "hy", "Èdè Armenia" },
            { "hz", "Èdè Herero" },
            { "ia", "Èdè pipo" },
            { "id", "Èdè Indonéṣíà" },
            { "ie", "Èdè àtọwọ́dá" },
            { "ig", "Èdè Yíbò" },
            { "ii", "Ṣíkuán Yì" },
            { "io", "Èdè Ido" },
            { "is", "Èdè Icelandic" },
            { "it", "Èdè Ítálì" },
            { "iu", "Èdè Inukitu" },
            { "ja", "Èdè Jàpáànù" },
            { "jv", "Èdè Javanasi" },
            { "ka", "Èdè Georgia" },
            { "ki", "Kíkúyù" },
            { "kj", "Èdè Kuayama" },
            { "kk", "Kaṣakì" },
            { "kl", "Kalaalísùtì" },
            { "km", "Èdè kameri" },
            { "kn", "Èdè Kannada" },
            { "ko", "Èdè Kòríà" },
            { "kr", "Èdè Kanuri" },
            { "ks", "Kaṣímirì" },
            { "ku", "Èdè Kùmáǹjì" },
            { "kv", "Èdè Komi" },
            { "kw", "Èdè Kọ́nììṣì" },
            { "ky", "Kírígíìsì" },
            { "la", "Èdè Latini" },
            { "lb", "Lùṣẹ́mbọ́ọ̀gì" },
            { "lg", "Ganda" },
            { "li", "Èdè Limbogishi" },
            { "ln", "Lìǹgálà" },
            { "lo", metaValue_lo },
            { "lt", "Èdè Lithuania" },
            { "lu", "Lúbà-Katanga" },
            { "lv", "Èdè látífíànì" },
            { "mg", "Malagasì" },
            { "mh", "Èdè Mashali" },
            { "mi", "Màórì" },
            { "mk", "Èdè Masidonia" },
            { "ml", metaValue_ml },
            { "mn", "Mòngólíà" },
            { "mr", "Èdè marathi" },
            { "ms", "Èdè Malaya" },
            { "mt", "Èdè Malta" },
            { "my", "Èdè Bumiisi" },
            { "na", "Èdè Nauru" },
            { "nb", "Nọ́ọ́wè Bokímàl" },
            { "nd", "Àríwá Ndebele" },
            { "ne", "Èdè Nepali" },
            { "ng", "Èdè Ndonga" },
            { "nl", "Èdè Dọ́ọ̀ṣì" },
            { "nn", "Nọ́ọ́wè Nínọ̀sìkì" },
            { "no", "Èdè Norway" },
            { "nr", "Èdè Gusu Ndebele" },
            { "nv", "Èdè Nafajo" },
            { "ny", "Ńyájà" },
            { "oc", "Èdè Ọ̀kísítáànì" },
            { "om", "Òròmọ́" },
            { "or", "Èdè Òdíà" },
            { "os", "Ọṣẹ́tíìkì" },
            { "pa", "Èdè Punjabi" },
            { "pl", "Èdè Póláǹdì" },
            { "ps", "Páshítò" },
            { "pt", "Èdè Pọtogí" },
            { "qu", "Kúẹ́ńjùà" },
            { "rm", "Rómáǹṣì" },
            { "rn", "Rúńdì" },
            { "ro", "Èdè Romania" },
            { "ru", "Èdè Rọ́ṣíà" },
            { "rw", "Èdè Ruwanda" },
            { "sa", "Èdè awon ara Indo" },
            { "sc", "Èdè Sadini" },
            { "sd", "Èdè Sindhi" },
            { "se", "Apáàríwá Sami" },
            { "sg", "Sango" },
            { "sh", "Èdè Serbo-Croatiani" },
            { "si", "Èdè Sinhalese" },
            { "sk", "Èdè Slovaki" },
            { "sl", "Èdè Slovenia" },
            { "sm", "Sámóánù" },
            { "sn", "Ṣọnà" },
            { "so", "Èdè ara Somalia" },
            { "sq", "Èdè Albania" },
            { "sr", "Èdè Serbia" },
            { "ss", "Èdè Suwati" },
            { "st", "Èdè Sesoto" },
            { "su", "Èdè Sudanísì" },
            { "sv", "Èdè Suwidiisi" },
            { "sw", "Èdè Swahili" },
            { "ta", "Èdè Tamili" },
            { "te", "Èdè Telugu" },
            { "tg", "Èdè Tàjíìkì" },
            { "th", "Èdè Tai" },
            { "ti", "Èdè Tigrinya" },
            { "tk", "Èdè Turkmen" },
            { "tn", "Èdè Suwana" },
            { "to", "Tóńgàn" },
            { "tr", "Èdè Tọọkisi" },
            { "ts", "Èdè Songa" },
            { "tt", "Tátárì" },
            { "ty", "Èdè Tahiti" },
            { "ug", "Yúgọ̀" },
            { "uk", "Èdè Ukania" },
            { "ur", "Èdè Udu" },
            { "uz", "Èdè Uzbek" },
            { "ve", "Èdè Fenda" },
            { "vi", "Èdè Jetinamu" },
            { "vo", "Fọ́lápùùkù" },
            { "wa", "Èdè Waluni" },
            { "wo", "Wọ́lọ́ọ̀fù" },
            { "xh", "Èdè Xhosa" },
            { "yi", "Èdè Yiddishi" },
            { "yo", "Èdè Yorùbá" },
            { "za", "Ṣúwáànù" },
            { "zh", "Edè Ṣáínà" },
            { "zu", "Èdè Ṣulu" },
            { "ace", "Èdè Akinisi" },
            { "ada", "Èdè Adame" },
            { "ady", "Èdè Adiji" },
            { "agq", "Èdè Ágẹ̀ẹ̀mù" },
            { "ain", "Èdè Ainu" },
            { "ale", "Èdè Aleti" },
            { "alt", "Èdè Gusu Ata" },
            { "ann", "Èdè Obolo" },
            { "anp", "Èdè Angika" },
            { "arn", "Èdè Mapushe" },
            { "arp", "Èdè Arapaho" },
            { "ars", "Èdè Arabiki ti Najidi" },
            { "asa", "Èdè Asu" },
            { "ast", "Èdè Asturian" },
            { "atj", "Èdè Atikameki" },
            { "awa", "Èdè Awadi" },
            { "bal", "Èdè Belúṣì" },
            { "ban", "Èdè Balini" },
            { "bas", "Èdè Basaa" },
            { "bem", "Èdè Béḿbà" },
            { "bez", "Èdè Bẹ́nà" },
            { "bgc", "Èdè Haryanvi" },
            { "bho", "Èdè Bojuri" },
            { "bin", "Èdè Bini" },
            { "bla", "Èdè Sikiska" },
            { "blo", "Anii" },
            { "brx", "Èdè Bódò" },
            { "bug", "Èdè Bugini" },
            { "byn", "Èdè Bilini" },
            { "cay", "Èdè Kayuga" },
            { "ccp", "Èdè Chakma" },
            { "ceb", "Èdè Sebuano" },
            { "cgg", "Èdè Chiga" },
            { "chk", "Èdè Shuki" },
            { "chm", "Èdè Mari" },
            { "cho", "Èdè Shokita" },
            { "chp", "Èdè Shipewa" },
            { "chr", "Èdè Ṣẹ́rókiì" },
            { "chy", "Èdè Sheyeni" },
            { "ckb", "Ààrin Gbùngbùn Kurdish" },
            { "clc", "Èdè Shikoti" },
            { "crg", "Èdè Misifu" },
            { "crj", "Èdè Gusu Ila-oorun Kri" },
            { "crk", "Èdè Papa Kri" },
            { "crl", "Èdè ti Ila oorun Ariwa Kri" },
            { "crm", "Èdè Moose Kri" },
            { "crr", "Èdè Alonkuia ti Karolina" },
            { "csw", "Èdè Swampi Kri" },
            { "dak", "Èdè Dakota" },
            { "dar", "Èdè Dagiwa" },
            { "dav", "Táítà" },
            { "dgr", "Èdè Dogribu" },
            { "dje", "Ṣárúmà" },
            { "doi", "Èdè Dogiri" },
            { "dsb", "Ṣóbíánù Apá Ìṣàlẹ̀" },
            { "dua", "Èdè Duala" },
            { "dyo", "Jola-Fonyi" },
            { "dzg", "Èdè Dasaga" },
            { "ebu", "Èdè Ẹmbù" },
            { "efi", "Èdè Efiki" },
            { "eka", "Èdè Ekaju" },
            { "ewo", "Èdè Èwóǹdò" },
            { "fil", "Èdè Filipino" },
            { "fon", "Èdè Fon" },
            { "frc", "Èdè Faranse ti Kajun" },
            { "frr", "Èdè Ariwa Frisa" },
            { "fur", "Firiúlíànì" },
            { "gaa", "Èdè Gaa" },
            { "gez", "Ede Gẹ́sì" },
            { "gil", "Èdè Gibaati" },
            { "gor", "Èdè Gorontalo" },
            { "gsw", "Súwísì ti Jámánì" },
            { "guz", "Gusii" },
            { "gwi", "Èdè giwisi" },
            { "hai", "Èdè Haida" },
            { "haw", "Hawaiian" },
            { "hax", "Èdè Gusu Haida" },
            { "hil", "Èdè Hilgayo" },
            { "hmn", "Hmong" },
            { "hsb", "Sorbian Apá Òkè" },
            { "hup", "Èdè Hupa" },
            { "hur", "Èdè Hakomelemi" },
            { "iba", "Èdè Iba" },
            { "ibb", "Èdè Ibibio" },
            { "ikt", "Èdè Iwoorun Inutitu ti Kanada" },
            { "ilo", "Èdè Iloko" },
            { "inh", "Èdè Ingusi" },
            { "jbo", "Èdè Lobani" },
            { "jgo", "Ńgòmbà" },
            { "jmc", "Máṣámè" },
            { "kab", "Kabilè" },
            { "kac", "Èdè Kashini" },
            { "kaj", "Èdè Ju" },
            { "kam", "Káńbà" },
            { "kbd", "Èdè Kabadia" },
            { "kcg", "Èdè Tiyapu" },
            { "kde", "Mákondé" },
            { "kea", "Kabufadíánù" },
            { "kfo", "Èdè Koro" },
            { "kgp", "Èdè Kaigani" },
            { "kha", "Èdè Kasi" },
            { "khq", "Koira Ṣíínì" },
            { "kkj", "Kàkó" },
            { "kln", "Kálẹnjín" },
            { "kmb", "Èdè Kimbundu" },
            { "kok", "Kónkánì" },
            { "kpe", "Èdè Pele" },
            { "krc", "Èdè Karasha-Baka" },
            { "krl", "Èdè Karelia" },
            { "kru", "Èdè Kuruki" },
            { "ksb", "Ṣáńbálà" },
            { "ksf", "Èdè Báfíà" },
            { "ksh", "Èdè Colognian" },
            { "kum", "Èdè Kumiki" },
            { "kwk", "Èdè Kwawala" },
            { "kxv", "Kufi" },
            { "lad", "Èdè Ladino" },
            { "lag", "Láńgì" },
            { "lez", "Èdè Lesgina" },
            { "lij", "Liguriani" },
            { "lil", "Èdè Liloeti" },
            { "lkt", "Lákota" },
            { "lmo", "Lombardi" },
            { "lou", "Èdè Kreoli ti Louisiana" },
            { "loz", "Èdè Lozi" },
            { "lrc", "Apáàríwá Lúrì" },
            { "lsm", "Èdè Samia" },
            { "lua", "Èdè Luba Lulua" },
            { "lun", "Èdè Lunda" },
            { "lus", "Èdè Miso" },
            { "luy", "Luyíà" },
            { "mad", "Èdè Maduri" },
            { "mag", "Èdè Magahi" },
            { "mai", "Èdè Matihi" },
            { "mak", "Èdè Makasa" },
            { "mas", "Másáì" },
            { "mdf", "Èdè Mokisa" },
            { "men", "Èdè Mende" },
            { "mer", "Mérù" },
            { "mfe", "Morisiyen" },
            { "mgh", "Makhuwa-Meeto" },
            { "mgo", "Métà" },
            { "mic", "Èdè Mikmaki" },
            { "min", "Èdè Minakabau" },
            { "mni", "Èdè Manipuri" },
            { "moe", "Èdè Inuamu" },
            { "moh", "Èdè Mohaki" },
            { "mos", "Èdè Mosi" },
            { "mua", "Múndàngì" },
            { "mul", "Ọlọ́pọ̀ èdè" },
            { "mus", "Èdè Muskogi" },
            { "mwl", "Èdè Mirandisi" },
            { "myv", "Èdè Esiya" },
            { "mzn", "Masanderani" },
            { "nap", "Èdè Neapolita" },
            { "naq", "Námà" },
            { "nds", "Jámánì ìpìlẹ̀" },
            { "new", "Èdè Newari" },
            { "nia", "Èdè Nia" },
            { "niu", "Èdè Niu" },
            { "nmg", "Kíwáṣíò" },
            { "nnh", "Ngiembùnù" },
            { "nog", "Èdè Nogai" },
            { "nqo", "Èdè Nko" },
            { "nso", "Èdè Ariwa Soto" },
            { "nus", "Núẹ̀" },
            { "nyn", "Ńyákọ́lè" },
            { "ojb", "Èdè Ariwa-iwoorun Ojibwa" },
            { "ojc", "Èdè Ojibwa Aarin" },
            { "ojs", "Èdè Oji Kri" },
            { "ojw", "Èdè Iwoorun Ojibwa" },
            { "oka", "Èdè Okanaga" },
            { "pag", "Èdè Pangasina" },
            { "pam", "Èdè Pampanga" },
            { "pap", "Èdè Papiamento" },
            { "pau", "Èdè Pala" },
            { "pcm", "Èdè Pijini ti Naijiriya" },
            { "pis", "Èdè Piji" },
            { "pqm", "Èdè Maliseti-Pasamkodi" },
            { "prg", "Púrúṣíànù" },
            { "raj", "Rajastánì" },
            { "rap", "Èdè Rapanu" },
            { "rar", "Èdè Rarotonga" },
            { "rhg", "Èdè Rohinga" },
            { "rof", "Róńbò" },
            { "rup", "Èdè Aromani" },
            { "rwk", "Riwa" },
            { "sad", "Èdè Sandawe" },
            { "sah", "Sàkíhà" },
            { "saq", "Samburu" },
            { "sat", "Èdè Santali" },
            { "sba", "Èdè Ngambayi" },
            { "sbp", "Sangu" },
            { "scn", "Èdè Sikila" },
            { "sco", "Èdè Sikoti" },
            { "seh", "Ṣẹnà" },
            { "ses", "Koiraboro Seni" },
            { "shi", "Taṣelíìtì" },
            { "shn", "Èdè Shani" },
            { "slh", "Èdè Gusu Lushootseed" },
            { "smn", "Inari Sami" },
            { "sms", "Èdè Sikoti Smi" },
            { "snk", "Èdè Sonike" },
            { "srn", "Èdè Sirana Tongo" },
            { "str", "Èdè Sitirati Salisi" },
            { "suk", "Èdè Sukuma" },
            { "swb", "Èdè Komora" },
            { "syr", metaValue_syr },
            { "szl", "Silìṣíànì" },
            { "tce", "Èdè Gusu Tushoni" },
            { "tem", "Èdè Timne" },
            { "teo", "Tẹ́sò" },
            { "tet", "Èdè Tetum" },
            { "tgx", "Èdè Tagisi" },
            { "tht", "Èdè Tajiti" },
            { "tig", "Èdè Tigre" },
            { "tlh", "Èdè Klingoni" },
            { "tli", "Èdè Tlingiti" },
            { "tok", "Èdè Toki Pona" },
            { "tpi", "Èdè Tok Pisini" },
            { "trv", "Èdè Taroko" },
            { "ttm", "Èdè Ariwa Tusoni" },
            { "tum", "Èdè Tumbuka" },
            { "tvl", "Èdè Tifalu" },
            { "twq", "Tasawak" },
            { "tyv", "Èdè Tuvini" },
            { "tzm", "Ààrin Gbùngbùn Atlas Tamazight" },
            { "udm", "Èdè Udmuti" },
            { "umb", "Èdè Umbundu" },
            { "und", "Èdè àìmọ̀" },
            { "vec", "Fènéṣìànì" },
            { "vmw", "Màkúwà" },
            { "vun", "Funjo" },
            { "wae", "Wọsà" },
            { "wal", "Èdè Wolata" },
            { "war", "Èdè Wara" },
            { "wuu", "Èdè Wu ti Saina" },
            { "xal", "Èdè Kalimi" },
            { "xnr", "Kangiri" },
            { "xog", "Ṣógà" },
            { "yav", "Yangbẹn" },
            { "ybb", "Èdè Yemba" },
            { "yrl", "Èdè Ningatu" },
            { "yue", "Èdè Kantonese" },
            { "zgh", "Àfẹnùkò Támásáìtì ti Mòrókò" },
            { "zun", "Èdè Suni" },
            { "zxx", "Kò sí àkóònú elédè" },
            { "zza", "Èdè Sasa" },
            { "Adlm", "Èdè Adam" },
            { "Arab", "èdè Lárúbáwá" },
            { "Aran", "Èdè Aran" },
            { "Armn", "Àmẹ́níà" },
            { "Bamu", "Bamumu" },
            { "Batk", "Bataki" },
            { "Beng", "Báńgílà" },
            { "Bopo", "Bopomófò" },
            { "Brai", "Bíráìlè" },
            { "Cakm", "Kami" },
            { "Cans", "Èdè Apapo Onile Onisilebu ti Kanada" },
            { "Cher", "Èdè Sheroki" },
            { "Cyrl", "èdè ilẹ̀ Rọ́ṣíà" },
            { "Deva", "Dẹfanagárì" },
            { "Ethi", "Ẹtiópíìkì" },
            { "Geor", "Jọ́jíànù" },
            { "Gong", "Gunjala Gondi" },
            { "Grek", "Gíríkì" },
            { "Gujr", "Gujaráti" },
            { "Guru", "Gurumúkhì" },
            { "Hanb", "Han pẹ̀lú Bopomófò" },
            { "Hang", "Háńgùlù" },
            { "Hani", "Háànù" },
            { "Hans", "tí wọ́n mú rọrùn." },
            { "Hant", "Àbáláyé" },
            { "Hebr", "Hébérù" },
            { "Hira", "Hiragánà" },
            { "Hmnp", "Nyiakengi Puase Himongi" },
            { "Hrkt", "ìlànà àfọwọ́kọ ará Jàpánù" },
            { "Java", "Èdè Jafaniisi" },
            { "Jpan", "èdè jàpáànù" },
            { "Kali", "Èdè Kaya Li" },
            { "Kana", "Katakánà" },
            { "Khmr", "Kẹmẹ̀" },
            { "Knda", "Kanada" },
            { "Kore", "Kóríà" },
            { "Lana", "Èdè Lana" },
            { "Laoo", metaValue_lo },
            { "Latn", "Èdè Látìn" },
            { "Lepc", "Èdè Lepika" },
            { "Limb", "Èdè Limbu" },
            { "Lisu", "Furasa" },
            { "Mand", "Èdè Mandaiani" },
            { "Mlym", metaValue_ml },
            { "Mong", "Èdè Mòngólíà" },
            { "Mtei", "Èdè Meitei Mayeki" },
            { "Mymr", "Myánmarà" },
            { "Newa", "Èdè Newa" },
            { "Nkoo", "Èdè Nkoo" },
            { "Olck", "Èdè Ol Siki" },
            { "Orya", "Òdíà" },
            { "Osge", "Èdè Osage" },
            { "Plrd", "Fonẹtiiki Polaadi" },
            { "Rohg", "Èdè Hanifi" },
            { "Saur", "Èdè Saurasitira" },
            { "Sinh", "Sìnhálà" },
            { "Sund", "Èdè Sundani" },
            { "Syrc", metaValue_syr },
            { "Taml", "Támílì" },
            { "Telu", "Télúgù" },
            { "Tfng", "Èdè Tifina" },
            { "Thaa", "Taana" },
            { "Tibt", "Tíbétán" },
            { "Vaii", "Èdè Fai" },
            { "Yiii", "Èdè Yi" },
            { "Zinh", "Tí a jogún" },
            { "Zmth", "Àmì Ìṣèsìrò" },
            { "Zsye", "Émójì" },
            { "Zsym", "Àwọn àmì" },
            { "Zxxx", "Aikọsilẹ" },
            { "Zyyy", "Wọ́pọ̀" },
            { "Zzzz", "Ìṣọwọ́kọ̀wé àìmọ̀" },
            { "de_AT", "Èdè Jámánì (Ọ́síríà )" },
            { "de_CH", "Èdè Ilẹ̀ Jámánì (Orílẹ́ède swítsàlandì)" },
            { "en_AU", "Èdè Gẹ̀ẹ́sì (órílẹ̀-èdè Ọsirélíà)" },
            { "en_CA", "Èdè Gẹ̀ẹ́sì (Orílẹ̀-èdè Kánádà)" },
            { "en_GB", "Èdè òyìnbó Gẹ̀ẹ́sì" },
            { "es_ES", "Èdè Sípáníìṣì (orílẹ̀-èdè Yúróòpù)" },
            { "es_MX", "Èdè Sípáníìṣì (orílẹ̀-èdè Mẹ́síkò)" },
            { "fr_CA", "Èdè Faransé (orílẹ̀-èdè Kánádà)" },
            { "fr_CH", "Èdè Faranṣé (Súwísàlaǹdì)" },
            { "nl_BE", "Èdè Flemiṣi" },
            { "pt_BR", "Èdè Pọtogí (Orilẹ̀-èdè Bràsíl)" },
            { "pt_PT", "Èdè Pọtogí (orílẹ̀-èdè Yúróòpù)" },
            { "es_419", "Èdè Sípáníìṣì (orílẹ̀-èdè Látìn-Amẹ́ríkà)" },
            { "key.ca", "Kàlẹ́ńdà" },
            { "key.cf", "Ònà Ìgbekalẹ̀ owó" },
            { "key.co", "Ètò Ẹlẹ́sẹẹsẹ" },
            { "key.cu", "Owó" },
            { "key.em", "Ìgbékalẹ̀ Ẹ̀mójì" },
            { "key.hc", "Òbíríkiti Wákàtí (12 vs 24)" },
            { "key.lb", "Àra Ìda Ìlà" },
            { "key.lw", "Àwọn Ìdá Ìlà Láàárín Àwọn Ọ̀rọ̀" },
            { "key.ms", "Èto Ìdiwọ̀n" },
            { "key.nu", "Àwọn nọ́ńbà" },
            { "key.ss", "Ìdá Gbólóhùn Lẹ́yìn Ìgékúrú" },
            { "hi_Latn", "Èdè Híndì (Látìnì)" },
            { "zh_Hans", "Ẹdè Ṣáínà Onírọ̀rùn" },
            { "zh_Hant", "Èdè Ṣáínà Ìbílẹ̀" },
            { "type.ca.roc", "Kàlẹ́ńdà Minguo" },
            { "type.hc.h11", "Èto Wákàtí 12 (0–11)" },
            { "type.hc.h12", "Èto Wákàtí 12 (1–12)" },
            { "type.hc.h23", "Èto Wákàtí 24 (0–23)" },
            { "type.hc.h24", "Èto Wákàtí 24 (1–24)" },
            { "type.nu.arab", "àwọn díjítì Làrubáwá-Índíà" },
            { "type.nu.armn", "Àwọn nọ́ńbà Àmẹ́níà" },
            { "type.nu.beng", "Àwọn díjíìtì Báńgílà" },
            { "type.nu.cakm", "Àwọn díjíìtì Shakma" },
            { "type.nu.deva", "Àwọn díjììtì Defanagárì" },
            { "type.nu.ethi", "Àwọn nọ́ńbà Ẹtiópíìkì" },
            { "type.nu.geor", "Àwọn nọ́ńbà Jọ́jíà" },
            { "type.nu.grek", "Àwọn nọ́ńbà Gíríìkì" },
            { "type.nu.gujr", "Àwọn díjíìtì Gùjárátì" },
            { "type.nu.guru", "Àwọn Díjíìtì Gurumukì" },
            { "type.nu.hans", "Àwọn nọ́ńbà Ìrọ̀rùn ti Ṣáìnà" },
            { "type.nu.hant", "Àwọn nọ́ńbà Ìbílẹ̀ Ṣáìnà" },
            { "type.nu.hebr", "Àwọn nọ́ńbà Hébérù" },
            { "type.nu.java", "Àwọn díjíìtì Jafaniisi" },
            { "type.nu.jpan", "Àwọn nọ́ńbà Jápànù" },
            { "type.nu.khmr", "Àwọn díjíìtì Kẹ́mẹ̀" },
            { "type.nu.knda", "Àwọn díjíìtì kanada" },
            { "type.nu.laoo", "Àwọn díjíìtì Láó" },
            { "type.nu.latn", "Díjíítì Ìwọ̀ Oòrùn" },
            { "type.nu.mlym", "Àwọn díjíìtì Málàyálámù" },
            { "type.nu.mtei", "Àwọn díjíìtì Mete Mayeki" },
            { "type.nu.mymr", "Àwọn díjíìtì Myánmarí" },
            { "type.nu.olck", "Àwọn díjíìtì Shiki" },
            { "type.nu.orya", "Àwọn díjíìtì Òdíà" },
            { "type.nu.taml", "Àwọn díjíìtì Ìbílẹ̀ Támílù" },
            { "type.nu.telu", "Àwọn díjíìtì Télúgù" },
            { "type.nu.thai", "Àwọn díjíìtì Thai" },
            { "type.nu.tibt", "Àwọn díjíìtì Tibetán" },
            { "type.nu.vaii", "Àwọn díjíìtì Fai" },
            { "type.ca.dangi", "Kàlẹ́ńdà dangi" },
            { "type.co.ducet", "Ètò Ẹlẹ́sẹẹsẹ Àkùàyàn Unicode" },
            { "type.lb.loose", "Àra Ìda Ìlà Títú" },
            { "type.nu.roman", "Àwọn díjíìtì Rómánù" },
            { "type.ca.coptic", "Èdè Kopti" },
            { "type.ca.hebrew", "Kàlẹ́ńdà Hébérù" },
            { "type.co.search", "Ìṣàwárí Ète-Gbogbogbò" },
            { "type.lb.normal", "Àra Ìda Ìlà Déédéé" },
            { "type.lb.strict", "Àra Ìda Ìlà Mímúná" },
            { "type.ms.metric", "Èto Mẹ́tíríìkì" },
            { "type.ca.chinese", "Kàlẹ́ńdà ti Ṣáìnà" },
            { "type.ca.islamic", "Kàlẹ́ńdà Lárúbáwá" },
            { "type.ca.iso8601", "Kàlẹ́ńdà ISO-8601" },
            { "type.ca.persian", "Kàlẹ́ńdà Pásíànù" },
            { "type.cf.account", "Ìgúnrégé Ìṣirò Owó Kọ́rẹ́ńsì" },
            { "type.nu.arabext", "Àwọn Díjíìtì Lárúbáwá-Índíà fífẹ̀" },
            { "type.nu.armnlow", "Àwọn Nọ́ńbà Kékèké ti Amẹ́ríkà" },
            { "type.nu.greklow", "Àwọn Nọ́ńbà Gíríìkì Kékèké" },
            { "type.nu.hanidec", "Àwọn nọ́ńbà Dẹ́símà Ṣáìnà" },
            { "type.nu.hansfin", "Àwọn nọ́ńbà Ìṣúná Ìrọ̀rùn Ṣáìnà" },
            { "type.nu.hantfin", "Àwọn nọ́ńbà Ìṣúná Ìbílẹ̀ Ṣáìnà" },
            { "type.nu.jpanfin", "Àwọn nọ́ńbà Ìṣúná Jàpáànù" },
            { "type.nu.tamldec", "Àwọn díjíìtì Tàmílù" },
            { "type.ca.buddhist", "Kàlẹ́ńdà Buddhist" },
            { "type.ca.ethiopic", "Kàlẹ́ńdà Ẹtíópíìkì" },
            { "type.ca.japanese", "Kàlẹ́ńdà ti Jàpánù" },
            { "type.cf.standard", "Ònà ìgbekalẹ̀ owó tó jẹ́ àjùmọ̀lò" },
            { "type.co.standard", "Ìlànà Onírúurú Ètò" },
            { "type.ms.uksystem", "Èto Ìdiwọ̀n Ọba" },
            { "type.ms.ussystem", "Èto Ìdiwọ̀n US" },
            { "type.nu.fullwide", "Àwọn Díjíìtì Fífẹ̀-Ẹ̀kún" },
            { "type.nu.romanlow", "Àwọn díjíìtì Rómánù Kékeré" },
            { "type.ca.gregorian", "Kàlẹ́ńdà Gregory" },
            { "type.ca.islamic-civil", "Kàlẹ́ńdà ti Musulumi" },
            { "type.ca.islamic-umalqura", "Kàlẹ́ńdà Musulumi" },
            { "type.ca.ethiopic-amete-alem", "Èdè Kalenda Alem Amete tio Etiopia" },
        };
        return data;
    }
}
