/*******************************************************************************
* File:   		wepclient.c
* Date:   		2004-05-21
* Author: 		Fernando Tarín
* Last Modified:	2004-5-23
*
* Description: Client mode
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU Library General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*******************************************************************************/

#include <sys/socket.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>

#ifndef __CYGWIN__
#include <resolv.h>
#endif

#include <errno.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <strings.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>

#include "messages.h"
#include "wepserver.h"
#include "md5_digest.h"

#define MAXBUF 150

char path[30];
char file_name[25];

void parse_client_file(char * packet_file){
	int i,j=0,cont=0;
	
	for(i=0;i<strlen(packet_file);i++)
		if (packet_file[i] == '/') cont++;
	i=0;
	if (cont !=0){
		while (j < cont){
			path[i] = packet_file[i];
			if (packet_file[i] == '/') j++;
			i++;
		}
		path[i]='\0'; j=0;
	}
	else strncpy(path,"./",2);
	for(;i<strlen(packet_file);i++){
		file_name[j] = packet_file[i];
		j++;
	}
	file_name[j]='\0';		
}

int server_connection(unsigned char * server_host, int port, char * packet_file, unsigned char * init_key, unsigned char * end_key, unsigned char * decrypted_key, unsigned char * bssid, unsigned char * mode ,int option){
	int sd, read_bytes, write_bytes, i, fd;
	char file[11]="local.dump";
	unsigned char buffer[149], digest[16];
	struct sockaddr_in dest;
	struct in_addr *host_ip;
	struct hostent *host;
	struct protoent *pr;
	struct client_data c_data;
	struct sent_data s_data;
		
	for(i=0;i<100;i++)
		buffer[i] = '\0';

	// Fill client data struct
	c_data.option = option;

	if (c_data.option == GET_KEYS || c_data.option == DECRYPTED_KEYS || c_data.option == DECRYPTED_BLOCK){
#ifndef __CYGWIN__
		parse_client_file(packet_file);		
		if (!make_md5_digest(path, file_name, digest)){
#else
		if (!make_md5_digest(NULL, packet_file, digest)){
#endif
			
			fprintf(stdout, "Client Error: Error making md5 digest\n");
			return 0;
		}
		copy_md5_digest(c_data.digest, digest);
	}
	
	if (c_data.option == DECRYPTED_KEYS){
		for(i=0;i<13;i++){
			c_data.decrypted_key[i] = decrypted_key[i];
			if (i<6) c_data.decrypted_bssid[i] = bssid[i];
		}
	}
		
	// Get protocol
	pr = getprotobyname("tcp");
	if (pr == NULL){
		fprintf(stdout, "Tcp is unknonwn in your system\n");
		return 0;
	}
	
	// Open socket	
	if ((sd = socket(PF_INET,SOCK_STREAM,pr->p_proto)) < 0){
		perror("Error opening the socket");
		return 0;
	}
	
	// Clean sockaddr_in struct
	bzero(&dest, sizeof(dest));
	
	// Fill sockaddr_in struct
	dest.sin_family = AF_INET;
	dest.sin_port = htons(port);	
	if ((dest.sin_addr.s_addr = inet_addr(server_host)) != -1);		
	else {
		if ((host = gethostbyname(server_host)) == NULL){
			fprintf(stdout, "Unknown host: %s\n", server_host);
			close(sd);
			return 0;
		}
		host_ip = (struct in_addr *) host->h_addr_list;		
		dest.sin_addr.s_addr=inet_addr(inet_ntoa(*host_ip));
	}
	
	// Connecting with server
	if(connect(sd, (struct sockaddr *)&dest, sizeof(dest)) < 0){
		fprintf(stdout, "Server Error: Connection error");
		close(sd);
		return 0;		
	}
	
	write_bytes = send(sd,(unsigned char *) & c_data,sizeof(c_data),0);	
	
	if (c_data.option == GET_FILE){
		if ((fd=open(file,O_CREAT | O_RDWR | O_TRUNC, 00600 )) == -1){
			fprintf(stdout, "Error openning local file\n");
			close(sd);
			return 0;
		}
		while ((read_bytes = recv(sd,buffer,MAXBUF,0)) > 0){
			write(fd,buffer, read_bytes);			
		}
		close(fd);
		close(sd);
		return 1;
	}	
	
	read_bytes = recv(sd,buffer,MAXBUF,0);
	
	memcpy(&s_data,buffer,sizeof(sent_data));
	
	// Close socket
	close(sd);	
	
	if (read_bytes < 0){
		fprintf(stdout,"Server error: No data received from server\n");		
		return 0;
	}

	else{
		if (s_data.message == HASHES_DOESNT_MATCH){
			fprintf(stdout, "Server error: Hashes doesn't match\n");
			return 0;
		}
		else if (s_data.message == ALL_OK){
			if ((s_data.mode == 64) && (option == GET_KEYS)){				
				(*mode) = 0x00;
				for (i=0;i<5;i++){				
					init_key[i] = s_data.init_key[i];
					end_key[i] = s_data.end_key[i];
				}
				return 1;
			}
			else if ((s_data.mode == 128) && (option == GET_KEYS)){
				(*mode) = 0x02;
				for (i=0;i<13;i++){
					init_key[i] = s_data.init_key[i];
					end_key[i] = s_data.end_key[i];
				}				
				return 1;
			}
		}
		else if (s_data.message == NO_MORE_BLOCKS){
			fprintf(stdout, "Server error: No more blocks to decrypt\n");			
			return 0;
		}
	}

	return 1;
}
