/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Load;

public class UnencumberedmoveLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "UNENCUMBEREDMOVE";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        boolean hasArmor = false;
        boolean hasMove = false;
        Load loadMove = null;
        Load loadArmor = null;
        while (tok.hasMoreTokens()) {
            ParseResult pr;
            String loadString = tok.nextToken();
            if (loadString.equalsIgnoreCase("MediumLoad")) {
                pr = this.validateOnlyMove(hasMove);
                if (!pr.passed()) {
                    return pr;
                }
                loadMove = Load.MEDIUM;
                hasMove = true;
                continue;
            }
            if (loadString.equalsIgnoreCase("HeavyLoad")) {
                pr = this.validateOnlyMove(hasMove);
                if (!pr.passed()) {
                    return pr;
                }
                loadMove = Load.HEAVY;
                hasMove = true;
                continue;
            }
            if (loadString.equalsIgnoreCase("Overload")) {
                pr = this.validateOnlyMove(hasMove);
                if (!pr.passed()) {
                    return pr;
                }
                loadMove = Load.OVERLOAD;
                hasMove = true;
                continue;
            }
            if (loadString.equalsIgnoreCase("MediumArmor")) {
                pr = this.validateOnlyArmor(hasArmor);
                if (!pr.passed()) {
                    return pr;
                }
                loadArmor = Load.MEDIUM;
                hasArmor = true;
                continue;
            }
            if (loadString.equalsIgnoreCase("HeavyArmor")) {
                pr = this.validateOnlyArmor(hasArmor);
                if (!pr.passed()) {
                    return pr;
                }
                loadArmor = Load.OVERLOAD;
                hasArmor = true;
                continue;
            }
            if (loadString.equalsIgnoreCase("LightLoad")) {
                pr = this.validateOnlyMove(hasMove);
                if (!pr.passed()) {
                    return pr;
                }
                loadMove = Load.LIGHT;
                hasMove = true;
                continue;
            }
            if (loadString.equalsIgnoreCase("LightArmor")) {
                pr = this.validateOnlyMove(hasArmor);
                if (!pr.passed()) {
                    return pr;
                }
                loadArmor = Load.LIGHT;
                hasArmor = true;
                continue;
            }
            return new ParseResult.Fail("Invalid value of \"" + loadString + "\" for UNENCUMBEREDMOVE in \"" + obj.getDisplayName() + "\".", context);
        }
        context.getObjectContext().put(obj, ObjectKey.UNENCUMBERED_LOAD, loadMove);
        context.getObjectContext().put(obj, ObjectKey.UNENCUMBERED_ARMOR, loadArmor);
        return ParseResult.SUCCESS;
    }

    private ParseResult validateOnlyArmor(boolean hasArmor) {
        if (hasArmor) {
            return new ParseResult.Fail("Encountered Second Armor Load Type in " + this.getTokenName() + " this is not valid.");
        }
        return ParseResult.SUCCESS;
    }

    private ParseResult validateOnlyMove(boolean hasMove) {
        if (hasMove) {
            return new ParseResult.Fail("Encountered Second Move Load Type in " + this.getTokenName() + " this is not valid.");
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Load load = (Load)context.getObjectContext().getObject(obj, ObjectKey.UNENCUMBERED_LOAD);
        Load at = (Load)context.getObjectContext().getObject(obj, ObjectKey.UNENCUMBERED_ARMOR);
        if (load == null && at == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (load != null) {
            if (Load.OVERLOAD.equals((Object)load)) {
                sb.append("Overload");
            } else if (Load.HEAVY.equals((Object)load)) {
                sb.append("HeavyLoad");
            } else if (Load.MEDIUM.equals((Object)load)) {
                sb.append("MediumLoad");
            } else if (Load.LIGHT.equals((Object)load)) {
                sb.append("LightLoad");
            } else {
                context.addWriteMessage(this.getTokenName() + " encountered unknown Movement Load: " + load);
                return null;
            }
        }
        if (at != null) {
            if (sb.length() != 0) {
                sb.append("|");
            }
            if (Load.OVERLOAD.equals((Object)at)) {
                sb.append("HeavyArmor");
            } else if (Load.MEDIUM.equals((Object)at)) {
                sb.append("MediumArmor");
            } else if (Load.LIGHT.equals((Object)at)) {
                sb.append("LightArmor");
            } else {
                context.addWriteMessage(this.getTokenName() + " encountered invalid Armor Load: " + load);
                return null;
            }
        }
        return new String[]{sb.toString()};
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

