/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreKitTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    private static final Class<Kit> KIT_CLASS = Kit.class;

    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int number;
        int runningTotal = 0;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException exceptn) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString((String)"PreKit.error", (Object[])new Object[]{prereq.toString()}));
        }
        String kitKey = prereq.getKey().toUpperCase();
        int wildCard = kitKey.indexOf(37);
        if (wildCard >= 0) {
            kitKey = kitKey.substring(0, wildCard);
            for (Kit kit : display.getKitInfo()) {
                if (!kit.getKeyName().toUpperCase().startsWith(kitKey)) continue;
                ++runningTotal;
            }
        } else {
            Kit kit = (Kit)Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(KIT_CLASS, kitKey);
            if (display.hasKit(kit)) {
                ++runningTotal;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "KIT";
    }
}

