/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreHDTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int runningTotal;
        try {
            int targetHD = Integer.parseInt(prereq.getOperand());
            runningTotal = prereq.getOperator().compare(display.totalHitDice(), targetHD);
        }
        catch (NumberFormatException nfe) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString("PreHD.error.bad_operand", prereq.getOperand()));
        }
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "HD";
    }

    @Override
    public String toHtmlString(Prerequisite prereq) {
        String foo = LanguageBundle.getFormattedString("PreStat.toHtml", prereq.getKind().toUpperCase() + ":", prereq.getOperator().toDisplayString(), prereq.getOperand());
        return foo;
    }
}

