/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.PCClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class LevelsperfeatToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    @Override
    public String getTokenName() {
        return "LEVELSPERFEAT";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        String numLevels;
        int pipeLoc = value.indexOf(124);
        if (pipeLoc == -1) {
            numLevels = value;
            context.getObjectContext().put((CDOMObject)pcc, StringKey.LEVEL_TYPE, null);
        } else {
            if (pipeLoc != value.lastIndexOf(124)) {
                return new ParseResult.Fail(this.getTokenName() + " must be of the form: " + this.getTokenName() + ":<int> or " + this.getTokenName() + ":<int>|LEVELTYPE=<string>" + " Got " + this.getTokenName() + ":" + value, context);
            }
            numLevels = value.substring(0, pipeLoc);
            String levelTypeTag = value.substring(pipeLoc + 1);
            if (!levelTypeTag.startsWith("LEVELTYPE=")) {
                return new ParseResult.Fail("If " + this.getTokenName() + " has a | it must be of the form: " + this.getTokenName() + ":<int>|LEVELTYPE=<string>" + " Got " + this.getTokenName() + ":" + value, context);
            }
            String levelType = levelTypeTag.substring(10);
            if (levelType == null || levelType.length() == 0) {
                return new ParseResult.Fail("If " + this.getTokenName() + " has a | it must be of the form: " + this.getTokenName() + ":<int>|LEVELTYPE=<string>" + " Got an empty leveltype", context);
            }
            context.getObjectContext().put((CDOMObject)pcc, StringKey.LEVEL_TYPE, levelType);
        }
        try {
            Integer in = Integer.valueOf(numLevels);
            if (in < 0) {
                return new ParseResult.Fail(this.getTokenName() + " must be an integer >= 0", context);
            }
            context.getObjectContext().put((CDOMObject)pcc, IntegerKey.LEVELS_PER_FEAT, in);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int> or " + this.getTokenName() + ":<int>|LEVELTYPE=<string>", context);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClass pcc) {
        Integer lpf = context.getObjectContext().getInteger(pcc, IntegerKey.LEVELS_PER_FEAT);
        String levelType = context.getObjectContext().getString(pcc, StringKey.LEVEL_TYPE);
        if (lpf == null) {
            if (levelType != null) {
                context.addWriteMessage(this.getTokenName() + " found level type, but no levels per feat value");
            }
            return null;
        }
        if (lpf < 0) {
            context.addWriteMessage(this.getTokenName() + " must be an integer >= 0");
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append(lpf);
        if (levelType != null && levelType.length() > 0) {
            result.append("|LEVELTYPE=");
            result.append(levelType);
        }
        return new String[]{result.toString()};
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

