/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.util.TokenFamily;

public class TokenFamilySubIterator<C>
implements Iterator<CDOMSecondaryToken<? super C>> {
    private static final Class<Object> OBJECT_CLASS = Object.class;
    private CDOMSecondaryToken<? super C> nextToken = null;
    private boolean needNewToken = true;
    private Class<? super C> actingClass;
    private final String parentToken;
    private Iterator<CDOMSecondaryToken<? super C>> subIterator;
    private final Set<String> used = new HashSet<String>();

    public TokenFamilySubIterator(Class<C> cl, String parentName) {
        this.actingClass = cl;
        this.parentToken = parentName;
        this.subIterator = TokenFamily.CURRENT.getSubTokens(cl, this.parentToken).iterator();
    }

    @Override
    public CDOMSecondaryToken<? super C> next() {
        this.setNext();
        if (this.nextToken == null) {
            throw new NoSuchElementException();
        }
        this.needNewToken = true;
        return this.nextToken;
    }

    private void setNext() {
        if (this.needNewToken) {
            this.nextToken = this.getNext();
            if (this.nextToken != null) {
                String tokenName = this.nextToken.getTokenName();
                if (this.used.contains(tokenName)) {
                    this.needNewToken = true;
                    this.setNext();
                } else {
                    this.used.add(this.nextToken.getTokenName());
                }
            }
        }
    }

    private CDOMSecondaryToken<? super C> getNext() {
        this.needNewToken = false;
        if (this.subIterator.hasNext()) {
            CDOMSecondaryToken<? super C> tok = this.subIterator.next();
            return tok;
        }
        if (OBJECT_CLASS.equals(this.actingClass)) {
            return null;
        }
        this.actingClass = this.actingClass.getSuperclass();
        Set<CDOMSecondaryToken<C>> st = TokenFamily.CURRENT.getSubTokens(this.actingClass, this.parentToken);
        this.subIterator = st.iterator();
        return this.getNext();
    }

    @Override
    public boolean hasNext() {
        this.setNext();
        return this.nextToken != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator does not support remove");
    }
}

