/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.StringTokenizer;
import pcgen.base.lang.UnreachableError;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.GameMode;
import pcgen.core.QualifiedObject;
import pcgen.core.character.WieldCategory;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class WieldCategoryLoader {
    private final PreParserFactory prereqParser;

    public WieldCategoryLoader() {
        try {
            this.prereqParser = PreParserFactory.getInstance();
        }
        catch (PersistenceLayerException ple) {
            Logging.errorPrint("Error Initializing PreParserFactory");
            Logging.errorPrint("  " + ple.getMessage(), ple);
            throw new UnreachableError();
        }
    }

    public void parseLine(GameMode gameMode, String lstLine, URI source) throws PersistenceLayerException {
        LoadContext context = gameMode.getModeContext();
        StringTokenizer colToken = new StringTokenizer(lstLine, "\t");
        WieldCategory cat = null;
        String preKey = null;
        CDOMSingleRef<WieldCategory> preVal = null;
        while (colToken.hasMoreTokens()) {
            String value;
            String colString = colToken.nextToken().trim();
            int idxColon = colString.indexOf(58);
            String key = "";
            try {
                key = colString.substring(0, idxColon);
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (key.equals("WIELDCATEGORY")) {
                value = colString.substring(idxColon + 1).trim();
                cat = context.getReferenceContext().silentlyGetConstructedCDOMObject(WieldCategory.class, value);
                if (cat != null) continue;
                cat = new WieldCategory();
                cat.setName(value.intern());
                gameMode.addWieldCategory(cat);
                continue;
            }
            if (colString.startsWith("PREVAR")) {
                preKey = colString;
                continue;
            }
            if (key.equals("SWITCH")) {
                preVal = context.getReferenceContext().getCDOMReference(WieldCategory.class, colString.substring(7));
                continue;
            }
            value = colString.substring(idxColon + 1).trim();
            if (context.processToken(cat, key, value)) {
                context.commit();
            } else {
                context.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
        }
        if (cat != null && preVal != null && preKey != null) {
            try {
                QualifiedObject<Object> qo = new QualifiedObject<Object>(preVal);
                qo.addPrerequisite(this.prereqParser.parse(preKey));
                cat.addCategorySwitch(qo);
            }
            catch (PersistenceLayerException ple) {
                Logging.errorPrint("Error parsing Prerequisite in " + source + ": " + preKey + "\n  " + ple.getMessage());
            }
        }
    }
}

