/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.filter;

import java.util.ArrayList;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ListFacades;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;

public class FilteredTreeViewModel<C, E>
implements TreeViewModel<E>,
ListListener<E> {
    private DefaultListFacade<E> data = new DefaultListFacade();
    private Filter<C, E> filter;
    private TreeViewModel<E> model;
    private C context;

    @Override
    public ListFacade<? extends TreeView<E>> getTreeViews() {
        return this.model.getTreeViews();
    }

    @Override
    public int getDefaultTreeViewIndex() {
        return this.model.getDefaultTreeViewIndex();
    }

    @Override
    public DataView<E> getDataView() {
        return this.model.getDataView();
    }

    @Override
    public ListFacade<E> getDataModel() {
        return this.data;
    }

    public void setBaseModel(TreeViewModel<E> model) {
        if (this.model != null) {
            this.model.getDataModel().removeListListener(this);
        }
        this.model = model;
        if (this.model != null) {
            this.model.getDataModel().addListListener(this);
            this.data.updateContents(ListFacades.wrap(model.getDataModel()));
        }
    }

    public void setContext(C context) {
        this.context = context;
        if (this.filter != null) {
            this.refilter();
        }
    }

    public void setFilter(Filter<C, E> filter) {
        this.filter = filter;
        this.filterCheck();
    }

    private void filterCheck() {
        if (this.filter != null && this.context != null) {
            this.refilter();
        }
    }

    public void refilter() {
        ListFacade<E> base = this.model.getDataModel();
        ArrayList list = new ArrayList(base.getSize());
        for (Object element : base) {
            if (this.filter != null && !this.filter.accept(this.context, element)) continue;
            list.add(element);
        }
        this.data.updateContents(list);
    }

    @Override
    public void elementAdded(ListEvent<E> e) {
        if (this.filter == null || this.filter.accept(this.context, e.getElement())) {
            this.data.addElement(e.getElement());
        }
    }

    @Override
    public void elementRemoved(ListEvent<E> e) {
        this.data.removeElement(e.getElement());
    }

    @Override
    public void elementsChanged(ListEvent<E> e) {
        this.refilter();
    }

    @Override
    public void elementModified(ListEvent<E> e) {
        if (!this.filter.accept(this.context, e.getElement())) {
            this.data.removeElement(e.getElement());
        } else {
            this.data.modifyElement(e.getElement());
        }
    }
}

