/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcgen.core.AbilityCategory;
import pcgen.core.term.FixedTermEvaluator;
import pcgen.core.term.PCACcheckTermEvaluator;
import pcgen.core.term.PCArmourACcheckTermEvaluator;
import pcgen.core.term.PCBABTermEvaluator;
import pcgen.core.term.PCBLTermEvaluator;
import pcgen.core.term.PCBaseCRTermEvaluator;
import pcgen.core.term.PCBaseHDTermEvaluator;
import pcgen.core.term.PCBaseSpellStatTermEvaluator;
import pcgen.core.term.PCBonusLangTermEvaluator;
import pcgen.core.term.PCCLBeforeLevelTermEvaluator;
import pcgen.core.term.PCCLTermEvaluator;
import pcgen.core.term.PCCarriedWeightTermEvaluator;
import pcgen.core.term.PCCastTimesAtWillTermEvaluator;
import pcgen.core.term.PCCasterLevelClassTermEvaluator;
import pcgen.core.term.PCCasterLevelRaceTermEvaluator;
import pcgen.core.term.PCCasterLevelTotalTermEvaluator;
import pcgen.core.term.PCCountAbilitiesNatureAllTermEvaluator;
import pcgen.core.term.PCCountAbilitiesNatureAutoTermEvaluator;
import pcgen.core.term.PCCountAbilitiesNatureNormalTermEvaluator;
import pcgen.core.term.PCCountAbilitiesNatureVirtualTermEvaluator;
import pcgen.core.term.PCCountAbilitiesTypeNatureAllTermEvaluator;
import pcgen.core.term.PCCountAbilitiesTypeNatureAutoTermEvaluator;
import pcgen.core.term.PCCountAbilitiesTypeNatureVirtualTermEvaluator;
import pcgen.core.term.PCCountAbilityNameTermEvaluator;
import pcgen.core.term.PCCountAttacksTermEvaluator;
import pcgen.core.term.PCCountChecksTermEvaluator;
import pcgen.core.term.PCCountClassesTermEvaluator;
import pcgen.core.term.PCCountContainersTermEvaluator;
import pcgen.core.term.PCCountDomainsTermEvaluator;
import pcgen.core.term.PCCountEqTypeTermEvaluator;
import pcgen.core.term.PCCountEquipmentTermEvaluator;
import pcgen.core.term.PCCountFollowerTypeTermEvaluator;
import pcgen.core.term.PCCountFollowerTypeTransitiveTermEvaluator;
import pcgen.core.term.PCCountFollowersTermEvaluator;
import pcgen.core.term.PCCountLanguagesTermEvaluator;
import pcgen.core.term.PCCountMiscCompanionsTermEvaluator;
import pcgen.core.term.PCCountMiscFundsTermEvaluator;
import pcgen.core.term.PCCountMiscMagicTermEvaluator;
import pcgen.core.term.PCCountMoveTermEvaluator;
import pcgen.core.term.PCCountNotesTermEvaluator;
import pcgen.core.term.PCCountRaceSubTypesTermEvaluator;
import pcgen.core.term.PCCountSABTermEvaluator;
import pcgen.core.term.PCCountSkillsTermEvaluator;
import pcgen.core.term.PCCountSpellClassesTermEvaluator;
import pcgen.core.term.PCCountSpellRaceTermEvaluator;
import pcgen.core.term.PCCountSpellTimesTermEvaluator;
import pcgen.core.term.PCCountSpellbookTermEvaluator;
import pcgen.core.term.PCCountSpellsInbookTermEvaluator;
import pcgen.core.term.PCCountSpellsKnownTermEvaluator;
import pcgen.core.term.PCCountSpellsLevelsInBookTermEvaluator;
import pcgen.core.term.PCCountStatsTermEvaluator;
import pcgen.core.term.PCCountTempBonusNamesTermEvaluator;
import pcgen.core.term.PCCountTemplatesTermEvaluator;
import pcgen.core.term.PCCountVisibleTemplatesTermEvaluator;
import pcgen.core.term.PCCountVisionTermEvaluator;
import pcgen.core.term.PCEncumberanceTermEvaluator;
import pcgen.core.term.PCEqTypeTermEvaluator;
import pcgen.core.term.PCFavClassLevelTermEvaluator;
import pcgen.core.term.PCHDTermEvaluator;
import pcgen.core.term.PCHPTermEvaluator;
import pcgen.core.term.PCHandsTermEvaluator;
import pcgen.core.term.PCHasClassTermEvaluator;
import pcgen.core.term.PCHasDeityTermEvaluator;
import pcgen.core.term.PCHasFeatTermEvaluator;
import pcgen.core.term.PCHeightTermEvaluator;
import pcgen.core.term.PCLegsTermEvaluator;
import pcgen.core.term.PCMaxCastableAnyTermEvaluator;
import pcgen.core.term.PCMaxCastableClassTermEvaluator;
import pcgen.core.term.PCMaxCastableDomainTermEvaluator;
import pcgen.core.term.PCMaxCastableSpellTypeTermEvaluator;
import pcgen.core.term.PCMaxLevelTermEvaluator;
import pcgen.core.term.PCModEquipTermEvaluator;
import pcgen.core.term.PCMoveBaseTermEvaluator;
import pcgen.core.term.PCMovementTermEvaluator;
import pcgen.core.term.PCProfACCheckTermEvaluator;
import pcgen.core.term.PCRaceSizeTermEvaluator;
import pcgen.core.term.PCRacialHDSizeTermEvaluator;
import pcgen.core.term.PCSPellBaseStatScoreEvaluatorTermEvaluator;
import pcgen.core.term.PCSPellBaseStatTermEvaluator;
import pcgen.core.term.PCScoreTermEvaluator;
import pcgen.core.term.PCShieldACcheckTermEvaluator;
import pcgen.core.term.PCSizeIntEQTermEvaluator;
import pcgen.core.term.PCSizeIntTermEvaluator;
import pcgen.core.term.PCSizeModEvaluatorTermEvaluator;
import pcgen.core.term.PCSizeTermEvaluator;
import pcgen.core.term.PCSkillRankTermEvaluator;
import pcgen.core.term.PCSkillTotalTermEvaluator;
import pcgen.core.term.PCSkillTypeTermEvaluator;
import pcgen.core.term.PCSpellLevelTermEvaluator;
import pcgen.core.term.PCTLTermEvaluator;
import pcgen.core.term.PCTotalWeightTermEvaluator;
import pcgen.core.term.PCVarDefinedTermEvaluator;
import pcgen.core.term.PCWeightTermEvaluator;
import pcgen.core.term.TermEvaluator;
import pcgen.core.term.TermEvaluatorBuilder;
import pcgen.core.term.TermEvaulatorException;
import pcgen.util.Logging;
import pcgen.util.TermUtilities;

public enum TermEvaluatorBuilderPCVar implements TermEvaluatorBuilder
{
    COMPLETE_PC_ACCHECK("AC{1,2}HECK", new String[]{"ACCHECK", "ACHECK"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCACcheckTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_ARMORACCHECK("ARMORAC{1,2}HECK", new String[]{"ARMORACCHECK", "ARMORACHECK"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCArmourACcheckTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_BAB("BAB", new String[]{"BAB"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCBABTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_BASECR("BASECR", new String[]{"BASECR"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCBaseCRTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_BASEHD("BASEHD", new String[]{"BASEHD"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCBaseHDTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_BASESPELLSTAT("BASESPELLSTAT", new String[]{"BASESPELLSTAT"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            String source = src.startsWith("CLASS:") ? src.substring(6) : "";
            return new PCBaseSpellStatTermEvaluator(expressionString, source);
        }
    }
    ,
    COMPLETE_PC_CASTERLEVEL("(?:CASTERLEVEL\\.TOTAL|CASTERLEVEL)", new String[]{"CASTERLEVEL", "CASTERLEVEL.TOTAL"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            if ("CASTERLEVEL".equals(matchedSection)) {
                if (src.startsWith("RACE:")) {
                    return new PCCasterLevelRaceTermEvaluator(expressionString, src.substring(5));
                }
                if (src.startsWith("CLASS:")) {
                    return new PCCasterLevelClassTermEvaluator(expressionString, src.substring(6));
                }
                return new PCCasterLevelTotalTermEvaluator(expressionString);
            }
            return new PCCasterLevelTotalTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_ATTACKS("COUNT\\[ATTACKS\\]", new String[]{"COUNT[ATTACKS]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountAttacksTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_CHECKS("COUNT\\[CHECKS\\]", new String[]{"COUNT[CHECKS]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountChecksTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_CLASSES("COUNT\\[CLASSES\\]", new String[]{"COUNT[CLASSES]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountClassesTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_CONTAINERS("COUNT\\[CONTAINERS\\]", new String[]{"COUNT[CONTAINERS]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountContainersTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_DOMAINS("COUNT\\[DOMAINS\\]", new String[]{"COUNT[DOMAINS]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountDomainsTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_FEATSNATUREALL("COUNT\\[FEATSALL(?:\\.ALL|\\.HIDDEN|\\.VISIBLE)?\\]", new String[]{"COUNT[FEATSALL]", "COUNT[FEATSALL.ALL]", "COUNT[FEATSALL.HIDDEN]", "COUNT[FEATSALL.VISIBLE]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            boolean visible = !expressionString.endsWith("HIDDEN]");
            boolean hidden = expressionString.endsWith("HIDDEN]") || expressionString.endsWith(".ALL]");
            AbilityCategory abCat = AbilityCategory.FEAT;
            return new PCCountAbilitiesNatureAllTermEvaluator(expressionString, abCat, visible, hidden);
        }
    }
    ,
    COMPLETE_PC_COUNT_FEATSNATUREAUTO("COUNT\\[FEATSAUTO(?:\\.ALL|\\.HIDDEN|\\.VISIBLE)?\\]", new String[]{"COUNT[FEATSAUTO]", "COUNT[FEATSAUTO.ALL]", "COUNT[FEATSAUTO.HIDDEN]", "COUNT[FEATSAUTO.VISIBLE]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            boolean visible = !expressionString.endsWith("HIDDEN]");
            boolean hidden = expressionString.endsWith("HIDDEN]") || expressionString.endsWith("ALL]");
            AbilityCategory abCat = AbilityCategory.FEAT;
            return new PCCountAbilitiesNatureAutoTermEvaluator(expressionString, abCat, visible, hidden);
        }
    }
    ,
    COMPLETE_PC_COUNT_FEATSNATURENORMAL("COUNT\\[FEATS(?:\\.ALL|\\.HIDDEN|\\.VISIBLE)?\\]", new String[]{"COUNT[FEATS]", "COUNT[FEATS.ALL]", "COUNT[FEATS.HIDDEN]", "COUNT[FEATS.VISIBLE]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            boolean visible = !expressionString.endsWith("HIDDEN]");
            boolean hidden = expressionString.endsWith("HIDDEN]") || expressionString.endsWith("ALL]");
            AbilityCategory abCat = AbilityCategory.FEAT;
            return new PCCountAbilitiesNatureNormalTermEvaluator(expressionString, abCat, visible, hidden);
        }
    }
    ,
    COMPLETE_PC_COUNT_FEATSNATUREVIRTUAL("COUNT\\[VFEATS(?:\\.ALL|\\.HIDDEN|\\.VISIBLE)?\\]", new String[]{"COUNT[VFEATS]", "COUNT[VFEATS.ALL]", "COUNT[VFEATS.HIDDEN]", "COUNT[VFEATS.VISIBLE]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            boolean visible = !expressionString.endsWith("HIDDEN]");
            boolean hidden = expressionString.endsWith("HIDDEN]") || expressionString.endsWith("ALL]");
            AbilityCategory abCat = AbilityCategory.FEAT;
            return new PCCountAbilitiesNatureVirtualTermEvaluator(expressionString, abCat, visible, hidden);
        }
    }
    ,
    COMPLETE_PC_COUNT_FOLLOWERS("COUNT\\[FOLLOWERS\\]", new String[]{"COUNT[FOLLOWERS]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountFollowersTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_LANGUAGES("COUNT\\[LANGUAGES\\]", new String[]{"COUNT[LANGUAGES]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountLanguagesTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_MISC_COMPANIONS("COUNT\\[MISC\\.COMPANIONS\\]", new String[]{"COUNT[MISC.COMPANIONS]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountMiscCompanionsTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_MISC_FUNDS("COUNT\\[MISC\\.FUNDS\\]", new String[]{"COUNT[MISC.FUNDS]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountMiscFundsTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_MISC_MAGIC("COUNT\\[MISC\\.MAGIC\\]", new String[]{"COUNT[MISC.MAGIC]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountMiscMagicTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_MOVE("COUNT\\[MOVE\\]", new String[]{"COUNT[MOVE]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountMoveTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_NOTES("COUNT\\[NOTES\\]", new String[]{"COUNT[NOTES]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountNotesTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_RACESUBTYPES("COUNT\\[RACESUBTYPES\\]", new String[]{"COUNT[RACESUBTYPES]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountRaceSubTypesTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_SA("COUNT\\[SA\\]", new String[]{"COUNT[SA]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountSABTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_SKILLS("COUNT\\[SKILLS(?:\\.SELECTED|\\.RANKS|\\.NONDEFAULT|\\.USABLE|\\.ALL)?\\]", new String[]{"COUNT[SKILLS]", "COUNT[SKILLS.SELECTED]", "COUNT[SKILLS.RANKS]", "COUNT[SKILLS.NONDEFAULT]", "COUNT[SKILLS.USABLE]", "COUNT[SKILLS.ALL]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            String filterToken = null;
            int start = expressionString.indexOf(46);
            if (start > 0) {
                int end = expressionString.indexOf(93, start);
                filterToken = expressionString.substring(start + 1, end);
            }
            return new PCCountSkillsTermEvaluator(expressionString, filterToken);
        }
    }
    ,
    COMPLETE_PC_COUNT_SPELLCLASSES("COUNT\\[SPELLCLASSES\\]", new String[]{"COUNT[SPELLCLASSES]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountSpellClassesTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_SPELLRACE("COUNT\\[SPELLRACE\\]", new String[]{"COUNT[SPELLRACE]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountSpellRaceTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_STATS("COUNT\\[STATS\\]", new String[]{"COUNT[STATS]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountStatsTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_TEMPBONUSNAMES("COUNT\\[TEMPBONUSNAMES\\]", new String[]{"COUNT[TEMPBONUSNAMES]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountTempBonusNamesTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_TEMPLATES("COUNT\\[TEMPLATES\\]", new String[]{"COUNT[TEMPLATES]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountTemplatesTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_VISIBLETEMPLATES("COUNT\\[VISIBLETEMPLATES\\]", new String[]{"COUNT[VISIBLETEMPLATES]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountVisibleTemplatesTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_COUNT_VISION("COUNT\\[VISION\\]", new String[]{"COUNT[VISION]"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCountVisionTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_ENCUMBERANCE("ENCUMBERANCE", new String[]{"ENCUMBERANCE"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCEncumberanceTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_HD("HD", new String[]{"HD"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCHDTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_HP("HP", new String[]{"HP"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCHPTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_MAXCASTABLE("MAXCASTABLE", new String[]{"MAXCASTABLE"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            if (src.startsWith("CLASS:")) {
                return new PCMaxCastableClassTermEvaluator(expressionString, src.substring(6));
            }
            if (src.startsWith("DOMAIN:")) {
                return new PCMaxCastableDomainTermEvaluator(expressionString, src.substring(7));
            }
            if (src.startsWith("SPELLTYPE:")) {
                return new PCMaxCastableSpellTypeTermEvaluator(expressionString, src.substring(10));
            }
            if ("ANY".equals(src)) {
                return new PCMaxCastableAnyTermEvaluator(expressionString);
            }
            StringBuilder sB = new StringBuilder();
            sB.append("MAXCASTABLE is not usable in ");
            sB.append(src);
            throw new TermEvaulatorException(sB.toString());
        }
    }
    ,
    COMPLETE_PC_MOVEBASE("MOVEBASE", new String[]{"MOVEBASE"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCMoveBaseTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_PC_HEIGHT("PC\\.HEIGHT", new String[]{"PC.HEIGHT"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCHeightTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_PC_WEIGHT("PC\\.WEIGHT", new String[]{"PC.WEIGHT"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCWeightTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_PROFACCHECK("PROFACCHECK", new String[]{"PROFACCHECK"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            String source = src.startsWith("EQ:") ? src.substring(3) : "";
            return new PCProfACCheckTermEvaluator(expressionString, source);
        }
    }
    ,
    COMPLETE_PC_RACESIZE("RACESIZE", new String[]{"RACESIZE"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCRaceSizeTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_RACIALHDSIZE("RACIALHDSIZE", new String[]{"RACIALHDSIZE"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCRacialHDSizeTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_SCORE("SCORE", new String[]{"SCORE"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            try {
                int i = Integer.parseInt(src);
                return new FixedTermEvaluator(i);
            }
            catch (NumberFormatException e) {
                String source = src.startsWith("STAT:") ? src.substring(5) : "";
                return new PCScoreTermEvaluator(expressionString, source);
            }
        }
    }
    ,
    COMPLETE_PC_SHIELDACCHECK("SHIELDAC{1,2}HECK", new String[]{"SHIELDACCHECK", "SHIELDACHECK"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCShieldACcheckTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_SIZEMOD("SIZEMOD|SIZE", new String[]{"SIZEMOD", "SIZE"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            if ("SIZEMOD".equals(matchedSection)) {
                return new PCSizeModEvaluatorTermEvaluator(expressionString);
            }
            return new PCSizeTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_SPELLBASESTAT("SPELLBASESTATSCORE|SPELLBASESTAT", new String[]{"SPELLBASESTAT", "SPELLBASESTATSCORE"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            String source;
            String string = source = src.startsWith("CLASS:") ? src.substring(6) : "";
            if (expressionString.endsWith("SCORE")) {
                return new PCSPellBaseStatScoreEvaluatorTermEvaluator(expressionString, source);
            }
            return new PCSPellBaseStatTermEvaluator(expressionString, source);
        }
    }
    ,
    COMPLETE_PC_SPELLLEVEL("SPELLLEVEL", new String[]{"SPELLLEVEL"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCSpellLevelTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_TL("TL", new String[]{"TL"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCTLTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_FAVCLASSLEVEL("FAVCLASSLEVEL", new String[]{"FAVCLASSLEVEL"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCFavClassLevelTermEvaluator(expressionString);
        }
    }
    ,
    PC_CAST_ATWILL("ATWILL", new String[]{"ATWILL"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCCastTimesAtWillTermEvaluator(expressionString);
        }
    }
    ,
    START_PC_BL("BL[.=]?", new String[]{"BL.", "BL=", "BL"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String classString = matchedSection.length() == expressionString.length() ? (src.startsWith("CLASS:") ? src.substring(6) : "") : expressionString.substring(matchedSection.length());
            return new PCBLTermEvaluator(expressionString, classString);
        }
    }
    ,
    START_PC_CL_BEFORELEVEL("CL;BEFORELEVEL[.=]", new String[]{"CL;BEFORELEVEL.", "CL;BEFORELEVEL="}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            int i;
            if (!src.startsWith("CLASS:")) {
                StringBuilder sB = new StringBuilder();
                sB.append(matchedSection);
                sB.append(" may only be used in a Class");
                throw new TermEvaulatorException(sB.toString());
            }
            try {
                i = Integer.parseInt(expressionString.substring(15));
            }
            catch (NumberFormatException e) {
                StringBuilder sB = new StringBuilder();
                sB.append("Badly formed formula ");
                sB.append(expressionString);
                sB.append(" in ");
                sB.append(src);
                sB.append(" should have an integer following ");
                sB.append(matchedSection);
                throw new TermEvaulatorException(sB.toString());
            }
            return new PCCLBeforeLevelTermEvaluator(expressionString, src.substring(6), i);
        }
    }
    ,
    START_PC_CLASSLEVEL("CLASSLEVEL[.=]", new String[]{"CLASSLEVEL.", "CLASSLEVEL="}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String exp = expressionString.replace('{', '(').replace('}', ')');
            String classString = exp.substring(11);
            return new PCCLTermEvaluator(expressionString, classString);
        }
    }
    ,
    START_PC_CLASS("CLASS[.=]", new String[]{"CLASS.", "CLASS="}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            return new PCHasClassTermEvaluator(expressionString, expressionString.substring(6));
        }
    }
    ,
    START_PC_CL("CL[.=]?", new String[]{"CL.", "CL=", "CL"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String classString;
            if (2 == expressionString.length()) {
                if (!src.startsWith("CLASS:")) {
                    StringBuilder sB = new StringBuilder();
                    sB.append(matchedSection);
                    sB.append(" may only be used in a Class");
                    throw new TermEvaulatorException(sB.toString());
                }
                classString = src.startsWith("CLASS:") ? src.substring(6) : "";
            } else {
                classString = expressionString.substring(3);
            }
            return new PCCLTermEvaluator(expressionString, classString);
        }
    }
    ,
    START_PC_COUNT_EQTYPE("COUNT\\[EQTYPE\\.?", new String[]{"COUNT[EQTYPE", "COUNT[EQTYPE."}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String[] types;
            int first;
            String typesString = TermUtilities.extractContentsOfBrackets(expressionString, src, matchedSection.length());
            String[] fullTypes = typesString.split("\\.", -1);
            int merge = "MERGENONE".equals(fullTypes[0]) ? 1 : ("MERGELOC".equals(fullTypes[0]) ? 2 : 0);
            int n = first = 0 == merge ? 0 : 1;
            if (fullTypes.length > first) {
                TermUtilities.checkEqTypeTypesArray(expressionString, fullTypes, first);
                int len = fullTypes.length - first;
                types = new String[len];
                System.arraycopy(fullTypes, first, types, 0, len);
            } else {
                types = new String[]{""};
            }
            return new PCCountEqTypeTermEvaluator(expressionString, types, merge);
        }
    }
    ,
    START_PC_COUNT_EQUIPMENT("COUNT\\[EQUIPMENT\\.?", new String[]{"COUNT[EQUIPMENT.", "COUNT[EQUIPMENT"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String[] types;
            int first;
            String typesString = TermUtilities.extractContentsOfBrackets(expressionString, src, matchedSection.length());
            String[] fullTypes = typesString.split("\\.");
            int merge = "MERGENONE".equals(fullTypes[0]) ? 1 : ("MERGELOC".equals(fullTypes[0]) ? 2 : 0);
            int n = first = 0 == merge ? 0 : 1;
            if (fullTypes.length > first) {
                TermUtilities.checkEquipmentTypesArray(expressionString, fullTypes, first);
                int len = fullTypes.length - first;
                types = new String[len];
                System.arraycopy(fullTypes, first, types, 0, len);
            } else {
                types = new String[]{""};
            }
            return new PCCountEquipmentTermEvaluator(expressionString, types, merge);
        }
    }
    ,
    START_PC_COUNT_FEATTYPE("COUNT\\[(?:FEATAUTOTYPE|FEATNAME|FEATTYPE|VFEATTYPE)[.=]", new String[]{"COUNT[FEATAUTOTYPE.", "COUNT[FEATAUTOTYPE=", "COUNT[FEATNAME.", "COUNT[FEATNAME=", "COUNT[FEATTYPE.", "COUNT[FEATTYPE=", "COUNT[VFEATTYPE.", "COUNT[VFEATTYPE="}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            boolean hidden;
            Matcher subtokenMat = subtokenPat.matcher(expressionString);
            if (!subtokenMat.find()) {
                StringBuilder sB = new StringBuilder();
                sB.append("Impossible error while parsing \"");
                sB.append(expressionString);
                sB.append("\" in ");
                sB.append(src);
                throw new TermEvaulatorException(sB.toString());
            }
            int start = expressionString.startsWith("COUNT[FEATA") ? 19 : (expressionString.startsWith("COUNT[V") ? 16 : 15);
            String typesString = TermUtilities.extractContentsOfBrackets(expressionString, src, start);
            String[] types = typesString.split("\\.", -1);
            boolean visible = !expressionString.endsWith("HIDDEN]");
            boolean bl = hidden = expressionString.endsWith("HIDDEN]") || expressionString.endsWith("ALL]");
            if ("ALL".equals(types[types.length - 1]) || "HIDDEN".equals(types[types.length - 1]) || "VISIBLE".equals(types[types.length - 1])) {
                if (types.length > 1) {
                    int len = types.length - 1;
                    String[] t = new String[len];
                    System.arraycopy(types, 0, t, 0, len);
                    types = t;
                } else {
                    types = new String[]{""};
                }
            }
            AbilityCategory abCat = AbilityCategory.FEAT;
            if ("FEATAUTOTYPE".equals(subtokenMat.group())) {
                return new PCCountAbilitiesTypeNatureAutoTermEvaluator(expressionString, abCat, types, visible, hidden);
            }
            if ("FEATNAME".equals(subtokenMat.group())) {
                return new PCCountAbilityNameTermEvaluator(expressionString, abCat, types[0], visible, hidden);
            }
            if ("FEATTYPE".equals(subtokenMat.group())) {
                return new PCCountAbilitiesTypeNatureAllTermEvaluator(expressionString, abCat, types, visible, hidden);
            }
            return new PCCountAbilitiesTypeNatureVirtualTermEvaluator(expressionString, abCat, types, visible, hidden);
        }
    }
    ,
    START_PC_COUNT_FOLLOWERTYPE("COUNT\\[FOLLOWERTYPE\\.", new String[]{"COUNT[FOLLOWERTYPE."}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String typesString = TermUtilities.extractContentsOfBrackets(expressionString, src, 19);
            String[] types = typesString.split("\\.", 3);
            if (types.length == 1) {
                return new PCCountFollowerTypeTermEvaluator(expressionString, types[0]);
            }
            if (types.length == 2) {
                StringBuilder sB = new StringBuilder();
                sB.append("Badly formed formula ");
                sB.append(expressionString);
                sB.append(" in ");
                sB.append(src);
                throw new TermEvaulatorException(sB.toString());
            }
            Matcher numMat = numPat.matcher(types[1]);
            if (!numMat.find()) {
                StringBuilder sB = new StringBuilder();
                sB.append("Badly formed formula ");
                sB.append(expressionString);
                sB.append(" in ");
                sB.append(src);
                throw new TermEvaulatorException(sB.toString());
            }
            String newCount = "COUNT[" + types[2] + "]";
            return new PCCountFollowerTypeTransitiveTermEvaluator(expressionString, types[0], Integer.valueOf(numMat.group()), newCount);
        }
    }
    ,
    START_PC_COUNT_SKILLTYPE("COUNT\\[SKILLTYPE[.=]", new String[]{"COUNT[SKILLTYPE.", "COUNT[SKILLTYPE="}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String type = TermUtilities.extractContentsOfBrackets(expressionString, src, 16);
            return new PCSkillTypeTermEvaluator(expressionString, type);
        }
    }
    ,
    START_PC_COUNT_SPELLBOOKS("COUNT\\[SPELLBOOKS", new String[]{"COUNT[SPELLBOOKS"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            TermUtilities.extractContentsOfBrackets(expressionString, src, 16);
            return new PCCountSpellbookTermEvaluator(expressionString);
        }
    }
    ,
    START_PC_COUNT_SPELLSINBOOK("COUNT\\[SPELLSINBOOK", new String[]{"COUNT[SPELLSINBOOK"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            return new PCCountSpellsInbookTermEvaluator(expressionString, TermUtilities.extractContentsOfBrackets(expressionString, src, 19));
        }
    }
    ,
    START_PC_COUNT_SPELLSKNOWN("COUNT\\[SPELLSKNOWN", new String[]{"COUNT[SPELLSKNOWN"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String spellsString = TermUtilities.extractContentsOfBrackets(expressionString, src, 17);
            int[] nums = new int[]{-1};
            if (spellsString.length() > 1 && spellsString.startsWith(".")) {
                String s = spellsString.substring(1);
                try {
                    nums = TermUtilities.convertToIntegers(expressionString, s, matchedSection.length(), 2);
                }
                catch (NumberFormatException e) {
                    nums[0] = -1;
                }
            }
            return new PCCountSpellsKnownTermEvaluator(expressionString, nums);
        }
    }
    ,
    START_PC_COUNT_SPELLSLEVELSINBOOK("COUNT\\[SPELLSLEVELSINBOOK", new String[]{"COUNT[SPELLSLEVELSINBOOK"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String intString = TermUtilities.extractContentsOfBrackets(expressionString, src, 24);
            int[] nums = new int[]{-1};
            if (intString.length() > 1 && intString.startsWith(".")) {
                String s = intString.substring(1);
                try {
                    nums = TermUtilities.convertToIntegers(expressionString, s, matchedSection.length(), 2);
                }
                catch (NumberFormatException e) {
                    nums[0] = -1;
                }
            } else {
                StringBuilder sB = new StringBuilder();
                sB.append("Badly formed formula ");
                sB.append(expressionString);
                sB.append(" following ");
                sB.append(matchedSection);
                sB.append(" should be 2 ");
                sB.append("integers separated by dots");
                throw new TermEvaulatorException(sB.toString());
            }
            return new PCCountSpellsLevelsInBookTermEvaluator(expressionString, nums);
        }
    }
    ,
    START_PC_COUNT_SPELLTIMES("COUNT\\[SPELLTIMES", new String[]{"COUNT[SPELLTIMES"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String intString = TermUtilities.extractContentsOfBrackets(expressionString, src, 16);
            int[] nums = new int[]{-1};
            if (intString.length() > 1 && intString.startsWith(".")) {
                String s = intString.substring(1);
                try {
                    nums = TermUtilities.convertToIntegers(expressionString, s, matchedSection.length(), 4);
                }
                catch (NumberFormatException e) {
                    nums[0] = -1;
                }
            } else {
                StringBuilder sB = new StringBuilder();
                sB.append("Badly formed formula ");
                sB.append(expressionString);
                sB.append(" following ");
                sB.append(matchedSection);
                sB.append(" should be 4 ");
                sB.append("integers separated by dots");
                throw new TermEvaulatorException(sB.toString());
            }
            return new PCCountSpellTimesTermEvaluator(expressionString, nums);
        }
    }
    ,
    START_PC_EQTYPE("EQTYPE", new String[]{"EQTYPE"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            return new PCEqTypeTermEvaluator(expressionString);
        }
    }
    ,
    START_PC_HASDEITY("HASDEITY:", new String[]{"HASDEITY:"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            return new PCHasDeityTermEvaluator(expressionString, expressionString.substring(9));
        }
    }
    ,
    START_PC_HASFEAT("HASFEAT:", new String[]{"HASFEAT:"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            return new PCHasFeatTermEvaluator(expressionString, expressionString.substring(8));
        }
    }
    ,
    START_PC_MAXLEVEL("MAXLEVEL", new String[]{"MAXLEVEL"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            if (src.startsWith("CLASS:") || src.startsWith("CLASS|")) {
                return new PCMaxLevelTermEvaluator(expressionString, src.substring(6));
            }
            Logging.errorPrint("MAXLEVEL term called without a CLASS source");
            return new PCMaxLevelTermEvaluator(expressionString, "");
        }
    }
    ,
    START_PC_MODEQUIP("MODEQUIP", new String[]{"MODEQUIP"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            return new PCModEquipTermEvaluator(expressionString, expressionString.substring(8));
        }
    }
    ,
    START_PC_MOVE("MOVE\\[", new String[]{"MOVE["}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            return new PCMovementTermEvaluator(expressionString, TermUtilities.extractContentsOfBrackets(expressionString, src, 5));
        }
    }
    ,
    START_PC_PC_SIZE("PC\\.SIZE(?:\\.INT)?", new String[]{"PC.SIZE.INT", "PC.SIZE"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            if (matchedSection.length() == 11) {
                if (src.startsWith("EQ:")) {
                    return new PCSizeIntEQTermEvaluator(expressionString, src.substring(3));
                }
                return new PCSizeIntTermEvaluator(expressionString);
            }
            return new PCSizeTermEvaluator(expressionString);
        }
    }
    ,
    START_PC_SKILLRANK("SKILLRANK[.=]", new String[]{"SKILLRANK.", "SKILLRANK="}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String skillString = expressionString.substring(10).replace('{', '(').replace('}', ')');
            return new PCSkillRankTermEvaluator(expressionString, skillString);
        }
    }
    ,
    START_PC_SKILLTOTAL("SKILLTOTAL[.=]", new String[]{"SKILLTOTAL.", "SKILLTOTAL="}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String skillString = expressionString.substring(11).replace('{', '(').replace('}', ')');
            return new PCSkillTotalTermEvaluator(expressionString, skillString);
        }
    }
    ,
    START_PC_VARDEFINED("VARDEFINED:", new String[]{"VARDEFINED:"}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String varString = expressionString.substring(11);
            return new PCVarDefinedTermEvaluator(expressionString, varString);
        }
    }
    ,
    START_PC_WEIGHT("WEIGHT\\.", new String[]{"WEIGHT."}, false){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) throws TermEvaulatorException {
            String valString = expressionString.substring(7);
            if ("CARRIED".equals(valString)) {
                return new PCCarriedWeightTermEvaluator(expressionString);
            }
            if ("EQUIPPED".equals(valString)) {
                return new PCCarriedWeightTermEvaluator(expressionString);
            }
            if ("PC".equals(valString)) {
                return new PCWeightTermEvaluator(expressionString);
            }
            if ("TOTAL".equals(valString)) {
                return new PCTotalWeightTermEvaluator(expressionString);
            }
            StringBuilder sB = new StringBuilder();
            sB.append("invalid string following WEIGHT. in ");
            sB.append(expressionString);
            throw new TermEvaulatorException(sB.toString());
        }
    }
    ,
    COMPLETE_PC_BONUSLANG("BONUSLANG", new String[]{"BONUSLANG"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCBonusLangTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_HANDS("HANDS", new String[]{"HANDS"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCHandsTermEvaluator(expressionString);
        }
    }
    ,
    COMPLETE_PC_LEGS("LEGS", new String[]{"LEGS"}, true){

        @Override
        public TermEvaluator getTermEvaluator(String expressionString, String src, String matchedSection) {
            return new PCLegsTermEvaluator(expressionString);
        }
    };

    static String subtokenString;
    static Pattern subtokenPat;
    static Pattern numPat;
    private String termConstructorPattern;
    private String[] termConstructorKeys;
    private boolean patternMatchesEntireTerm;

    private TermEvaluatorBuilderPCVar(String pattern, String[] keys, boolean matchEntireTerm) {
        this.termConstructorPattern = pattern;
        this.termConstructorKeys = keys;
        this.patternMatchesEntireTerm = matchEntireTerm;
    }

    @Override
    public String getTermConstructorPattern() {
        return this.termConstructorPattern;
    }

    @Override
    public String[] getTermConstructorKeys() {
        return this.termConstructorKeys;
    }

    @Override
    public boolean isEntireTerm() {
        return this.patternMatchesEntireTerm;
    }

    static {
        subtokenString = "(FEATAUTOTYPE|FEATNAME|FEATTYPE|VFEATTYPE)";
        subtokenPat = Pattern.compile(subtokenString);
        numPat = Pattern.compile("\\d+");
    }
}

