/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.NonInteractive;
import pcgen.cdom.enumeration.Region;
import pcgen.core.AgeSet;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.RollingMethods;
import pcgen.util.Logging;

public final class BioSet
extends PObject
implements NonInteractive {
    private DoubleKeyMap<Region, Integer, AgeSet> ageMap = new DoubleKeyMap();
    private CaseInsensitiveMap<Integer> ageNames = new CaseInsensitiveMap();
    private TripleKeyMapToList<Region, String, String, String> userMap = new TripleKeyMapToList();

    public AgeSet getAgeSet(Region region, int index) {
        AgeSet ageSet = (AgeSet)this.ageMap.get((Object)region, (Object)index);
        if (ageSet == null || !ageSet.hasBonuses()) {
            ageSet = (AgeSet)this.ageMap.get((Object)Region.getConstant("None"), (Object)index);
        }
        return ageSet;
    }

    public int getAgeSetNamed(String ageCategory) {
        Integer cat = (Integer)this.ageNames.get((Object)ageCategory);
        return cat == null ? -1 : cat;
    }

    public String getRacePCCText(String region, String race) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("REGION:").append(region).append("\n\n");
        Region r = Region.getConstant(region);
        SortedMap<Integer, SortedMap<String, SortedMap<String, String>>> ageSets = this.getRaceTagsByAge(r, race);
        return this.appendAgesetInfo(r, ageSets, sb);
    }

    public List<String> getTagForRace(String region, String race, String tag) {
        return this.getValueInMaps(region, race, tag);
    }

    public void addToUserMap(String regionString, String race, String tag, int ageSetIndex) {
        int i;
        String key;
        int x = tag.indexOf(58);
        if (x < 0) {
            Logging.errorPrint("Invalid value sent to map: " + tag + " (for Race " + race + ")");
            return;
        }
        Region region = Region.getConstant(regionString);
        List r = this.userMap.getListFor((Object)region, (Object)race, (Object)(key = tag.substring(0, x)));
        int n = i = r == null ? 0 : r.size();
        while (i < ageSetIndex) {
            this.userMap.addToListFor((Object)region, (Object)race, (Object)key, (Object)"0");
            ++i;
        }
        this.userMap.addToListFor((Object)region, (Object)race, (Object)key, (Object)tag.substring(x + 1));
    }

    public void clearUserMap() {
        this.userMap.clear();
    }

    public void copyRaceTags(String origRegion, String origRace, String copyRegion, String copyRace) {
        Region oldr = Region.getConstant(origRegion);
        Region newr = Region.getConstant(copyRegion);
        for (String key : this.userMap.getTertiaryKeySet((Object)oldr, (Object)origRace)) {
            this.userMap.addAllToListFor((Object)newr, (Object)copyRace, (Object)key, (Collection)this.userMap.getListFor((Object)oldr, (Object)origRace, (Object)key));
        }
        int idx = origRace.indexOf(40);
        String otherRace = idx >= 0 ? origRace.substring(0, idx).trim() + '%' : origRace + '%';
        for (String key : this.userMap.getTertiaryKeySet((Object)oldr, (Object)otherRace)) {
            this.userMap.addAllToListFor((Object)newr, (Object)copyRace, (Object)key, (Collection)this.userMap.getListFor((Object)oldr, (Object)otherRace, (Object)key));
        }
    }

    public void randomize(String randomizeStr, PlayerCharacter pc) {
        if (pc == null || pc.getRace() == null) {
            return;
        }
        ArrayList<String> ranList = new ArrayList<String>();
        StringTokenizer lineTok = new StringTokenizer(randomizeStr, ".", false);
        while (lineTok.hasMoreTokens()) {
            String aString = lineTok.nextToken();
            if (aString.startsWith("AGECAT")) {
                this.generateAge(Integer.parseInt(aString.substring(6)), false, pc);
                continue;
            }
            ranList.add(aString);
        }
        if (ranList.contains("AGE")) {
            this.generateAge(0, true, pc);
        }
        if (ranList.contains("HT") || ranList.contains("WT")) {
            this.generateHeightWeight(pc);
        }
        if (ranList.contains("EYES")) {
            pc.setEyeColor(this.generateBioValue("EYES", pc));
        }
        if (ranList.contains("HAIR")) {
            pc.setHairColor(this.generateBioValue("HAIR", pc));
        }
        if (ranList.contains("SKIN")) {
            pc.setSkinColor(this.generateBioValue("SKINTONE", pc));
        }
    }

    public void removeFromUserMap(String region, String race, String tag) {
        int x = tag.indexOf(58);
        String key = x < 0 ? tag : tag.substring(0, x);
        this.userMap.removeListFor((Object)Region.getConstant(region), (Object)race, (Object)key);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("AgeMap: ").append(this.ageMap.toString()).append("\n");
        sb.append("UserMap: ").append(this.userMap.toString()).append("\n");
        return sb.toString();
    }

    private static String replaceString(String argInput, String replacement, int value) {
        String input = argInput;
        int x = input.indexOf(replacement);
        if (x >= 0) {
            String output = input.substring(0, x);
            String appendage = input.substring(x + replacement.length());
            input = output + value + appendage;
        }
        return input;
    }

    private SortedMap<Integer, SortedMap<String, SortedMap<String, String>>> getRaceTagsByAge(Region region, String race) {
        TreeMap<Integer, SortedMap<String, SortedMap<String, String>>> ageSets = new TreeMap<Integer, SortedMap<String, SortedMap<String, String>>>();
        for (String key : this.userMap.getTertiaryKeySet((Object)region, (Object)race)) {
            this.addTagToAgeSet(ageSets, race, key, this.userMap.getListFor((Object)region, (Object)race, (Object)key));
        }
        return ageSets;
    }

    private String getTokenNumberInMaps(String addKey, int tokenNum, String regionName, String raceName) {
        List<String> r = this.getValueInMaps(regionName, raceName, addKey);
        if (r == null) {
            return null;
        }
        if (r.size() <= tokenNum) {
            return "0";
        }
        return r.get(tokenNum);
    }

    public List<String> getValueInMaps(String argRegionName, String argRaceName, String addKey) {
        String anotherRaceName = argRaceName.indexOf(40) >= 0 ? argRaceName.substring(0, argRaceName.indexOf(40)).trim() + '%' : argRaceName + '%';
        return this.mapFind(this.userMap, argRegionName, argRaceName, addKey, anotherRaceName);
    }

    private void addTagToAgeSet(SortedMap<Integer, SortedMap<String, SortedMap<String, String>>> ageSets, String race, String key, List<String> value) {
        Iterator<String> iter = value.iterator();
        Iterator i$ = this.ageNames.values().iterator();
        while (i$.hasNext()) {
            TreeMap<String, String> tags;
            int ageBracket = (Integer)i$.next();
            if (!iter.hasNext()) break;
            String tagValue = iter.next();
            TreeMap<String, TreeMap<String, String>> races = (TreeMap<String, TreeMap<String, String>>)ageSets.get(ageBracket);
            if (races == null) {
                races = new TreeMap<String, TreeMap<String, String>>();
                ageSets.put(ageBracket, races);
            }
            if ((tags = (TreeMap<String, String>)races.get(race)) == null) {
                tags = new TreeMap<String, String>();
                races.put(race, tags);
            }
            tags.put(key, tagValue);
        }
    }

    private String appendAgesetInfo(Region region, SortedMap<Integer, SortedMap<String, SortedMap<String, String>>> ageSets, StringBuilder sb) {
        TreeSet<Integer> ageIndices = new TreeSet<Integer>();
        ageIndices.addAll(ageSets.keySet());
        ageIndices.addAll(this.ageNames.values());
        for (Integer key : ageIndices) {
            SortedMap races = (SortedMap)ageSets.get(key);
            if (races == null) continue;
            sb.append("AGESET:");
            sb.append(((AgeSet)this.ageMap.get((Object)region, (Object)key)).getLSTformat()).append("\n");
            for (String aRaceName : races.keySet()) {
                if ("AGESET".equals(aRaceName)) continue;
                SortedMap tags = (SortedMap)races.get(aRaceName);
                for (String tagName : tags.keySet()) {
                    sb.append("RACENAME:").append(aRaceName).append("\t\t");
                    sb.append(tagName).append(':').append((String)tags.get(tagName)).append("\n");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void generateAge(int ageCategory, boolean useClassOnly, PlayerCharacter pc) {
        String age = this.getTokenNumberInMaps("BASEAGE", ageCategory, pc.getDisplay().getRegionString(), pc.getRace().getKeyName().trim());
        if (age == null) {
            return;
        }
        int baseAge = Integer.parseInt(age);
        int ageAdd = -1;
        String aClass = this.getTokenNumberInMaps("CLASS", ageCategory, pc.getDisplay().getRegionString(), pc.getRace().getKeyName().trim());
        if (aClass != null && !aClass.equals("0")) {
            StringTokenizer aTok = new StringTokenizer(aClass, "|");
            while (aTok.hasMoreTokens()) {
                int end;
                int start;
                String aString = aTok.nextToken();
                String dieString = aString.substring((start = aString.indexOf("[")) + 1, end = aString.indexOf("]"));
                if (dieString.startsWith("BASEAGEADD:")) {
                    dieString = dieString.substring(11);
                }
                aString = aString.substring(0, start);
                StringTokenizer bTok = new StringTokenizer(aString, ",");
                while (bTok.hasMoreTokens() && ageAdd < 0) {
                    String tClass = bTok.nextToken();
                    if (pc.getClassKeyed(tClass) == null) continue;
                    ageAdd = RollingMethods.roll(dieString);
                }
            }
        }
        if (ageAdd < 0 && !useClassOnly && (aClass = this.getTokenNumberInMaps("AGEDIEROLL", ageCategory, pc.getDisplay().getRegionString(), pc.getRace().getKeyName().trim())) != null) {
            ageAdd = RollingMethods.roll(aClass);
        }
        if (ageAdd >= 0 && baseAge > 0) {
            int maxAge;
            String maxage = this.getTokenNumberInMaps("MAXAGE", ageCategory, pc.getDisplay().getRegionString(), pc.getRace().getKeyName().trim());
            if (maxage != null && baseAge + ageAdd > (maxAge = Integer.parseInt(maxage))) {
                ageAdd = maxAge - baseAge;
            }
            pc.setAge(baseAge + ageAdd);
        }
    }

    private String generateBioValue(String addKey, PlayerCharacter pc) {
        String rv;
        String line = this.getTokenNumberInMaps(addKey, 0, pc.getDisplay().getRegionString(), pc.getRace().getKeyName().trim());
        if (line != null && line.length() > 0) {
            StringTokenizer aTok = new StringTokenizer(line, "|");
            ArrayList<String> aList = new ArrayList<String>();
            while (aTok.hasMoreTokens()) {
                aList.add(aTok.nextToken());
            }
            int roll = RollingMethods.roll(1, aList.size()) - 1;
            rv = (String)aList.get(roll);
        } else {
            rv = "";
        }
        return rv;
    }

    private void generateHeightWeight(PlayerCharacter pc) {
        int baseHeight = 0;
        int baseWeight = 0;
        int htAdd = 0;
        int wtAdd = 0;
        String totalWeight = null;
        String htwt = this.getTokenNumberInMaps("SEX", 0, pc.getDisplay().getRegionString(), pc.getRace().getKeyName().trim());
        if (htwt == null) {
            return;
        }
        StringTokenizer genderTok = new StringTokenizer(htwt, "[]", false);
        while (genderTok.hasMoreTokens()) {
            if (genderTok.nextToken().equals(pc.getDisplay().getGenderObject().toString())) {
                String htWtLine = genderTok.nextToken();
                StringTokenizer htwtTok = new StringTokenizer(htWtLine, "|", false);
                while (htwtTok.hasMoreTokens()) {
                    String tag = htwtTok.nextToken();
                    if (tag.startsWith("BASEHT:")) {
                        baseHeight = Integer.parseInt(tag.substring(7));
                        continue;
                    }
                    if (tag.startsWith("BASEWT:")) {
                        baseWeight = Integer.parseInt(tag.substring(7));
                        continue;
                    }
                    if (tag.startsWith("HTDIEROLL:")) {
                        htAdd = RollingMethods.roll(tag.substring(10));
                        continue;
                    }
                    if (tag.startsWith("WTDIEROLL:")) {
                        wtAdd = RollingMethods.roll(tag.substring(10));
                        continue;
                    }
                    if (!tag.startsWith("TOTALWT:")) continue;
                    totalWeight = tag.substring(8);
                }
                if (baseHeight != 0 && htAdd != 0) {
                    pc.setHeight(baseHeight + htAdd);
                }
                if (totalWeight == null || baseWeight == 0 || wtAdd == 0) break;
                totalWeight = BioSet.replaceString(totalWeight, "HTDIEROLL", htAdd);
                totalWeight = BioSet.replaceString(totalWeight, "BASEWT", baseWeight);
                totalWeight = BioSet.replaceString(totalWeight, "WTDIEROLL", wtAdd);
                pc.setWeight(pc.getVariableValue(totalWeight, "").intValue());
                break;
            }
            genderTok.nextToken();
        }
    }

    private List<String> mapFind(TripleKeyMapToList<Region, String, String, String> argMap, String argRegionName, String argRaceName, String addKey, String altRaceName) {
        Region region = Region.getConstant(argRegionName);
        List r = argMap.getListFor((Object)region, (Object)argRaceName, (Object)addKey);
        if (r != null && !r.isEmpty()) {
            return r;
        }
        int altRaceLength = altRaceName.length();
        if (altRaceLength != 0 && (r = argMap.getListFor((Object)region, (Object)altRaceName, (Object)addKey)) != null) {
            return r;
        }
        if (!argRegionName.equals("None")) {
            region = Region.getConstant("None");
            r = argMap.getListFor((Object)region, (Object)argRaceName, (Object)addKey);
            if (r != null) {
                return r;
            }
            if (altRaceLength != 0) {
                r = argMap.getListFor((Object)region, (Object)altRaceName, (Object)addKey);
            }
        }
        return r;
    }

    public AgeSet addToAgeMap(String regionName, AgeSet ageSet, URI sourceURI) {
        AgeSet old = (AgeSet)this.ageMap.get((Object)Region.getConstant(regionName), (Object)ageSet.getIndex());
        if (old != null) {
            if (ageSet.hasBonuses() || !ageSet.getKits().isEmpty() || !ageSet.getName().equals(old.getName())) {
                Logging.errorPrint("Found second (non-identical) AGESET in Bio Settings " + sourceURI + " for Region: " + regionName + " Index: " + ageSet.getIndex() + " using the existing " + old.getLSTformat());
            }
            return old;
        }
        this.ageMap.put((Object)Region.getConstant(regionName), (Object)ageSet.getIndex(), (Object)ageSet);
        return ageSet;
    }

    public Integer addToNameMap(AgeSet ageSet) {
        return (Integer)this.ageNames.put((Object)ageSet.getName(), (Object)ageSet.getIndex());
    }

    public Set<String> getAgeCategories() {
        TreeSet<String> set = new TreeSet<String>();
        for (Object o : this.ageNames.keySet()) {
            set.add(o.toString());
        }
        return set;
    }

    public Map<Integer, AgeSet> getAgeSets(String regionName) {
        return new TreeMap<Integer, AgeSet>(this.ageMap.getMapFor((Object)Region.getConstant(regionName)));
    }
}

