/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.model;

import java.util.IdentityHashMap;
import java.util.Set;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.SetFacet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.facet.AutoWeaponProfFacet;
import pcgen.cdom.facet.DeityWeaponProfFacet;
import pcgen.cdom.facet.HasDeityWeaponProfFacet;
import pcgen.cdom.facet.WeaponProfFacet;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.WeaponProf;
import pcgen.output.publish.OutputDB;

public class WeaponProfModelFacet
implements SetFacet<CharID, WeaponProf> {
    private WeaponProfFacet weaponProfFacet;
    private AutoWeaponProfFacet autoWeaponProfFacet;
    private HasDeityWeaponProfFacet hasDeityWeaponProfFacet;
    private DeityWeaponProfFacet deityWeaponProfFacet;

    @Override
    public Set<WeaponProf> getSet(CharID id) {
        WrappedMapSet ret = new WrappedMapSet(IdentityHashMap.class);
        ret.addAll(this.weaponProfFacet.getSet(id));
        ret.addAll(this.autoWeaponProfFacet.getWeaponProfs(id));
        if (this.hasDeityWeaponProfFacet.hasDeityWeaponProf(id)) {
            ret.addAll(this.deityWeaponProfFacet.getSet(id));
        }
        return ret;
    }

    public boolean containsProf(CharID id, WeaponProf wp) {
        return this.weaponProfFacet.contains(id, wp) || this.autoWeaponProfFacet.containsProf(id, wp) || this.hasDeityWeaponProfFacet.hasDeityWeaponProf(id) && this.deityWeaponProfFacet.getSet(id).contains(wp);
    }

    public boolean isProficientWithWeapon(CharID id, Equipment eq) {
        if (eq.isNatural()) {
            return true;
        }
        CDOMSingleRef<WeaponProf> ref = eq.get(ObjectKey.WEAPON_PROF);
        if (ref == null) {
            return false;
        }
        return this.containsProf(id, ref.resolvesTo());
    }

    public void setWeaponProfFacet(WeaponProfFacet weaponProfFacet) {
        this.weaponProfFacet = weaponProfFacet;
    }

    public void setAutoWeaponProfFacet(AutoWeaponProfFacet autoWeaponProfFacet) {
        this.autoWeaponProfFacet = autoWeaponProfFacet;
    }

    public void setHasDeityWeaponProfFacet(HasDeityWeaponProfFacet hasDeityWeaponProfFacet) {
        this.hasDeityWeaponProfFacet = hasDeityWeaponProfFacet;
    }

    public void setDeityWeaponProfFacet(DeityWeaponProfFacet deityWeaponProfFacet) {
        this.deityWeaponProfFacet = deityWeaponProfFacet;
    }

    public void init() {
        OutputDB.register("weaponprofs", this);
    }

    @Override
    public int getCount(CharID id) {
        return this.getSet(id).size();
    }
}

