/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.input;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.RaceSelectionFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.analysis.ChooseActivation;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;

public class RaceInputFacet {
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private RaceSelectionFacet raceSelectionFacet;
    private RaceFacet raceFacet;

    public boolean set(CharID id, Race race) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (pc.isAllowInteraction() && ChooseActivation.hasNewChooseToken(race)) {
            ChoiceManagerList aMan = ChooserUtilities.getChoiceManager(race, pc);
            return this.processChoice(id, pc, race, aMan);
        }
        return this.directSet(id, race, null);
    }

    private <T> boolean processChoice(CharID id, PlayerCharacter pc, Race race, ChoiceManagerList<T> aMan) {
        List<T> newSelections;
        ArrayList selectedList = new ArrayList();
        ArrayList availableList = new ArrayList();
        aMan.getChoices(pc, availableList, selectedList);
        if (availableList.isEmpty()) {
            return false;
        }
        if (!selectedList.isEmpty()) {
            // empty if block
        }
        if ((newSelections = aMan.doChooser(pc, availableList, selectedList, new ArrayList<String>())).size() != 1) {
            return false;
        }
        for (T sel : newSelections) {
            this.directSet(id, race, sel);
        }
        return true;
    }

    public void importSelection(CharID id, Race race, String choice) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (ChooseActivation.hasNewChooseToken(race)) {
            ChoiceManagerList aMan = ChooserUtilities.getChoiceManager(race, pc);
            this.processImport(id, race, aMan, choice);
        } else {
            this.directSet(id, race, null);
        }
    }

    private <T> void processImport(CharID id, Race race, ChoiceManagerList<T> aMan, String choice) {
        this.directSet(id, race, aMan.decodeChoice(choice));
    }

    public <T> boolean directSet(CharID id, Race race, T sel) {
        PlayerCharacter pc;
        Race old = (Race)((AbstractItemFacet)this.raceFacet).get(id);
        if (this.raceFacet.set(id, race) && old != null && (pc = this.trackingFacet.getPC(id)).isAllowInteraction()) {
            this.raceSelectionFacet.remove(id, old);
        }
        if (sel != null) {
            this.raceSelectionFacet.set(id, race, sel);
        }
        return true;
    }

    public void remove(CharID id) {
        Race r = (Race)this.raceFacet.remove(id);
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (pc.isAllowInteraction() && r != null) {
            this.raceSelectionFacet.remove(id, r);
        }
    }

    public void setRaceSelectionFacet(RaceSelectionFacet raceSelectionFacet) {
        this.raceSelectionFacet = raceSelectionFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }
}

