/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import pcgen.base.formula.Formula;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.PCTemplate;
import pcgen.core.Race;

public class LevelFacet
extends AbstractStorageFacet<CharID>
implements ClassFacet.ClassLevelChangeListener {
    private TemplateFacet templateFacet;
    private RaceFacet raceFacet;
    private FormulaResolvingFacet formulaResolvingFacet;
    private final LevelChangeSupport support = new LevelChangeSupport();

    public int getNonMonsterLevelCount(CharID id) {
        LevelCacheInfo info = this.getInfo(id);
        return info == null ? 0 : info.nonMonsterLevels;
    }

    public int getMonsterLevelCount(CharID id) {
        LevelCacheInfo info = this.getInfo(id);
        return info == null ? 0 : info.monsterLevels;
    }

    public int getLevelAdjustment(CharID id) {
        Race race = (Race)((AbstractItemFacet)this.raceFacet).get(id);
        int levelAdj = 0;
        if (race != null) {
            Formula raceLA = race.getSafe(FormulaKey.LEVEL_ADJUSTMENT);
            levelAdj += this.formulaResolvingFacet.resolve(id, raceLA, "").intValue();
        }
        for (PCTemplate template : this.templateFacet.getSet(id)) {
            Formula templateLA = template.getSafe(FormulaKey.LEVEL_ADJUSTMENT);
            levelAdj += this.formulaResolvingFacet.resolve(id, templateLA, "").intValue();
        }
        return levelAdj;
    }

    public int getECL(CharID id) {
        int levelAdjustment = this.getLevelAdjustment(id);
        LevelCacheInfo info = this.getInfo(id);
        if (info == null) {
            return levelAdjustment;
        }
        return info.nonMonsterLevels + info.monsterLevels + levelAdjustment;
    }

    public int getTotalLevels(CharID id) {
        LevelCacheInfo info = this.getInfo(id);
        return info == null ? 0 : info.nonMonsterLevels + info.monsterLevels;
    }

    private LevelCacheInfo getConstructingInfo(CharID id) {
        LevelCacheInfo lci = this.getInfo(id);
        if (lci == null) {
            lci = new LevelCacheInfo();
            this.setCache(id, lci);
        }
        return lci;
    }

    private LevelCacheInfo getInfo(CharID id) {
        return (LevelCacheInfo)this.getCache(id);
    }

    @Override
    public void levelChanged(ClassFacet.ClassLevelChangeEvent lce) {
        CharID id = lce.getCharID();
        LevelCacheInfo lci = this.getConstructingInfo(id);
        int levelChange = lce.getNewLevel() - lce.getOldLevel();
        if (levelChange != 0) {
            if (lce.getPCClass().isMonster()) {
                lci.monsterLevels += levelChange;
            } else {
                lci.nonMonsterLevels += levelChange;
            }
            this.support.fireLevelChangeEvent(id);
        }
    }

    @Override
    public void levelObjectChanged(ClassFacet.ClassLevelObjectChangeEvent lce) {
    }

    public void addLevelChangeListener(LevelChangeListener listener) {
        this.support.addLevelChangeListener(listener);
    }

    public void removeLevelChangeListener(LevelChangeListener listener) {
        this.support.removeLevelChangeListener(listener);
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet resolveFacet) {
        this.formulaResolvingFacet = resolveFacet;
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        LevelCacheInfo info = this.getInfo(source);
        if (info != null) {
            LevelCacheInfo copyinfo = this.getConstructingInfo(copy);
            copyinfo.monsterLevels = info.monsterLevels;
            copyinfo.nonMonsterLevels = info.nonMonsterLevels;
        }
    }

    public static class LevelChangeSupport {
        private final EventListenerList listenerList = new EventListenerList();

        public void addLevelChangeListener(LevelChangeListener listener) {
            this.listenerList.add(LevelChangeListener.class, listener);
        }

        public synchronized LevelChangeListener[] getLevelChangeListeners() {
            return (LevelChangeListener[])this.listenerList.getListeners(LevelChangeListener.class);
        }

        public void removeLevelChangeListener(LevelChangeListener listener) {
            this.listenerList.remove(LevelChangeListener.class, listener);
        }

        protected void fireLevelChangeEvent(CharID id) {
            LevelChangeListener[] listeners = (LevelChangeListener[])this.listenerList.getListeners(LevelChangeListener.class);
            LevelChangeEvent ccEvent = null;
            for (int i = listeners.length - 1; i >= 0; --i) {
                if (ccEvent == null) {
                    ccEvent = new LevelChangeEvent(id);
                }
                listeners[i].levelChanged(ccEvent);
            }
        }
    }

    public static class LevelChangeEvent
    extends EventObject {
        private final CharID charID;

        public LevelChangeEvent(CharID source) {
            super(source);
            this.charID = source;
        }

        public CharID getCharID() {
            return this.charID;
        }
    }

    public static interface LevelChangeListener
    extends EventListener {
        public void levelChanged(LevelChangeEvent var1);
    }

    private static class LevelCacheInfo {
        public int monsterLevels;
        public int nonMonsterLevels;

        private LevelCacheInfo() {
        }

        public int hashCode() {
            return this.monsterLevels * this.nonMonsterLevels;
        }

        public boolean equals(Object o) {
            if (o instanceof LevelCacheInfo) {
                LevelCacheInfo other = (LevelCacheInfo)o;
                return this.monsterLevels == other.monsterLevels && this.nonMonsterLevels == other.nonMonsterLevels;
            }
            return false;
        }
    }
}

