/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.choose;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CategorizedChooseInformation;
import pcgen.cdom.base.CategorizedChooser;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.choiceset.CollectionToChoiceSet;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class AbilityToken
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
CategorizedChooser<Ability> {
    private static final Class<AbilityCategory> ABILITY_CATEGORY_CLASS = AbilityCategory.class;
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getParentToken() {
        return "CHOOSE";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, ReferenceManufacturer<Ability> rm, CDOMSingleRef<AbilityCategory> acRef, CDOMObject obj, String value) {
        String title;
        String activeValue;
        int pipeLoc = value.lastIndexOf(124);
        if (pipeLoc == -1) {
            activeValue = value;
            title = this.getDefaultTitle();
        } else {
            String titleString = value.substring(pipeLoc + 1);
            if (titleString.startsWith("TITLE=")) {
                title = titleString.substring(6);
                if (title.startsWith("\"")) {
                    title = title.substring(1, title.length() - 1);
                }
                activeValue = value.substring(0, pipeLoc);
                if (title == null || title.length() == 0) {
                    return new ParseResult.Fail(this.getParentToken() + ":" + this.getTokenName() + " had TITLE= but no title: " + value, context);
                }
            } else {
                activeValue = value;
                title = this.getDefaultTitle();
            }
        }
        PrimitiveCollection coll = context.getChoiceSet(rm, activeValue);
        if (coll == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        if (!coll.getGroupingState().isValid()) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("Invalid combination of objects was used in: " + activeValue);
            cpr.addErrorMessage("  Check that ALL is not combined");
            cpr.addErrorMessage("  Check that a key is not joined with AND (,)");
            return cpr;
        }
        CollectionToChoiceSet pcs = new CollectionToChoiceSet(coll);
        CategorizedChooseInformation tc = new CategorizedChooseInformation(this.getTokenName(), acRef, (PrimitiveChoiceSet)pcs, Ability.class);
        tc.setTitle(title);
        tc.setChoiceActor((Chooser)this);
        context.getObjectContext().put(obj, ObjectKey.CHOOSE_INFO, (Object)tc);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject cdo) {
        ChooseInformation tc = (ChooseInformation)context.getObjectContext().getObject(cdo, ObjectKey.CHOOSE_INFO);
        if (tc == null) {
            return null;
        }
        if (!tc.getName().equals(this.getTokenName())) {
            return null;
        }
        if (!tc.getGroupingState().isValid()) {
            context.addWriteMessage("Invalid combination of objects was used in: " + this.getParentToken() + ":" + this.getTokenName());
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(((CategorizedChooseInformation)tc).getCategory().getLSTformat(false));
        sb.append('|');
        sb.append(tc.getLSTformat());
        String title = tc.getTitle();
        if (!title.equals(this.getDefaultTitle())) {
            sb.append("|TITLE=");
            sb.append(title);
        }
        return new String[]{sb.toString()};
    }

    public void applyChoice(ChooseDriver owner, Ability st, PlayerCharacter pc) {
        this.restoreChoice(pc, owner, st);
    }

    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, Ability choice) {
        pc.removeAssoc((Object)owner, this.getListKey(), (Object)choice);
        List actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor ca : actors) {
                ca.removeChoice(owner, (Object)choice, pc);
            }
        }
    }

    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, Ability choice) {
        pc.addAssoc((Object)owner, this.getListKey(), (Object)choice);
        List actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor ca : actors) {
                ca.applyChoice(owner, (Object)choice, pc);
            }
        }
    }

    public List<Ability> getCurrentlySelected(ChooseDriver owner, PlayerCharacter pc) {
        return pc.getAssocList((Object)owner, this.getListKey());
    }

    public boolean allow(Ability choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    public String getTokenName() {
        return "ABILITY";
    }

    public ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        int barLoc = value.indexOf(124);
        if (barLoc == -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " requires a CATEGORY and arguments : " + value, context);
        }
        String cat = value.substring(0, barLoc);
        CDOMSingleRef acRef = context.getReferenceContext().getCDOMReference(ABILITY_CATEGORY_CLASS, cat);
        String abilities = value.substring(barLoc + 1);
        ReferenceManufacturer rm = context.getReferenceContext().getManufacturer(ABILITY_CLASS, ABILITY_CATEGORY_CLASS, cat);
        if (rm == null) {
            return new ParseResult.Fail("Could not get Reference Manufacturer for Category: " + cat, context);
        }
        return this.parseTokenWithSeparator(context, (ReferenceManufacturer<Ability>)rm, (CDOMSingleRef<AbilityCategory>)acRef, obj, abilities);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    protected String getDefaultTitle() {
        return "Ability choice";
    }

    protected AssociationListKey<Ability> getListKey() {
        return AssociationListKey.getKeyFor(ABILITY_CLASS, (String)"CHOOSE*ABILITY");
    }

    public Ability decodeChoice(LoadContext context, String s) {
        StringTokenizer st = new StringTokenizer(s, "|");
        String catString = st.nextToken();
        if (!catString.startsWith("CATEGORY=")) {
            throw new IllegalArgumentException("String in AbilityToken.decodeChoice must start with CATEGORY=, found: " + s);
        }
        String cat = catString.substring(9);
        AbilityCategory ac = SettingsHandler.getGame().getAbilityCategory(cat);
        if (ac == null) {
            throw new IllegalArgumentException("Category in AbilityToken.decodeChoice must exist found: " + cat);
        }
        String ab = st.nextToken();
        Ability a = (Ability)context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, (Category)ac, ab);
        if (a == null) {
            throw new IllegalArgumentException("Second argument in String in AbilityToken.decodeChoice must be an Ability, but it was not found: " + s);
        }
        return a;
    }

    public String encodeChoice(Ability choice) {
        return choice.getKeyName();
    }

    public Ability decodeChoice(LoadContext context, String encoded, Category<?> category) {
        String key;
        AbilityCategory abilityCat = (AbilityCategory)category;
        StringTokenizer st = new StringTokenizer(encoded, "|");
        if (st.countTokens() > 1) {
            String catString = st.nextToken();
            if (!catString.startsWith("CATEGORY=")) {
                throw new IllegalArgumentException("Ability choice must be key name or CATEGORY=category|ability found: " + encoded);
            }
            String cat = catString.substring(9);
            abilityCat = SettingsHandler.getGame().getAbilityCategory(cat);
            key = st.nextToken();
        } else {
            key = encoded;
        }
        Ability a = (Ability)context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, (Category)abilityCat, key);
        if (a == null) {
            throw new IllegalArgumentException("String in decodeChoice must be an Ability, but it was not found: " + encoded);
        }
        return a;
    }
}

