/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

public class Utils {
    public static JFormattedTextField buildIntegerField(int min, int max) {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormatter formatter = new NumberFormatter(numberFormat);
        formatter.setMinimum(Integer.valueOf(min));
        formatter.setMaximum(Integer.valueOf(max));
        final JFormattedTextField returnValue = new JFormattedTextField(formatter);
        returnValue.setColumns(3);
        returnValue.addPropertyChangeListener(new PropertyChangeListener(){
            Border m_originalBorder;
            {
                this.m_originalBorder = returnValue.getBorder();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() != null && evt.getPropertyName().equals("editValid") && evt.getNewValue() != null && evt.getNewValue() instanceof Boolean) {
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        returnValue.setBorder(this.m_originalBorder);
                    } else {
                        returnValue.setBorder(BorderFactory.createLineBorder(Color.red));
                    }
                }
            }
        });
        return returnValue;
    }

    public static JFormattedTextField buildFloatField(float min, float max) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        NumberFormatter formatter = new NumberFormatter(numberFormat);
        formatter.setMinimum(Float.valueOf(min));
        formatter.setMaximum(Float.valueOf(max));
        final JFormattedTextField returnValue = new JFormattedTextField(formatter);
        returnValue.setColumns(4);
        returnValue.addPropertyChangeListener(new PropertyChangeListener(){
            Border m_originalBorder;
            {
                this.m_originalBorder = returnValue.getBorder();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() != null && evt.getPropertyName().equals("editValid") && evt.getNewValue() != null && evt.getNewValue() instanceof Boolean) {
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        returnValue.setBorder(this.m_originalBorder);
                    } else {
                        returnValue.setBorder(BorderFactory.createLineBorder(Color.red));
                    }
                }
            }
        });
        return returnValue;
    }

    public static JFormattedTextField buildIntegerFieldWithSlider(final JSlider matchingSlider) {
        final JFormattedTextField returnValue = Utils.buildIntegerField(matchingSlider.getMinimum(), matchingSlider.getMaximum());
        returnValue.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Number value;
                if ("value".equals(evt.getPropertyName()) && (value = (Number)evt.getNewValue()) != null) {
                    matchingSlider.setValue(value.intValue());
                }
            }
        });
        matchingSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                if (!source.getValueIsAdjusting()) {
                    returnValue.setValue(value);
                } else {
                    returnValue.setText(String.valueOf(value));
                }
            }
        });
        return returnValue;
    }

    public static JSlider buildSlider(int min, int max) {
        return Utils.buildSlider(min, max, 1, 5);
    }

    public static JSlider buildSlider(int min, int max, int minorTick, int majorTick) {
        JSlider slider = new JSlider();
        slider.setMinimum(min);
        slider.setMaximum(max);
        slider.setMajorTickSpacing(majorTick);
        slider.setMinorTickSpacing(minorTick);
        slider.setPaintTicks(true);
        return slider;
    }
}

