#!/usr/bin/perl
# Simple script to convert a header file into a hash reference

use Getopt::Std;

getopts("hf:n:m:", \%options) || usage();
usage() if $options{"h"} || (!$options{"f"} || !$options{"n"} || !$options{"m"});

if(-r $options{"f"}) {
   open HEADER, $options{"f"} || die "Couldn't open header file: $!\n";
   print "\n".$options{"n"}." = (\n";
   while(<HEADER>) {
	my $line=$_;
	if($line=~/#define(\s*)$options{"m"}(\S*)(\s*)(\d*)/i) {
		print "\t$4 => \"$2\",\n" if $4;
	}
   }
   print ");\n";
   close HEADER;
} else {
   print "Could find ".$options{"f"}."\n";
   exit(1);
}

sub usage {
print "Usage: $0 -f <header file> -n <hash_name> -m <match_crit>\n";
print "\t\t-f\tHeader file that contains #DEFINES\n";
print "\t\t-n\tHash name you want to create.\n";
print "\t\t-m\tMatch critirea (will be excluded)\n";
print "\n results are published to STDOUT\n";
print "\nEx: $0 -f unistd.h -n syscalls -m __NR_\n";
print "     will create output similiar to:\n";
print "\n%syscalls = (\n";
print "\t1 => \"EXIT\"\n";
print "\t  ...\n";
print ");\n";
}
