/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util.ratelimit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.velocitypowered.proxy.util.ratelimit.Ratelimiter;
import java.net.InetAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class GuavaCacheRatelimiter
implements Ratelimiter {
    private final Cache<InetAddress, Long> expiringCache;
    private final long timeoutNanos;

    GuavaCacheRatelimiter(long time, TimeUnit unit) {
        this(time, unit, Ticker.systemTicker());
    }

    @VisibleForTesting
    GuavaCacheRatelimiter(long time, TimeUnit unit, Ticker ticker) {
        Preconditions.checkNotNull(unit, "unit");
        Preconditions.checkNotNull(ticker, "ticker");
        this.timeoutNanos = unit.toNanos(time);
        this.expiringCache = CacheBuilder.newBuilder().ticker(ticker).concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterWrite(time, unit).build();
    }

    @Override
    public boolean attempt(InetAddress address) {
        long last;
        Preconditions.checkNotNull(address, "address");
        long expectedNewValue = System.nanoTime() + this.timeoutNanos;
        try {
            last = this.expiringCache.get(address, () -> expectedNewValue);
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
        return expectedNewValue == last;
    }
}

