/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import javax.crypto.Cipher;

public enum EncryptionUtils {


    public static KeyPair createRsaKeyPair(int keysize) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(keysize);
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to generate RSA keypair", e);
        }
    }

    public static String twosComplementHexdigest(byte[] digest) {
        return new BigInteger(digest).toString(16);
    }

    public static byte[] decryptRsa(KeyPair keyPair, byte[] bytes) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, keyPair.getPrivate());
        return cipher.doFinal(bytes);
    }

    public static String generateServerId(byte[] sharedSecret, PublicKey key) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(sharedSecret);
            digest.update(key.getEncoded());
            return EncryptionUtils.twosComplementHexdigest(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

