/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.brigadier;

import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.velocitypowered.proxy.protocol.packet.brigadier.ArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.IntegerArgumentPropertySerializer;
import io.netty.buffer.ByteBuf;

class DoubleArgumentPropertySerializer
implements ArgumentPropertySerializer<DoubleArgumentType> {
    static final DoubleArgumentPropertySerializer DOUBLE = new DoubleArgumentPropertySerializer();

    private DoubleArgumentPropertySerializer() {
    }

    @Override
    public DoubleArgumentType deserialize(ByteBuf buf) {
        byte flags = buf.readByte();
        double minimum = (flags & 1) != 0 ? buf.readDouble() : Double.MIN_VALUE;
        double maximum = (flags & 2) != 0 ? buf.readDouble() : Double.MAX_VALUE;
        return DoubleArgumentType.doubleArg(minimum, maximum);
    }

    @Override
    public void serialize(DoubleArgumentType object, ByteBuf buf) {
        boolean hasMinimum = Double.compare(object.getMinimum(), Double.MIN_VALUE) != 0;
        boolean hasMaximum = Double.compare(object.getMaximum(), Double.MAX_VALUE) != 0;
        byte flag = IntegerArgumentPropertySerializer.getFlags(hasMinimum, hasMaximum);
        buf.writeByte(flag);
        if (hasMinimum) {
            buf.writeDouble(object.getMinimum());
        }
        if (hasMaximum) {
            buf.writeDouble(object.getMaximum());
        }
    }
}

