/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.tree.CommandNode;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;

final class VelocityCommandMeta
implements CommandMeta {
    private final Set<String> aliases;
    private final List<CommandNode<CommandSource>> hints;

    private VelocityCommandMeta(Set<String> aliases, List<CommandNode<CommandSource>> hints) {
        this.aliases = aliases;
        this.hints = hints;
    }

    @Override
    public Collection<String> getAliases() {
        return this.aliases;
    }

    @Override
    public Collection<CommandNode<CommandSource>> getHints() {
        return this.hints;
    }

    static final class Builder
    implements CommandMeta.Builder {
        private final ImmutableSet.Builder<String> aliases;
        private final ImmutableList.Builder<CommandNode<CommandSource>> hints;

        public Builder(String alias) {
            Preconditions.checkNotNull(alias, "alias");
            this.aliases = ImmutableSet.builder().add(alias.toLowerCase(Locale.ENGLISH));
            this.hints = ImmutableList.builder();
        }

        @Override
        public CommandMeta.Builder aliases(String ... aliases) {
            Preconditions.checkNotNull(aliases, "aliases");
            int length = aliases.length;
            for (int i = 0; i < length; ++i) {
                String alias1 = aliases[i];
                Preconditions.checkNotNull(alias1, "alias at index %s", i);
                this.aliases.add((Object)alias1.toLowerCase(Locale.ENGLISH));
            }
            return this;
        }

        @Override
        public CommandMeta.Builder hint(CommandNode<CommandSource> node) {
            Preconditions.checkNotNull(node, "node");
            this.hints.add((Object)node);
            return this;
        }

        @Override
        public CommandMeta build() {
            return new VelocityCommandMeta((Set)((Object)this.aliases.build()), (List)((Object)this.hints.build()));
        }
    }
}

