/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'sel_write_enforce' function
 *
 * Notes:
 *  - Intercept SELinux state modifications
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 13.XI.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifdef CONFIG_SECURITY_SELINUX

#ifndef P_LKRG_EXPLOIT_DETECTION_SEL_WRITE_ENFORCE_H
#define P_LKRG_EXPLOIT_DETECTION_SEL_WRITE_ENFORCE_H


/* per-instance private data */
struct p_sel_write_enforce_data {
    ktime_t entry_stamp;
};


int p_sel_write_enforce_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_sel_write_enforce_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_sel_write_enforce_hook(int p_isra);
void p_uninstall_sel_write_enforce_hook(void);

#endif

#endif
