//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrollviewindicatorstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIScrollViewIndicatorStyle(pub NSInteger);
impl UIScrollViewIndicatorStyle {
    #[doc(alias = "UIScrollViewIndicatorStyleDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "UIScrollViewIndicatorStyleBlack")]
    pub const Black: Self = Self(1);
    #[doc(alias = "UIScrollViewIndicatorStyleWhite")]
    pub const White: Self = Self(2);
}

unsafe impl Encode for UIScrollViewIndicatorStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIScrollViewIndicatorStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrollviewkeyboarddismissmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIScrollViewKeyboardDismissMode(pub NSInteger);
impl UIScrollViewKeyboardDismissMode {
    #[doc(alias = "UIScrollViewKeyboardDismissModeNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "UIScrollViewKeyboardDismissModeOnDrag")]
    pub const OnDrag: Self = Self(1);
    #[doc(alias = "UIScrollViewKeyboardDismissModeInteractive")]
    pub const Interactive: Self = Self(2);
    #[doc(alias = "UIScrollViewKeyboardDismissModeOnDragWithAccessory")]
    pub const OnDragWithAccessory: Self = Self(3);
    #[doc(alias = "UIScrollViewKeyboardDismissModeInteractiveWithAccessory")]
    pub const InteractiveWithAccessory: Self = Self(4);
}

unsafe impl Encode for UIScrollViewKeyboardDismissMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIScrollViewKeyboardDismissMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrollviewindexdisplaymode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIScrollViewIndexDisplayMode(pub NSInteger);
impl UIScrollViewIndexDisplayMode {
    #[doc(alias = "UIScrollViewIndexDisplayModeAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "UIScrollViewIndexDisplayModeAlwaysHidden")]
    pub const AlwaysHidden: Self = Self(1);
}

unsafe impl Encode for UIScrollViewIndexDisplayMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIScrollViewIndexDisplayMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrollviewcontentinsetadjustmentbehavior?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIScrollViewContentInsetAdjustmentBehavior(pub NSInteger);
impl UIScrollViewContentInsetAdjustmentBehavior {
    #[doc(alias = "UIScrollViewContentInsetAdjustmentAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "UIScrollViewContentInsetAdjustmentScrollableAxes")]
    pub const ScrollableAxes: Self = Self(1);
    #[doc(alias = "UIScrollViewContentInsetAdjustmentNever")]
    pub const Never: Self = Self(2);
    #[doc(alias = "UIScrollViewContentInsetAdjustmentAlways")]
    pub const Always: Self = Self(3);
}

unsafe impl Encode for UIScrollViewContentInsetAdjustmentBehavior {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIScrollViewContentInsetAdjustmentBehavior {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrollviewdecelerationrate?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "objc2-core-foundation")]
pub type UIScrollViewDecelerationRate = CGFloat;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrollviewdecelerationratenormal?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIScrollViewDecelerationRateNormal: UIScrollViewDecelerationRate;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrollviewdecelerationratefast?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIScrollViewDecelerationRateFast: UIScrollViewDecelerationRate;
}

extern_class!(
    /// Styles for a scroll view's edge effect.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrolledgeeffectstyle?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIScrollEdgeEffectStyle;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIScrollEdgeEffectStyle {}
);

impl UIScrollEdgeEffectStyle {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        /// The automatic scroll edge effect style.
        #[unsafe(method(automaticStyle))]
        #[unsafe(method_family = none)]
        pub fn automaticStyle(mtm: MainThreadMarker) -> Retained<UIScrollEdgeEffectStyle>;

        /// A soft-edged scroll edge effect.
        #[unsafe(method(softStyle))]
        #[unsafe(method_family = none)]
        pub fn softStyle(mtm: MainThreadMarker) -> Retained<UIScrollEdgeEffectStyle>;

        /// A scroll edge effect with a hard cutoff and dividing line.
        #[unsafe(method(hardStyle))]
        #[unsafe(method_family = none)]
        pub fn hardStyle(mtm: MainThreadMarker) -> Retained<UIScrollEdgeEffectStyle>;
    );
}

extern_class!(
    /// Properties of the effect on a particular edge of the scroll view.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrolledgeeffect?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIScrollEdgeEffect;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIScrollEdgeEffect {}
);

impl UIScrollEdgeEffect {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        /// The style of this edge effect.
        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub fn style(&self) -> Retained<UIScrollEdgeEffectStyle>;

        /// Setter for [`style`][Self::style].
        #[unsafe(method(setStyle:))]
        #[unsafe(method_family = none)]
        pub fn setStyle(&self, style: &UIScrollEdgeEffectStyle);

        /// Whether this edge effect is hidden.
        /// Default: false
        #[unsafe(method(isHidden))]
        #[unsafe(method_family = none)]
        pub fn isHidden(&self) -> bool;

        /// Setter for [`isHidden`][Self::isHidden].
        #[unsafe(method(setHidden:))]
        #[unsafe(method_family = none)]
        pub fn setHidden(&self, hidden: bool);
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrollview?language=objc)
    #[unsafe(super(UIView, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "UIResponder", feature = "UIView"))]
    pub struct UIScrollView;
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIView",
    feature = "objc2-quartz-core"
))]
#[cfg(not(target_os = "watchos"))]
extern_conformance!(
    unsafe impl CALayerDelegate for UIScrollView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSCoding for UIScrollView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIScrollView {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIAppearance for UIScrollView {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UIScrollView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UICoordinateSpace for UIScrollView {}
);

#[cfg(all(
    feature = "UIDynamicBehavior",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIDynamicItem for UIScrollView {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UIScrollView {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIFocusItem for UIScrollView {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIFocusItemContainer for UIScrollView {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIFocusItemScrollableContainer for UIScrollView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UIScrollView {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UITraitCollection",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UIScrollView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
impl UIScrollView {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(contentOffset))]
        #[unsafe(method_family = none)]
        pub fn contentOffset(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`contentOffset`][Self::contentOffset].
        #[unsafe(method(setContentOffset:))]
        #[unsafe(method_family = none)]
        pub fn setContentOffset(&self, content_offset: CGPoint);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(contentSize))]
        #[unsafe(method_family = none)]
        pub fn contentSize(&self) -> CGSize;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`contentSize`][Self::contentSize].
        #[unsafe(method(setContentSize:))]
        #[unsafe(method_family = none)]
        pub fn setContentSize(&self, content_size: CGSize);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(contentInset))]
        #[unsafe(method_family = none)]
        pub fn contentInset(&self) -> UIEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`contentInset`][Self::contentInset].
        #[unsafe(method(setContentInset:))]
        #[unsafe(method_family = none)]
        pub fn setContentInset(&self, content_inset: UIEdgeInsets);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(contentAlignmentPoint))]
        #[unsafe(method_family = none)]
        pub fn contentAlignmentPoint(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`contentAlignmentPoint`][Self::contentAlignmentPoint].
        #[unsafe(method(setContentAlignmentPoint:))]
        #[unsafe(method_family = none)]
        pub fn setContentAlignmentPoint(&self, content_alignment_point: CGPoint);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(adjustedContentInset))]
        #[unsafe(method_family = none)]
        pub fn adjustedContentInset(&self) -> UIEdgeInsets;

        #[unsafe(method(adjustedContentInsetDidChange))]
        #[unsafe(method_family = none)]
        pub fn adjustedContentInsetDidChange(&self);

        #[unsafe(method(contentInsetAdjustmentBehavior))]
        #[unsafe(method_family = none)]
        pub fn contentInsetAdjustmentBehavior(&self) -> UIScrollViewContentInsetAdjustmentBehavior;

        /// Setter for [`contentInsetAdjustmentBehavior`][Self::contentInsetAdjustmentBehavior].
        #[unsafe(method(setContentInsetAdjustmentBehavior:))]
        #[unsafe(method_family = none)]
        pub fn setContentInsetAdjustmentBehavior(
            &self,
            content_inset_adjustment_behavior: UIScrollViewContentInsetAdjustmentBehavior,
        );

        #[unsafe(method(automaticallyAdjustsScrollIndicatorInsets))]
        #[unsafe(method_family = none)]
        pub fn automaticallyAdjustsScrollIndicatorInsets(&self) -> bool;

        /// Setter for [`automaticallyAdjustsScrollIndicatorInsets`][Self::automaticallyAdjustsScrollIndicatorInsets].
        #[unsafe(method(setAutomaticallyAdjustsScrollIndicatorInsets:))]
        #[unsafe(method_family = none)]
        pub fn setAutomaticallyAdjustsScrollIndicatorInsets(
            &self,
            automatically_adjusts_scroll_indicator_insets: bool,
        );

        #[cfg(feature = "UILayoutGuide")]
        #[unsafe(method(contentLayoutGuide))]
        #[unsafe(method_family = none)]
        pub fn contentLayoutGuide(&self) -> Retained<UILayoutGuide>;

        #[cfg(feature = "UILayoutGuide")]
        #[unsafe(method(frameLayoutGuide))]
        #[unsafe(method_family = none)]
        pub fn frameLayoutGuide(&self) -> Retained<UILayoutGuide>;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn UIScrollViewDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn UIScrollViewDelegate>>,
        );

        #[unsafe(method(isDirectionalLockEnabled))]
        #[unsafe(method_family = none)]
        pub fn isDirectionalLockEnabled(&self) -> bool;

        /// Setter for [`isDirectionalLockEnabled`][Self::isDirectionalLockEnabled].
        #[unsafe(method(setDirectionalLockEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setDirectionalLockEnabled(&self, directional_lock_enabled: bool);

        #[unsafe(method(bounces))]
        #[unsafe(method_family = none)]
        pub fn bounces(&self) -> bool;

        /// Setter for [`bounces`][Self::bounces].
        #[unsafe(method(setBounces:))]
        #[unsafe(method_family = none)]
        pub fn setBounces(&self, bounces: bool);

        #[unsafe(method(bouncesHorizontally))]
        #[unsafe(method_family = none)]
        pub fn bouncesHorizontally(&self) -> bool;

        /// Setter for [`bouncesHorizontally`][Self::bouncesHorizontally].
        #[unsafe(method(setBouncesHorizontally:))]
        #[unsafe(method_family = none)]
        pub fn setBouncesHorizontally(&self, bounces_horizontally: bool);

        #[unsafe(method(bouncesVertically))]
        #[unsafe(method_family = none)]
        pub fn bouncesVertically(&self) -> bool;

        /// Setter for [`bouncesVertically`][Self::bouncesVertically].
        #[unsafe(method(setBouncesVertically:))]
        #[unsafe(method_family = none)]
        pub fn setBouncesVertically(&self, bounces_vertically: bool);

        #[unsafe(method(alwaysBounceVertical))]
        #[unsafe(method_family = none)]
        pub fn alwaysBounceVertical(&self) -> bool;

        /// Setter for [`alwaysBounceVertical`][Self::alwaysBounceVertical].
        #[unsafe(method(setAlwaysBounceVertical:))]
        #[unsafe(method_family = none)]
        pub fn setAlwaysBounceVertical(&self, always_bounce_vertical: bool);

        #[unsafe(method(alwaysBounceHorizontal))]
        #[unsafe(method_family = none)]
        pub fn alwaysBounceHorizontal(&self) -> bool;

        /// Setter for [`alwaysBounceHorizontal`][Self::alwaysBounceHorizontal].
        #[unsafe(method(setAlwaysBounceHorizontal:))]
        #[unsafe(method_family = none)]
        pub fn setAlwaysBounceHorizontal(&self, always_bounce_horizontal: bool);

        #[unsafe(method(isPagingEnabled))]
        #[unsafe(method_family = none)]
        pub fn isPagingEnabled(&self) -> bool;

        /// Setter for [`isPagingEnabled`][Self::isPagingEnabled].
        #[unsafe(method(setPagingEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setPagingEnabled(&self, paging_enabled: bool);

        #[unsafe(method(isScrollEnabled))]
        #[unsafe(method_family = none)]
        pub fn isScrollEnabled(&self) -> bool;

        /// Setter for [`isScrollEnabled`][Self::isScrollEnabled].
        #[unsafe(method(setScrollEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setScrollEnabled(&self, scroll_enabled: bool);

        #[unsafe(method(transfersHorizontalScrollingToParent))]
        #[unsafe(method_family = none)]
        pub fn transfersHorizontalScrollingToParent(&self) -> bool;

        /// Setter for [`transfersHorizontalScrollingToParent`][Self::transfersHorizontalScrollingToParent].
        #[unsafe(method(setTransfersHorizontalScrollingToParent:))]
        #[unsafe(method_family = none)]
        pub fn setTransfersHorizontalScrollingToParent(
            &self,
            transfers_horizontal_scrolling_to_parent: bool,
        );

        #[unsafe(method(transfersVerticalScrollingToParent))]
        #[unsafe(method_family = none)]
        pub fn transfersVerticalScrollingToParent(&self) -> bool;

        /// Setter for [`transfersVerticalScrollingToParent`][Self::transfersVerticalScrollingToParent].
        #[unsafe(method(setTransfersVerticalScrollingToParent:))]
        #[unsafe(method_family = none)]
        pub fn setTransfersVerticalScrollingToParent(
            &self,
            transfers_vertical_scrolling_to_parent: bool,
        );

        #[unsafe(method(showsVerticalScrollIndicator))]
        #[unsafe(method_family = none)]
        pub fn showsVerticalScrollIndicator(&self) -> bool;

        /// Setter for [`showsVerticalScrollIndicator`][Self::showsVerticalScrollIndicator].
        #[unsafe(method(setShowsVerticalScrollIndicator:))]
        #[unsafe(method_family = none)]
        pub fn setShowsVerticalScrollIndicator(&self, shows_vertical_scroll_indicator: bool);

        #[unsafe(method(showsHorizontalScrollIndicator))]
        #[unsafe(method_family = none)]
        pub fn showsHorizontalScrollIndicator(&self) -> bool;

        /// Setter for [`showsHorizontalScrollIndicator`][Self::showsHorizontalScrollIndicator].
        #[unsafe(method(setShowsHorizontalScrollIndicator:))]
        #[unsafe(method_family = none)]
        pub fn setShowsHorizontalScrollIndicator(&self, shows_horizontal_scroll_indicator: bool);

        #[unsafe(method(indicatorStyle))]
        #[unsafe(method_family = none)]
        pub fn indicatorStyle(&self) -> UIScrollViewIndicatorStyle;

        /// Setter for [`indicatorStyle`][Self::indicatorStyle].
        #[unsafe(method(setIndicatorStyle:))]
        #[unsafe(method_family = none)]
        pub fn setIndicatorStyle(&self, indicator_style: UIScrollViewIndicatorStyle);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(verticalScrollIndicatorInsets))]
        #[unsafe(method_family = none)]
        pub fn verticalScrollIndicatorInsets(&self) -> UIEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`verticalScrollIndicatorInsets`][Self::verticalScrollIndicatorInsets].
        #[unsafe(method(setVerticalScrollIndicatorInsets:))]
        #[unsafe(method_family = none)]
        pub fn setVerticalScrollIndicatorInsets(
            &self,
            vertical_scroll_indicator_insets: UIEdgeInsets,
        );

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(horizontalScrollIndicatorInsets))]
        #[unsafe(method_family = none)]
        pub fn horizontalScrollIndicatorInsets(&self) -> UIEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`horizontalScrollIndicatorInsets`][Self::horizontalScrollIndicatorInsets].
        #[unsafe(method(setHorizontalScrollIndicatorInsets:))]
        #[unsafe(method_family = none)]
        pub fn setHorizontalScrollIndicatorInsets(
            &self,
            horizontal_scroll_indicator_insets: UIEdgeInsets,
        );

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(scrollIndicatorInsets))]
        #[unsafe(method_family = none)]
        pub fn scrollIndicatorInsets(&self) -> UIEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`scrollIndicatorInsets`][Self::scrollIndicatorInsets].
        #[unsafe(method(setScrollIndicatorInsets:))]
        #[unsafe(method_family = none)]
        pub fn setScrollIndicatorInsets(&self, scroll_indicator_insets: UIEdgeInsets);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(decelerationRate))]
        #[unsafe(method_family = none)]
        pub fn decelerationRate(&self) -> UIScrollViewDecelerationRate;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`decelerationRate`][Self::decelerationRate].
        #[unsafe(method(setDecelerationRate:))]
        #[unsafe(method_family = none)]
        pub fn setDecelerationRate(&self, deceleration_rate: UIScrollViewDecelerationRate);

        #[unsafe(method(indexDisplayMode))]
        #[unsafe(method_family = none)]
        pub fn indexDisplayMode(&self) -> UIScrollViewIndexDisplayMode;

        /// Setter for [`indexDisplayMode`][Self::indexDisplayMode].
        #[unsafe(method(setIndexDisplayMode:))]
        #[unsafe(method_family = none)]
        pub fn setIndexDisplayMode(&self, index_display_mode: UIScrollViewIndexDisplayMode);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setContentOffset:animated:))]
        #[unsafe(method_family = none)]
        pub fn setContentOffset_animated(&self, content_offset: CGPoint, animated: bool);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(scrollRectToVisible:animated:))]
        #[unsafe(method_family = none)]
        pub fn scrollRectToVisible_animated(&self, rect: CGRect, animated: bool);

        #[unsafe(method(flashScrollIndicators))]
        #[unsafe(method_family = none)]
        pub fn flashScrollIndicators(&self);

        #[cfg(feature = "block2")]
        #[unsafe(method(withScrollIndicatorsShownForContentOffsetChanges:))]
        #[unsafe(method_family = none)]
        pub fn withScrollIndicatorsShownForContentOffsetChanges(
            &self,
            changes: &block2::DynBlock<dyn Fn() + '_>,
        );

        /// The effect for the top edge of the scroll view.
        #[unsafe(method(topEdgeEffect))]
        #[unsafe(method_family = none)]
        pub fn topEdgeEffect(&self) -> Retained<UIScrollEdgeEffect>;

        /// The effect for the left edge of the scroll view.
        #[unsafe(method(leftEdgeEffect))]
        #[unsafe(method_family = none)]
        pub fn leftEdgeEffect(&self) -> Retained<UIScrollEdgeEffect>;

        /// The effect for the bottom edge of the scroll view.
        #[unsafe(method(bottomEdgeEffect))]
        #[unsafe(method_family = none)]
        pub fn bottomEdgeEffect(&self) -> Retained<UIScrollEdgeEffect>;

        /// The effect for the right edge of the scroll view.
        #[unsafe(method(rightEdgeEffect))]
        #[unsafe(method_family = none)]
        pub fn rightEdgeEffect(&self) -> Retained<UIScrollEdgeEffect>;

        #[unsafe(method(isTracking))]
        #[unsafe(method_family = none)]
        pub fn isTracking(&self) -> bool;

        #[unsafe(method(isDragging))]
        #[unsafe(method_family = none)]
        pub fn isDragging(&self) -> bool;

        #[unsafe(method(isDecelerating))]
        #[unsafe(method_family = none)]
        pub fn isDecelerating(&self) -> bool;

        #[unsafe(method(isScrollAnimating))]
        #[unsafe(method_family = none)]
        pub fn isScrollAnimating(&self) -> bool;

        #[unsafe(method(delaysContentTouches))]
        #[unsafe(method_family = none)]
        pub fn delaysContentTouches(&self) -> bool;

        /// Setter for [`delaysContentTouches`][Self::delaysContentTouches].
        #[unsafe(method(setDelaysContentTouches:))]
        #[unsafe(method_family = none)]
        pub fn setDelaysContentTouches(&self, delays_content_touches: bool);

        #[unsafe(method(canCancelContentTouches))]
        #[unsafe(method_family = none)]
        pub fn canCancelContentTouches(&self) -> bool;

        /// Setter for [`canCancelContentTouches`][Self::canCancelContentTouches].
        #[unsafe(method(setCanCancelContentTouches:))]
        #[unsafe(method_family = none)]
        pub fn setCanCancelContentTouches(&self, can_cancel_content_touches: bool);

        #[cfg(all(feature = "UIEvent", feature = "UITouch"))]
        #[unsafe(method(touchesShouldBegin:withEvent:inContentView:))]
        #[unsafe(method_family = none)]
        pub fn touchesShouldBegin_withEvent_inContentView(
            &self,
            touches: &NSSet<UITouch>,
            event: Option<&UIEvent>,
            view: &UIView,
        ) -> bool;

        #[unsafe(method(touchesShouldCancelInContentView:))]
        #[unsafe(method_family = none)]
        pub fn touchesShouldCancelInContentView(&self, view: &UIView) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(minimumZoomScale))]
        #[unsafe(method_family = none)]
        pub fn minimumZoomScale(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`minimumZoomScale`][Self::minimumZoomScale].
        #[unsafe(method(setMinimumZoomScale:))]
        #[unsafe(method_family = none)]
        pub fn setMinimumZoomScale(&self, minimum_zoom_scale: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(maximumZoomScale))]
        #[unsafe(method_family = none)]
        pub fn maximumZoomScale(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`maximumZoomScale`][Self::maximumZoomScale].
        #[unsafe(method(setMaximumZoomScale:))]
        #[unsafe(method_family = none)]
        pub fn setMaximumZoomScale(&self, maximum_zoom_scale: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(zoomScale))]
        #[unsafe(method_family = none)]
        pub fn zoomScale(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`zoomScale`][Self::zoomScale].
        #[unsafe(method(setZoomScale:))]
        #[unsafe(method_family = none)]
        pub fn setZoomScale(&self, zoom_scale: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setZoomScale:animated:))]
        #[unsafe(method_family = none)]
        pub fn setZoomScale_animated(&self, scale: CGFloat, animated: bool);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(zoomToRect:animated:))]
        #[unsafe(method_family = none)]
        pub fn zoomToRect_animated(&self, rect: CGRect, animated: bool);

        #[unsafe(method(bouncesZoom))]
        #[unsafe(method_family = none)]
        pub fn bouncesZoom(&self) -> bool;

        /// Setter for [`bouncesZoom`][Self::bouncesZoom].
        #[unsafe(method(setBouncesZoom:))]
        #[unsafe(method_family = none)]
        pub fn setBouncesZoom(&self, bounces_zoom: bool);

        #[unsafe(method(isZooming))]
        #[unsafe(method_family = none)]
        pub fn isZooming(&self) -> bool;

        #[unsafe(method(isZoomBouncing))]
        #[unsafe(method_family = none)]
        pub fn isZoomBouncing(&self) -> bool;

        #[unsafe(method(isZoomAnimating))]
        #[unsafe(method_family = none)]
        pub fn isZoomAnimating(&self) -> bool;

        #[unsafe(method(scrollsToTop))]
        #[unsafe(method_family = none)]
        pub fn scrollsToTop(&self) -> bool;

        /// Setter for [`scrollsToTop`][Self::scrollsToTop].
        #[unsafe(method(setScrollsToTop:))]
        #[unsafe(method_family = none)]
        pub fn setScrollsToTop(&self, scrolls_to_top: bool);

        #[unsafe(method(stopScrollingAndZooming))]
        #[unsafe(method_family = none)]
        pub fn stopScrollingAndZooming(&self);

        #[cfg(all(feature = "UIGestureRecognizer", feature = "UIPanGestureRecognizer"))]
        #[unsafe(method(panGestureRecognizer))]
        #[unsafe(method_family = none)]
        pub fn panGestureRecognizer(&self) -> Retained<UIPanGestureRecognizer>;

        #[cfg(all(feature = "UIGestureRecognizer", feature = "UIPinchGestureRecognizer"))]
        #[unsafe(method(pinchGestureRecognizer))]
        #[unsafe(method_family = none)]
        pub fn pinchGestureRecognizer(&self) -> Option<Retained<UIPinchGestureRecognizer>>;

        #[cfg(feature = "UIGestureRecognizer")]
        #[deprecated = "Configuring the panGestureRecognizer for indirect scrolling automatically supports directional presses now, so this property is no longer useful."]
        #[unsafe(method(directionalPressGestureRecognizer))]
        #[unsafe(method_family = none)]
        pub fn directionalPressGestureRecognizer(&self) -> Retained<UIGestureRecognizer>;

        #[unsafe(method(keyboardDismissMode))]
        #[unsafe(method_family = none)]
        pub fn keyboardDismissMode(&self) -> UIScrollViewKeyboardDismissMode;

        /// Setter for [`keyboardDismissMode`][Self::keyboardDismissMode].
        #[unsafe(method(setKeyboardDismissMode:))]
        #[unsafe(method_family = none)]
        pub fn setKeyboardDismissMode(
            &self,
            keyboard_dismiss_mode: UIScrollViewKeyboardDismissMode,
        );

        #[cfg(all(feature = "UIControl", feature = "UIRefreshControl"))]
        #[unsafe(method(refreshControl))]
        #[unsafe(method_family = none)]
        pub fn refreshControl(&self) -> Option<Retained<UIRefreshControl>>;

        #[cfg(all(feature = "UIControl", feature = "UIRefreshControl"))]
        /// Setter for [`refreshControl`][Self::refreshControl].
        #[unsafe(method(setRefreshControl:))]
        #[unsafe(method_family = none)]
        pub fn setRefreshControl(&self, refresh_control: Option<&UIRefreshControl>);

        /// Set this to YES to make the scroll view animate its content offset in response to keys like Page Up/Down, Home/End, and the arrow keys.
        /// The scroll view must be focused or first responder in order to receive these key events. Default is YES for apps linked after iOS 17.0.
        #[unsafe(method(allowsKeyboardScrolling))]
        #[unsafe(method_family = none)]
        pub fn allowsKeyboardScrolling(&self) -> bool;

        /// Setter for [`allowsKeyboardScrolling`][Self::allowsKeyboardScrolling].
        #[unsafe(method(setAllowsKeyboardScrolling:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsKeyboardScrolling(&self, allows_keyboard_scrolling: bool);

        #[cfg(feature = "UIGeometry")]
        /// Defines which axes are considered for Look to Scroll.
        /// Does not affect when isPagingEnabled is true.
        #[unsafe(method(lookToScrollAxes))]
        #[unsafe(method_family = none)]
        pub fn lookToScrollAxes(&self) -> UIAxis;

        #[cfg(feature = "UIGeometry")]
        /// Setter for [`lookToScrollAxes`][Self::lookToScrollAxes].
        #[unsafe(method(setLookToScrollAxes:))]
        #[unsafe(method_family = none)]
        pub fn setLookToScrollAxes(&self, look_to_scroll_axes: UIAxis);
    );
}

/// Methods declared on superclass `UIView`.
#[cfg(all(feature = "UIResponder", feature = "UIView"))]
impl UIScrollView {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame: CGRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "UIResponder", feature = "UIView"))]
impl UIScrollView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscrollviewdelegate?language=objc)
    pub unsafe trait UIScrollViewDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewDidScroll:))]
        #[unsafe(method_family = none)]
        fn scrollViewDidScroll(&self, scroll_view: &UIScrollView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewDidZoom:))]
        #[unsafe(method_family = none)]
        fn scrollViewDidZoom(&self, scroll_view: &UIScrollView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewWillBeginDragging:))]
        #[unsafe(method_family = none)]
        fn scrollViewWillBeginDragging(&self, scroll_view: &UIScrollView);

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIView",
            feature = "objc2-core-foundation"
        ))]
        /// # Safety
        ///
        /// `target_content_offset` must be a valid pointer.
        #[optional]
        #[unsafe(method(scrollViewWillEndDragging:withVelocity:targetContentOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn scrollViewWillEndDragging_withVelocity_targetContentOffset(
            &self,
            scroll_view: &UIScrollView,
            velocity: CGPoint,
            target_content_offset: NonNull<CGPoint>,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewDidEndDragging:willDecelerate:))]
        #[unsafe(method_family = none)]
        fn scrollViewDidEndDragging_willDecelerate(
            &self,
            scroll_view: &UIScrollView,
            decelerate: bool,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewWillBeginDecelerating:))]
        #[unsafe(method_family = none)]
        fn scrollViewWillBeginDecelerating(&self, scroll_view: &UIScrollView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewDidEndDecelerating:))]
        #[unsafe(method_family = none)]
        fn scrollViewDidEndDecelerating(&self, scroll_view: &UIScrollView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewDidEndScrollingAnimation:))]
        #[unsafe(method_family = none)]
        fn scrollViewDidEndScrollingAnimation(&self, scroll_view: &UIScrollView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(viewForZoomingInScrollView:))]
        #[unsafe(method_family = none)]
        fn viewForZoomingInScrollView(
            &self,
            scroll_view: &UIScrollView,
        ) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewWillBeginZooming:withView:))]
        #[unsafe(method_family = none)]
        fn scrollViewWillBeginZooming_withView(
            &self,
            scroll_view: &UIScrollView,
            view: Option<&UIView>,
        );

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(scrollViewDidEndZooming:withView:atScale:))]
        #[unsafe(method_family = none)]
        fn scrollViewDidEndZooming_withView_atScale(
            &self,
            scroll_view: &UIScrollView,
            view: Option<&UIView>,
            scale: CGFloat,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewShouldScrollToTop:))]
        #[unsafe(method_family = none)]
        fn scrollViewShouldScrollToTop(&self, scroll_view: &UIScrollView) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewDidScrollToTop:))]
        #[unsafe(method_family = none)]
        fn scrollViewDidScrollToTop(&self, scroll_view: &UIScrollView);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(scrollViewDidChangeAdjustedContentInset:))]
        #[unsafe(method_family = none)]
        fn scrollViewDidChangeAdjustedContentInset(&self, scroll_view: &UIScrollView);
    }
);
