/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.sc;

import chiropraxis.sc.RotamerDef;
import chiropraxis.sc.SidechainAngles2;
import chiropraxis.sc.SidechainIdealizer;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Builder;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class RotamersForTerwilliger {
    String DUMMY_GLY_ALA = "     1    GLY  ! RESIDUE ID -----------------------\n   4  ! N_ATOMS\n   1  ! N_GROUP\n   1  ! I_GROUP ---------------\n    1.46    0.00    0.00  N     ! XYZ\n    0.00    0.00    0.00  CA    ! XYZ\n   -0.53    1.43    0.00  C     ! XYZ\n    0.21    2.39   -0.13  O     ! XYZ\n     2    ALA  ! RESIDUE ID -----------------------\n   5  ! N_ATOMS\n   1  ! N_GROUP\n   1  ! I_GROUP ---------------\n    1.45    0.00    0.00  N     ! XYZ\n    0.00    0.00    0.00  CA    ! XYZ\n   -0.49    1.44    0.00  C     ! XYZ\n   -0.61    2.07   -1.04  O     ! XYZ\n   -0.53   -0.77    1.20  CB    ! XYZ";

    void writeRotamers(PrintStream printStream) throws IOException {
        String[] stringArray = new String[]{"GLY", "ALA", "SER", "VAL", "ILE", "LEU", "MET", "CYS", "PHE", "TYR", "LYS", "ARG", "TRP", "HIS", "GLU", "ASP", "GLN", "ASN", "PRO", "THR"};
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        SidechainIdealizer sidechainIdealizer = new SidechainIdealizer();
        SidechainAngles2 sidechainAngles2 = new SidechainAngles2();
        Builder builder = new Builder();
        printStream.println(this.DUMMY_GLY_ALA);
        for (int i = 2; i < stringArray.length; ++i) {
            Object object;
            RotamerDef[] rotamerDefArray;
            Cloneable cloneable;
            Object object2;
            printStream.println(Strings.justifyRight("" + (i + 1), 6) + "    " + stringArray[i] + "  ! RESIDUE ID -----------------------");
            ModelState modelState = new ModelState();
            Residue residue = sidechainIdealizer.makeIdealResidue(" ", "", Integer.toString(i + 1), " ", stringArray[i], modelState);
            modelState = modelState.createCollapsed();
            try {
                object2 = modelState.get(residue.getAtom(" N  "));
                cloneable = modelState.get(residue.getAtom(" CA "));
                rotamerDefArray = modelState.get(residue.getAtom(" C  "));
                Object object3 = builder.dock3on3(new Triple(0.0, 0.0, 0.0), new Triple(1.0, 0.0, 0.0), new Triple(0.0, 1.0, 0.0), (Tuple3)((Object)cloneable), (Tuple3)object2, (Tuple3)rotamerDefArray);
                object = modelState.getLocalStateMap().values().iterator();
                while (object.hasNext()) {
                    ((Transform)object3).transform((AtomState)object.next());
                }
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
            object2 = modelState;
            cloneable = new ArrayList();
            for (Object object3 : residue.getAtoms()) {
                if (((Atom)object3).getName().charAt(1) == 'H') continue;
                cloneable.add(object3);
            }
            printStream.println(Strings.justifyRight("" + cloneable.size(), 4) + "  ! N_ATOMS");
            rotamerDefArray = sidechainAngles2.getAllRotamers(residue);
            printStream.println(Strings.justifyRight("" + rotamerDefArray.length, 4) + "  ! N_GROUP");
            for (int j = 0; j < rotamerDefArray.length; ++j) {
                printStream.println(Strings.justifyRight("" + (j + 1), 4) + "  ! I_GROUP --------------- " + rotamerDefArray[j].toString());
                object = sidechainAngles2.setChiAngles(residue, (ModelState)object2, rotamerDefArray[j].chiAngles);
                Iterator iterator = cloneable.iterator();
                while (iterator.hasNext()) {
                    try {
                        Atom atom = (Atom)iterator.next();
                        AtomState atomState = ((ModelState)object).get(atom);
                        printStream.println(Strings.justifyRight(decimalFormat.format(atomState.getX()), 8) + Strings.justifyRight(decimalFormat.format(atomState.getY()), 8) + Strings.justifyRight(decimalFormat.format(atomState.getZ()), 8) + " " + atom.getName() + "   ! XYZ");
                    }
                    catch (AtomException atomException) {
                        atomException.printStackTrace();
                    }
                }
            }
        }
    }

    public void Main() {
        try {
            this.writeRotamers(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        RotamersForTerwilliger rotamersForTerwilliger = new RotamersForTerwilliger();
        try {
            rotamersForTerwilliger.parseArguments(stringArray);
            rotamersForTerwilliger.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            rotamersForTerwilliger.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("RotamersForTerwilliger.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'RotamersForTerwilliger.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.sc.RotamersForTerwilliger");
        System.err.println("Copyright (C) 2004 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

