/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.NDFloatTable;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Ramachandran {
    public static final double ALL_FAVORED = 0.02;
    public static final double GENERAL_ALLOWED = 5.0E-4;
    public static final double OTHER_ALLOWED = 0.002;
    private static Ramachandran instance = null;
    float[] phipsi = new float[2];
    NDFloatTable genTable = null;
    NDFloatTable glyTable = null;
    NDFloatTable proTable = null;
    NDFloatTable preproTable = null;

    public static Ramachandran getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        instance = new Ramachandran();
        return instance;
    }

    public static void freeInstance() {
        instance = null;
    }

    private Ramachandran() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("rama/general.ndft");
        InputStream inputStream2 = this.getClass().getResourceAsStream("rama/glycine.ndft");
        InputStream inputStream3 = this.getClass().getResourceAsStream("rama/proline.ndft");
        InputStream inputStream4 = this.getClass().getResourceAsStream("rama/prepro.ndft");
        if (inputStream == null || inputStream2 == null || inputStream3 == null || inputStream4 == null) {
            throw new IOException("Could not find required .ndft files");
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        this.genTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream2));
        this.glyTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream3));
        this.proTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream4));
        this.preproTable = new NDFloatTable(dataInputStream);
        inputStream.close();
        inputStream2.close();
        inputStream3.close();
        inputStream4.close();
    }

    public double rawScore(Model model, Residue residue, ModelState modelState) throws ResidueException {
        double d;
        double d2;
        try {
            d2 = AminoAcid.getPhi(model, residue, modelState);
            d = AminoAcid.getPsi(model, residue, modelState);
        }
        catch (AtomException atomException) {
            throw new ResidueException("Can't get Ramachandran score for " + residue + ": " + atomException.getMessage());
        }
        this.phipsi[0] = (float)d2;
        this.phipsi[1] = (float)d;
        String string = residue.getName();
        double d3 = string.equals("GLY") ? (double)this.glyTable.valueAt(this.phipsi) : (string.equals("PRO") ? (double)this.proTable.valueAt(this.phipsi) : (AminoAcid.isPrepro(model, residue, modelState) ? (double)this.preproTable.valueAt(this.phipsi) : (double)this.genTable.valueAt(this.phipsi)));
        return d3;
    }

    public boolean isOutlier(Model model, Residue residue, ModelState modelState) {
        String string = "GLY,ALA,VAL,LEU,ILE,PRO,PHE,TYR,TRP,SER,THR,CYS,MET,MSE,LYS,HIS,ARG,ASP,ASN,GLN,GLU";
        String string2 = residue.getName();
        if (string.indexOf(string2) == -1) {
            return false;
        }
        try {
            double d = this.rawScore(model, residue, modelState);
            if (string2.equals("GLY") || string2.equals("PRO") || AminoAcid.isPrepro(model, residue, modelState)) {
                return d < 0.002;
            }
            return d < 5.0E-4;
        }
        catch (ResidueException residueException) {
            return false;
        }
    }
}

