/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.data.CheapSet;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Tuple3;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class AlignChains {
    String fileName = null;
    String refChainID = null;
    Collection mobChainIDs = new ArrayList();

    public Transform optimizeAlignment(Collection collection, Collection collection2, ModelState modelState) {
        Tuple3[] tuple3Array = this.extractCAs(collection, modelState);
        Tuple3[] tuple3Array2 = this.extractCAs(collection2, modelState);
        int n = Math.min(tuple3Array.length, tuple3Array2.length);
        int n2 = Math.max(tuple3Array.length, tuple3Array2.length) - n;
        Transform transform = null;
        double d = Double.POSITIVE_INFINITY;
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        for (int i = 0; i <= n2; ++i) {
            Transform transform2;
            int n3;
            int n4 = tuple3Array.length == n ? 0 : i;
            SuperPoser superPoser = new SuperPoser(tuple3Array, n4, tuple3Array2, n3 = tuple3Array2.length == n ? 0 : i, n);
            double d2 = superPoser.calcRMSD(transform2 = superPoser.superpos());
            if (!(d2 < d)) continue;
            transform = transform2;
            d = d2;
        }
        System.err.println("Best Ca RMSD: " + decimalFormat.format(d));
        return transform;
    }

    AtomState[] extractCAs(Collection collection, ModelState modelState) {
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        for (Residue residue : collection) {
            try {
                arrayList.add(modelState.get(residue.getAtom(" CA ")));
            }
            catch (AtomException atomException) {}
        }
        return arrayList.toArray(new AtomState[arrayList.size()]);
    }

    public static Collection extractOrderedStatesByName(Collection collection, Collection collection2) {
        ModelState[] modelStateArray = collection2.toArray(new ModelState[collection2.size()]);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        for (Residue residue : collection) {
            for (Atom atom : residue.getAtoms()) {
                for (int i = 0; i < modelStateArray.length; ++i) {
                    try {
                        AtomState atomState = modelStateArray[i].get(atom);
                        String string = atomState.getAtom().toString() + atomState.getAltConf();
                        if (hashSet.contains(string)) continue;
                        hashSet.add(string);
                        arrayList.add(atomState);
                        continue;
                    }
                    catch (AtomException atomException) {
                        // empty catch block
                    }
                }
            }
        }
        return arrayList;
    }

    public void alignChains(CoordinateFile coordinateFile, String string, Collection collection) {
        for (Model model : coordinateFile.getModels()) {
            Collection collection2 = AlignChains.extractOrderedStatesByName(model.getResidues(), model.getStates().values());
            AtomState[] atomStateArray = collection2.toArray(new AtomState[collection2.size()]);
            for (String string2 : collection) {
                Set set = model.getChain(string);
                Set set2 = model.getChain(string2);
                if (set == null || set2 == null) continue;
                Transform transform = this.optimizeAlignment(set, set2, model.getState());
                CheapSet cheapSet = new CheapSet(set2);
                for (int i = 0; i < atomStateArray.length; ++i) {
                    if (!cheapSet.contains(atomStateArray[i].getResidue())) continue;
                    transform.transform(atomStateArray[i]);
                }
            }
        }
    }

    public void Main() throws IOException {
        if (this.fileName == null) {
            throw new IllegalArgumentException("No PDB specified");
        }
        if (this.refChainID == null) {
            throw new IllegalArgumentException("No reference chain");
        }
        if (this.mobChainIDs.size() < 1) {
            throw new IllegalArgumentException("No mobile chain(s)");
        }
        CoordinateFile coordinateFile = new PdbReader().read(new File(this.fileName));
        this.alignChains(coordinateFile, this.refChainID, this.mobChainIDs);
        new PdbWriter(System.out).writeCoordinateFile(coordinateFile, new HashMap());
    }

    public static void main(String[] stringArray) {
        AlignChains alignChains = new AlignChains();
        try {
            alignChains.parseArguments(stringArray);
            alignChains.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            alignChains.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("AlignChains.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'AlignChains.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.AlignChains");
        System.err.println("Copyright (C) 2005 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.fileName == null) {
            this.fileName = string;
        } else if (this.refChainID == null) {
            this.refChainID = string;
        } else {
            this.mobChainIDs.add(string);
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

